/*
 * Decompiled with CFR 0.152.
 */
package ru.ppland.navigation.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import ru.ppland.navigation.minigame.MiniGame;
import ru.ppland.navigation.minigame.MiniGameCategory;

public class MiniGameRegistry {
    private static final Map<class_2960, MiniGame> MINI_GAMES = new ConcurrentHashMap<class_2960, MiniGame>();
    private static final Map<MiniGameCategory, List<MiniGame>> BY_CATEGORY = new ConcurrentHashMap<MiniGameCategory, List<MiniGame>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "navigation.json");

    public static void initialize() {
        MiniGameRegistry.loadConfig();
    }

    public static void loadConfig() {
        MiniGameRegistry.clear();
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type type = new TypeToken<ArrayList<MiniGameConfig>>(){}.getType();
                List configs = (List)GSON.fromJson((Reader)reader, type);
                if (configs != null) {
                    for (MiniGameConfig config : configs) {
                        MiniGameRegistry.register(config.toMiniGame());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load navigation config, loading defaults.");
                MiniGameRegistry.registerDefaultMiniGames();
            }
        } else {
            MiniGameRegistry.registerDefaultMiniGames();
            MiniGameRegistry.saveConfig();
        }
    }

    public static void saveConfig() {
        ArrayList<MiniGameConfig> configs = new ArrayList<MiniGameConfig>();
        for (MiniGame game : MiniGameRegistry.getAll()) {
            configs.add(new MiniGameConfig(game));
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(configs, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save navigation config.");
        }
    }

    public static void register(MiniGame miniGame) {
        MINI_GAMES.put(miniGame.getId(), miniGame);
        BY_CATEGORY.computeIfAbsent(miniGame.getCategory(), k -> new ArrayList()).add(miniGame);
        BY_CATEGORY.computeIfAbsent(MiniGameCategory.ALL, k -> new ArrayList()).add(miniGame);
    }

    public static List<MiniGame> getAll() {
        return new ArrayList<MiniGame>(MINI_GAMES.values());
    }

    public static List<MiniGame> getByCategory(MiniGameCategory category) {
        return BY_CATEGORY.getOrDefault((Object)category, new ArrayList());
    }

    public static void clear() {
        MINI_GAMES.clear();
        BY_CATEGORY.clear();
    }

    private static void registerDefaultMiniGames() {
        MiniGameRegistry.register(MiniGameRegistry.createGame("bed_wars", "BedWars", MiniGameCategory.PVP, class_1802.field_8789, "bedwars.ppland.ru", 24, 32));
        MiniGameRegistry.register(MiniGameRegistry.createGame("sky_wars", "SkyWars", MiniGameCategory.PVP, class_1802.field_8153, "skywars.ppland.ru", 16, 16));
        MiniGameRegistry.register(MiniGameRegistry.createGame("block_hunt", "BlockHunt", MiniGameCategory.ARCADE, class_1802.field_8270, "blockhunt.ppland.ru", 12, 20));
        MiniGameRegistry.register(MiniGameRegistry.createGame("murder_mystery", "Murder Mystery", MiniGameCategory.ARCADE, class_1802.field_8371, "murder.ppland.ru", 8, 16));
    }

    private static MiniGame createGame(String id, String name, MiniGameCategory category, class_1792 icon, String address, int online, int max) {
        return MiniGame.builder(new class_2960("navigation", id)).name((class_2561)class_2561.method_43470((String)name)).description(Arrays.asList(class_2561.method_43470((String)("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043b\u044f " + name)).method_27692(class_124.field_1080))).displayItem(new class_1799((class_1935)icon)).category(category).serverAddress(address).onlineCount(online).maxPlayers(max).build();
    }

    public static class MiniGameConfig {
        public String id;
        public String name;
        public List<String> description;
        public String itemIcon;
        public String category;
        public String serverAddress;
        public int onlineCount;
        public int maxPlayers;

        public MiniGameConfig() {
        }

        public MiniGameConfig(MiniGame game) {
            this.id = game.getId().toString();
            this.name = class_2561.class_2562.method_10867((class_2561)game.getName());
            ArrayList<String> descJson = new ArrayList<String>();
            for (class_2561 line : game.getDescription()) {
                descJson.add(class_2561.class_2562.method_10867((class_2561)line));
            }
            this.description = descJson;
            this.itemIcon = class_7923.field_41178.method_10221((Object)game.getDisplayItem().method_7909()).toString();
            this.category = game.getCategory().name();
            this.serverAddress = game.getServerAddress();
            this.onlineCount = game.getOnlineCount();
            this.maxPlayers = game.getMaxPlayers();
        }

        public MiniGame toMiniGame() {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(this.itemIcon));
            ArrayList<class_2561> descObject = new ArrayList<class_2561>();
            for (String line : this.description) {
                descObject.add((class_2561)class_2561.class_2562.method_10877((String)line));
            }
            return MiniGame.builder(new class_2960(this.id)).name((class_2561)class_2561.class_2562.method_10877((String)this.name)).description(descObject).displayItem(new class_1799((class_1935)item)).category(MiniGameCategory.valueOf(this.category)).serverAddress(this.serverAddress).onlineCount(this.onlineCount).maxPlayers(this.maxPlayers).build();
        }
    }
}

