/*
 * Decompiled with CFR 0.152.
 */
package ru.ppland.navigation.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import ru.ppland.navigation.client.screen.CategoryButton;
import ru.ppland.navigation.client.screen.MiniGameButton;
import ru.ppland.navigation.minigame.MiniGame;
import ru.ppland.navigation.minigame.MiniGameCategory;
import ru.ppland.navigation.registry.MiniGameRegistry;

@Environment(value=EnvType.CLIENT)
public class NavigatorScreen
extends class_437 {
    private MiniGameCategory selectedCategory = MiniGameCategory.ALL;
    private final List<MiniGameButton> gameButtons = new ArrayList<MiniGameButton>();
    private final List<CategoryButton> categoryButtons = new ArrayList<CategoryButton>();
    private class_342 searchField;
    private int animationTicks = 0;
    private final long randomSeed = new Random().nextLong();

    public NavigatorScreen() {
        super((class_2561)class_2561.method_43470((String)"\u041d\u0430\u0432\u0438\u0433\u0430\u0442\u043e\u0440"));
    }

    public void setSelectedCategory(MiniGameCategory category) {
        this.selectedCategory = category;
    }

    protected void method_25426() {
        super.method_25426();
        this.animationTicks = 0;
        this.method_37067();
        this.gameButtons.clear();
        this.categoryButtons.clear();
        int searchFieldWidth = (int)((double)this.field_22789 * 0.12);
        int searchFieldHeight = 20;
        int searchFieldX = (int)((double)this.field_22789 * 0.02);
        int searchFieldY = (int)((double)this.field_22790 * 0.1);
        this.searchField = new class_342(this.field_22793, searchFieldX, searchFieldY, searchFieldWidth, searchFieldHeight, (class_2561)class_2561.method_43470((String)""));
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"\u041f\u043e\u0438\u0441\u043a...").method_27692(class_124.field_1080));
        this.searchField.method_1863(this::onSearch);
        this.method_37063((class_364)this.searchField);
        this.createCategoryButtons(searchFieldY + searchFieldHeight + 10);
        this.createGameButtons();
    }

    private void createCategoryButtons(int startYOffset) {
        ArrayList<MiniGameCategory> sortedCategories = new ArrayList<MiniGameCategory>();
        sortedCategories.add(MiniGameCategory.ALL);
        for (MiniGameCategory cat : MiniGameCategory.values()) {
            if (cat == MiniGameCategory.ALL) continue;
            sortedCategories.add(cat);
        }
        int buttonWidth = (int)((double)this.field_22789 * 0.12);
        int buttonHeight = (int)((double)this.field_22790 * 0.05);
        int spacingY = (int)((double)this.field_22790 * 0.06);
        int startX = (int)((double)this.field_22789 * 0.02);
        int startY = startYOffset;
        for (int i = 0; i < sortedCategories.size(); ++i) {
            MiniGameCategory category = (MiniGameCategory)((Object)sortedCategories.get(i));
            CategoryButton button = new CategoryButton(startX, startY + i * spacingY, buttonWidth, buttonHeight, category, this::selectCategory);
            if (category == this.selectedCategory) {
                button.setSelected(true);
            }
            this.categoryButtons.add(button);
            this.method_37063((class_364)button);
        }
    }

    private void createGameButtons() {
        this.gameButtons.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.gameButtons.clear();
        List games = MiniGameRegistry.getByCategory(this.selectedCategory).stream().filter(game -> this.searchField == null || game.getName().getString().toLowerCase().contains(this.searchField.method_1882().toLowerCase())).collect(Collectors.toList());
        int columns = 4;
        int buttonSize = (int)((double)this.field_22790 * 0.18);
        int spacing = (int)((double)this.field_22790 * 0.2);
        int startX = (int)((double)this.field_22789 * 0.2);
        int startY = this.field_22790 / 2 - 2 * spacing / 2 + (int)((double)this.field_22790 * 0.05);
        for (int i = 0; i < games.size() && i < 8; ++i) {
            MiniGame game2 = (MiniGame)games.get(i);
            int row = i / columns;
            int col = i % columns;
            MiniGameButton button = new MiniGameButton(startX + col * spacing, startY + row * spacing, buttonSize, buttonSize, game2, this::selectGame);
            this.gameButtons.add(button);
            this.method_37063((class_364)button);
        }
    }

    private void onSearch(String query) {
        this.createGameButtons();
    }

    private void selectCategory(MiniGameCategory category) {
        if (this.selectedCategory != category) {
            this.selectedCategory = category;
            this.playClickSound();
            this.categoryButtons.forEach(btn -> btn.setSelected(btn.getCategory() == category));
            this.createGameButtons();
        }
    }

    private void selectGame(MiniGame game) {
        this.playClickSound();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.method_1562().method_45731("server " + game.getServerAddress());
        }
        this.method_25419();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        ++this.animationTicks;
        this.renderVoxelBackground(context);
        this.renderSearchBox(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderTitle(context);
        this.renderTooltips(context, mouseX, mouseY);
    }

    private void renderSearchBox(class_332 context) {
        int x = this.searchField.method_46426() - 2;
        int y = this.searchField.method_46427() - 2;
        int width = this.searchField.method_25368() + 4;
        int height = this.searchField.method_25364() + 4;
        context.method_25294(x, y, x + width, y + height, -15063760);
        context.method_49601(x, y, width, height, -13877680);
    }

    private void renderVoxelBackground(class_332 context) {
        this.method_25420(context);
        Random random = new Random(this.randomSeed);
        int squareSize = this.field_22789 / 50;
        for (int y = 0; y < this.field_22790; y += squareSize) {
            for (int x = 0; x < this.field_22789; x += squareSize) {
                int color = 32 + random.nextInt(16);
                float animOffset = (float)Math.sin((double)(x + this.animationTicks) * 0.05) * 5.0f + (float)Math.cos((double)(y + this.animationTicks) * 0.05) * 5.0f;
                int finalColor = (int)((float)color + animOffset);
                context.method_25294(x, y, x + squareSize, y + squareSize, Integer.MIN_VALUE | finalColor << 16 | finalColor << 8 | finalColor + 10);
            }
        }
    }

    private void renderTitle(class_332 context) {
        class_5250 title = class_2561.method_43470((String)"\u041d\u0410\u0412\u0418\u0413\u0410\u0422\u041e\u0420").method_27695(new class_124[]{class_124.field_1067, class_124.field_1068});
        context.method_27535(this.field_22793, (class_2561)title, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)title) / 2, (int)((double)this.field_22790 * 0.03), 0xFFFFFF);
    }

    private void renderTooltips(class_332 context, int mouseX, int mouseY) {
        for (MiniGameButton button : this.gameButtons) {
            if (!button.method_49606()) continue;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            MiniGame game = button.getGame();
            tooltip.add(game.getName().method_27661().method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));
            tooltip.addAll(game.getDescription());
            tooltip.add(class_2561.method_43470((String)""));
            tooltip.add(class_2561.method_43470((String)("\u0418\u0433\u0440\u043e\u043a\u043e\u0432: " + game.getOnlineCount() + "/" + game.getMaxPlayers())).method_27692(class_124.field_1080));
            context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
            break;
        }
    }

    private void playClickSound() {
        if (this.field_22787 != null) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
    }

    public boolean method_25421() {
        return false;
    }
}

