/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScrollBar
extends UIBase
implements class_364,
class_4068,
class_6379 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ScrollBarDirection direction;
    public float grabberWidth;
    public float grabberHeight;
    public float scrollAreaStartX;
    public float scrollAreaStartY;
    public float scrollAreaEndX;
    public float scrollAreaEndY;
    public Supplier<DrawableColor> idleBarColor;
    public Supplier<DrawableColor> hoverBarColor;
    public class_2960 idleBarTexture;
    public class_2960 hoverBarTexture;
    public boolean active = true;
    protected boolean allowScrollWheel = false;
    protected float grabberScrollSpeed = 1.0f;
    protected float wheelScrollSpeed = 1.0f;
    protected float scroll = 0.0f;
    protected boolean leftMouseDownOnGrabber = false;
    protected double leftMouseDownOnGrabberAtMouseX = 0.0;
    protected double leftMouseDownOnGrabberAtMouseY = 0.0;
    protected float lastGrabberX = 0.0f;
    protected float lastGrabberY = 0.0f;
    protected float leftMouseDownOnGrabberAtScroll = 0.0f;
    protected List<Consumer<ScrollBar>> scrollListeners = new ArrayList<Consumer<ScrollBar>>();
    protected boolean grabberHovered = false;

    public ScrollBar(@NotNull ScrollBarDirection direction, float grabberWidth, float grabberHeight, float scrollAreaStartX, float scrollAreaStartY, float scrollAreaEndX, float scrollAreaEndY, @NotNull Supplier<DrawableColor> idleBarColor, @NotNull Supplier<DrawableColor> hoverBarColor) {
        this(direction, grabberWidth, grabberHeight, scrollAreaStartX, scrollAreaStartY, scrollAreaEndX, scrollAreaEndY);
        this.idleBarColor = idleBarColor;
        this.hoverBarColor = hoverBarColor;
    }

    public ScrollBar(@NotNull ScrollBarDirection direction, float grabberWidth, float grabberHeight, float scrollAreaStartX, float scrollAreaStartY, float scrollAreaEndX, float scrollAreaEndY, @NotNull class_2960 idleBarTexture, @NotNull class_2960 hoverBarTexture) {
        this(direction, grabberWidth, grabberHeight, scrollAreaStartX, scrollAreaStartY, scrollAreaEndX, scrollAreaEndY);
        this.idleBarTexture = idleBarTexture;
        this.hoverBarTexture = hoverBarTexture;
    }

    protected ScrollBar(ScrollBarDirection direction, float grabberWidth, float grabberHeight, float scrollAreaStartX, float scrollAreaStartY, float scrollAreaEndX, float scrollAreaEndY) {
        this.direction = direction;
        this.grabberWidth = grabberWidth;
        this.grabberHeight = grabberHeight;
        this.scrollAreaStartX = scrollAreaStartX;
        this.scrollAreaStartY = scrollAreaStartY;
        this.scrollAreaEndX = scrollAreaEndX;
        this.scrollAreaEndY = scrollAreaEndY;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.grabberHovered = this.isMouseOverGrabber(mouseX, mouseY);
        float x = this.scrollAreaEndX - this.grabberWidth;
        float y = this.scrollAreaEndY - this.grabberHeight;
        if (this.direction == ScrollBarDirection.VERTICAL) {
            float usableAreaHeight = this.scrollAreaEndY - this.scrollAreaStartY - this.grabberHeight;
            y = this.scrollAreaStartY + usableAreaHeight * this.scroll;
        } else {
            float usableAreaWidth = this.scrollAreaEndX - this.scrollAreaStartX - this.grabberWidth;
            x = this.scrollAreaStartX + usableAreaWidth * this.scroll;
        }
        this.lastGrabberX = x;
        this.lastGrabberY = y;
        RenderSystem.enableBlend();
        ScrollBar.resetShaderColor(graphics);
        DrawableColor normalC = this.idleBarColor.get();
        DrawableColor hoverC = this.hoverBarColor.get();
        if (this.isGrabberHovered() || this.isGrabberGrabbed()) {
            if (this.hoverBarTexture != null) {
                ScrollBar.blitF(graphics, this.hoverBarTexture, x, y, 0.0f, 0.0f, this.grabberWidth, this.grabberHeight, this.grabberWidth, this.grabberHeight);
            } else if (hoverC != null) {
                ScrollBar.fillF(graphics, x, y, x + this.grabberWidth, y + this.grabberHeight, hoverC.getColorInt());
            }
        } else if (this.idleBarTexture != null) {
            ScrollBar.blitF(graphics, this.idleBarTexture, x, y, 0.0f, 0.0f, this.grabberWidth, this.grabberHeight, this.grabberWidth, this.grabberHeight);
        } else if (normalC != null) {
            ScrollBar.fillF(graphics, x, y, x + this.grabberWidth, y + this.grabberHeight, normalC.getColorInt());
        }
    }

    public boolean isGrabberHovered() {
        if (!this.active) {
            return false;
        }
        return this.grabberHovered;
    }

    public boolean isMouseOverGrabber(double mouseX, double mouseY) {
        if (!this.active) {
            return false;
        }
        float x = this.lastGrabberX;
        float y = this.lastGrabberY;
        return mouseX >= (double)x && mouseX <= (double)(x + this.grabberWidth) && mouseY >= (double)y && mouseY <= (double)(y + this.grabberHeight);
    }

    public boolean isGrabberGrabbed() {
        return this.active && this.leftMouseDownOnGrabber;
    }

    public boolean isMouseInsideScrollArea(double mouseX, double mouseY, boolean ignoreGrabber) {
        if (!this.active) {
            return false;
        }
        if (!ignoreGrabber && (this.isGrabberGrabbed() || this.isGrabberHovered())) {
            return false;
        }
        float x = this.scrollAreaStartX;
        float y = this.scrollAreaStartY;
        float width = this.scrollAreaEndX - this.scrollAreaStartX;
        float height = this.scrollAreaEndY - this.scrollAreaStartY;
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public float getScroll() {
        return this.scroll;
    }

    public void setScroll(float scroll) {
        this.setScroll(scroll, true);
    }

    public void setScroll(float scroll, boolean informScrollListeners) {
        this.scroll = Math.min(1.0f, Math.max(0.0f, scroll));
        if (informScrollListeners) {
            for (Consumer<ScrollBar> listener : this.scrollListeners) {
                listener.accept(this);
            }
        }
    }

    public float getGrabberScrollSpeed() {
        return this.grabberScrollSpeed;
    }

    public void setGrabberScrollSpeed(float speed) {
        this.grabberScrollSpeed = Math.max(0.0f, speed);
    }

    public float getWheelScrollSpeed() {
        return this.wheelScrollSpeed;
    }

    public void setWheelScrollSpeed(float speed) {
        this.wheelScrollSpeed = Math.max(0.0f, speed);
    }

    public boolean isScrollWheelAllowed() {
        return this.allowScrollWheel;
    }

    public void setScrollWheelAllowed(boolean allowed) {
        this.allowScrollWheel = allowed;
    }

    public ScrollBarDirection getDirection() {
        return this.direction;
    }

    public void registerScrollListener(Consumer<ScrollBar> listener) {
        this.scrollListeners.add(listener);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (!this.active) {
                return false;
            }
            if (this.isGrabberHovered()) {
                this.leftMouseDownOnGrabber = true;
                this.leftMouseDownOnGrabberAtMouseX = mouseX;
                this.leftMouseDownOnGrabberAtMouseY = mouseY;
                this.leftMouseDownOnGrabberAtScroll = this.scroll;
                return true;
            }
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.leftMouseDownOnGrabber = false;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double $$3, double $$4) {
        if (this.leftMouseDownOnGrabber) {
            float usableAreaWidth = this.scrollAreaEndX - this.scrollAreaStartX - this.grabberWidth;
            float usableAreaHeight = this.scrollAreaEndY - this.scrollAreaStartY - this.grabberHeight;
            float offsetX = (float)(mouseX - this.leftMouseDownOnGrabberAtMouseX);
            float offsetY = (float)(mouseY - this.leftMouseDownOnGrabberAtMouseY);
            float scrollOffset = this.direction == ScrollBarDirection.VERTICAL ? offsetY / usableAreaHeight : offsetX / usableAreaWidth;
            this.setScroll(this.leftMouseDownOnGrabberAtScroll + scrollOffset);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (this.active && this.allowScrollWheel && this.isMouseInsideScrollArea(mouseX, mouseY, true) && !this.leftMouseDownOnGrabber) {
            float scrollOffset = 0.1f * this.wheelScrollSpeed;
            if (scrollDelta > 0.0) {
                scrollOffset = -scrollOffset;
            }
            this.setScroll(this.getScroll() + scrollOffset);
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.leftMouseDownOnGrabber) {
            return true;
        }
        return this.isMouseInsideScrollArea(mouseX, mouseY, true);
    }

    public void method_25365(boolean var1) {
    }

    public boolean method_25370() {
        return false;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 var1) {
    }

    public static enum ScrollBarDirection {
        HORIZONTAL,
        VERTICAL;

    }
}

