/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.embedded;

import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_player_t;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.embedded.FullScreenApi;
import org.watermedia.videolan4j.player.embedded.InputApi;
import org.watermedia.videolan4j.player.embedded.VideoSurfaceApi;

public class EmbeddedMediaPlayer
extends MediaPlayer {
    protected final libvlc_instance_t libvlcInstance;
    private final FullScreenApi fullScreenApi;
    private final InputApi inputApi;
    private final VideoSurfaceApi videoSurfaceApi;

    public EmbeddedMediaPlayer(libvlc_instance_t instance) {
        super(instance);
        this.libvlcInstance = instance;
        this.fullScreenApi = new FullScreenApi(this);
        this.inputApi = new InputApi(this);
        this.videoSurfaceApi = new VideoSurfaceApi(this);
    }

    public EmbeddedMediaPlayer(libvlc_instance_t instance, libvlc_media_player_t mediaPlayerInstance) {
        super(instance, mediaPlayerInstance);
        this.libvlcInstance = instance;
        this.fullScreenApi = new FullScreenApi(this);
        this.inputApi = new InputApi(this);
        this.videoSurfaceApi = new VideoSurfaceApi(this);
    }

    public final FullScreenApi fullScreen() {
        return this.fullScreenApi;
    }

    public final InputApi input() {
        return this.inputApi;
    }

    public final VideoSurfaceApi videoSurface() {
        return this.videoSurfaceApi;
    }

    @Override
    protected final void onBeforePlay() {
        this.videoSurface().attachVideoSurface();
    }

    @Override
    protected final void onBeforeRelease() {
        this.fullScreenApi.release();
        this.inputApi.release();
        this.videoSurfaceApi.release();
    }
}

