/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media;

import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.media.OptionFlag;

final class MediaOptions {
    private MediaOptions() {
    }

    static boolean addMediaOptions(libvlc_media_t media, String ... mediaOptions) {
        if (media != null) {
            if (mediaOptions != null) {
                for (String mediaOption : mediaOptions) {
                    LibVlc.libvlc_media_add_option(media, mediaOption);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean addMediaOptions(libvlc_media_t media, String[] mediaOptions, OptionFlag ... flags) {
        if (media != null) {
            int flagsValue = MediaOptions.flagsToInt(flags);
            for (String mediaOption : mediaOptions) {
                LibVlc.libvlc_media_add_option_flag(media, mediaOption, flagsValue);
            }
            return true;
        }
        return false;
    }

    public static boolean addMediaOption(libvlc_media_t media, String mediaOption, OptionFlag ... flags) {
        if (media != null) {
            LibVlc.libvlc_media_add_option_flag(media, mediaOption, MediaOptions.flagsToInt(flags));
            return true;
        }
        return false;
    }

    private static int flagsToInt(OptionFlag ... flags) {
        int result = 0;
        if (flags != null) {
            for (OptionFlag flag : flags) {
                result |= flag.intValue();
            }
        }
        return result;
    }
}

