/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.factory;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import org.watermedia.videolan4j.binding.internal.libvlc_media_discoverer_description_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_discoverer_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.binding.lib.size_t;
import org.watermedia.videolan4j.factory.BaseApi;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.media.discoverer.MediaDiscoverer;
import org.watermedia.videolan4j.media.discoverer.MediaDiscovererCategory;
import org.watermedia.videolan4j.media.discoverer.MediaDiscovererDescription;
import org.watermedia.videolan4j.media.discoverer.MediaDiscovererFactory;

public final class MediaDiscovererApi
extends BaseApi {
    MediaDiscovererApi(MediaPlayerFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaDiscovererDescription> discoverers(MediaDiscovererCategory category) {
        PointerByReference ref = new PointerByReference();
        size_t size = LibVlc.libvlc_media_discoverer_list_get(this.libvlcInstance, category.intValue(), ref);
        try {
            int count = size.intValue();
            ArrayList<MediaDiscovererDescription> result = new ArrayList<MediaDiscovererDescription>(count);
            if (count > 0) {
                Pointer[] pointers;
                for (Pointer pointer : pointers = ref.getValue().getPointerArray(0L, count)) {
                    libvlc_media_discoverer_description_t description = (libvlc_media_discoverer_description_t)Structure.newInstance(libvlc_media_discoverer_description_t.class, (Pointer)pointer);
                    description.read();
                    result.add(new MediaDiscovererDescription(description.psz_name, description.psz_longname, MediaDiscovererCategory.mediaDiscovererCategory(description.i_cat)));
                }
            }
            ArrayList<MediaDiscovererDescription> arrayList = result;
            return arrayList;
        }
        finally {
            LibVlc.libvlc_media_discoverer_list_release(ref.getValue(), size);
        }
    }

    public MediaDiscoverer discoverer(String name) {
        libvlc_media_discoverer_t discoverer = LibVlc.libvlc_media_discoverer_new(this.libvlcInstance, name);
        if (discoverer != null) {
            return MediaDiscovererFactory.newMediaDiscoverer(this.libvlcInstance, discoverer);
        }
        return null;
    }
}

