/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.factory;

import java.util.ArrayList;
import java.util.List;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_output_device_t;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_output_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.factory.AudioOutput;
import org.watermedia.videolan4j.factory.BaseApi;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.player.base.AudioDevice;

public final class AudioApi
extends BaseApi {
    AudioApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public List<AudioOutput> audioOutputs() {
        ArrayList<AudioOutput> result = new ArrayList<AudioOutput>();
        libvlc_audio_output_t audioOutputs = LibVlc.libvlc_audio_output_list_get(this.libvlcInstance);
        if (audioOutputs != null) {
            libvlc_audio_output_t audioOutput = audioOutputs;
            while (audioOutput != null) {
                String name = VideoLan4J.copyNativeString(audioOutput.psz_name);
                String description = VideoLan4J.copyNativeString(audioOutput.psz_description);
                result.add(new AudioOutput(name, description, this.getAudioOutputDevices(name)));
                audioOutput = audioOutput.p_next;
            }
            LibVlc.libvlc_audio_output_list_release(audioOutputs.getPointer());
        }
        return result;
    }

    private List<AudioDevice> getAudioOutputDevices(String outputName) {
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = LibVlc.libvlc_audio_output_device_list_get(this.libvlcInstance, outputName);
        if (audioDevices != null) {
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = VideoLan4J.copyNativeString(audioDevice.psz_device);
                String description = VideoLan4J.copyNativeString(audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            LibVlc.libvlc_audio_output_device_list_release(audioDevices.getPointer());
        }
        return result;
    }
}

