/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs.twitch;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.watermedia.api.network.patchs.twitch.StreamQuality;
import org.watermedia.core.tools.NetTool;

public class TwitchAPI {
    public static final String GRAPH_QL_URL = "https://gql.twitch.tv/gql";
    public static final String TTV_LIVE_API_URL_TEMPLATE = "https://usher.ttvnw.net/api/channel/hls/%s.m3u8";
    public static final String TTV_PLAYLIST_API_URL_TEMPLATE = "https://usher.ttvnw.net/vod/%s.m3u8";
    public static final String CLIENT_ID = "kimne78kx3ncx6brgo4mv6wki5h1ko";
    private static final Gson gson = new Gson();
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public static List<StreamQuality> getStream(String stream) throws IOException, StreamNotFound {
        String apiUrl = TwitchAPI.buildApiUrl(stream, false);
        return StreamQuality.parse(TwitchAPI.performGetRequest(apiUrl));
    }

    public static List<StreamQuality> getVod(String video) throws IOException, StreamNotFound {
        String apiUrl = TwitchAPI.buildApiUrl(video, true);
        return StreamQuality.parse(TwitchAPI.performGetRequest(apiUrl));
    }

    private static String buildApiUrl(String id, boolean isVOD) throws IOException {
        JsonElement response = TwitchAPI.post(id, isVOD);
        JsonObject accessTokenData = response.getAsJsonObject().get("data").getAsJsonObject().get(isVOD ? "videoPlaybackAccessToken" : "streamPlaybackAccessToken").getAsJsonObject();
        String signature = accessTokenData.get("signature").getAsString();
        String value = accessTokenData.get("value").getAsString();
        String url = String.format(isVOD ? TTV_PLAYLIST_API_URL_TEMPLATE : TTV_LIVE_API_URL_TEMPLATE, id);
        return url + TwitchAPI.buildUrlParameters(signature, value);
    }

    private static String buildUrlParameters(String signature, String value) throws UnsupportedEncodingException {
        value = URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        return String.format("?acmb=e30%%3D&allow_source=true&fast_bread=true&p=7370379&play_session_id=21efcd962e7b3fbc891bac088214aa63&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=%s&supported_codecs=avc1&token=%s&transcode_mode=cbr_v1&cdm=wv&player_version=1.21.0", signature, value);
    }

    private static String performGetRequest(String apiUrl) throws IOException, StreamNotFound {
        HttpURLConnection conn = TwitchAPI.initializeConnection(apiUrl, "GET");
        conn.setRequestProperty("x-donate-to", "https://ttv.lol/donate");
        int responseCode = conn.getResponseCode();
        if (responseCode == 404) {
            throw new StreamNotFound("Stream not found");
        }
        return responseCode == 200 ? new String(TwitchAPI.readAllBytes(conn.getInputStream())) : new String(TwitchAPI.readAllBytes(conn.getErrorStream()));
    }

    private static JsonElement post(String id, boolean isVOD) throws IOException {
        HttpURLConnection conn = NetTool.connectToHTTP(GRAPH_QL_URL, "POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Client-ID", CLIENT_ID);
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        try (OutputStream os = conn.getOutputStream();){
            os.write(TwitchAPI.buildJsonString(id, isVOD).getBytes(StandardCharsets.UTF_8));
        }
        return new JsonParser().parse(new String(TwitchAPI.readAllBytes(conn.getInputStream())));
    }

    private static HttpURLConnection initializeConnection(String url, String requestMethod) throws IOException {
        URL apiUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
        conn.setRequestMethod(requestMethod);
        return conn;
    }

    private static String buildJsonString(String id, boolean isVOD) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("isLive", !isVOD);
        variables.put("isVod", isVOD);
        variables.put("login", !isVOD ? id : "");
        variables.put("vodID", isVOD ? id : "");
        variables.put("playerType", "site");
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("operationName", "PlaybackAccessToken_Template");
        jsonMap.put("query", "query PlaybackAccessToken_Template($login: String!, $isLive: Boolean!, $vodID: ID!, $isVod: Boolean!, $playerType: String!) {  streamPlaybackAccessToken(channelName: $login, params: {platform: \"web\", playerBackend: \"mediaplayer\", playerType: $playerType}) @include(if: $isLive) {    value    signature    __typename  }  videoPlaybackAccessToken(id: $vodID, params: {platform: \"web\", playerBackend: \"mediaplayer\", playerType: $playerType}) @include(if: $isVod) {    value    signature    __typename  }}");
        jsonMap.put("variables", variables);
        return gson.toJson(jsonMap);
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int n;
        int len = Integer.MAX_VALUE;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = inputStream.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            if (nread < buf.length) {
                buf = Arrays.copyOfRange(buf, 0, nread);
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    public static class StreamNotFound
    extends Exception {
        public StreamNotFound(String message) {
            super(message);
        }
    }
}

