/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.api.network.patchs.streamable.SAVideo;
import org.watermedia.core.tools.NetTool;

public class StreamablePatch
extends AbstractPatch {
    private static final String API_URL = "https://api.streamable.com/videos/";
    private static final Gson GSON = new Gson();

    @Override
    public String platform() {
        return "Streamable";
    }

    @Override
    public boolean isValid(URI uri) {
        String host = uri.getHost();
        return host != null && host.equals("streamable.com");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality prefQuality) throws AbstractPatch.FixingURLException {
        String videoId = uri.getPath().substring(1);
        try {
            HttpURLConnection connection = NetTool.connectToHTTP(new URI(API_URL + videoId), "GET");
            if (connection.getResponseCode() == 404) {
                throw new NullPointerException("Video doesn't exists");
            }
            try {
                AbstractPatch.Result result;
                try (InputStreamReader is = new InputStreamReader(connection.getInputStream());){
                    SAVideo video = (SAVideo)GSON.fromJson((Reader)is, SAVideo.class);
                    result = new AbstractPatch.Result(new URI(video.files.mp4.url), true, false);
                }
                return result;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)e);
        }
    }
}

