/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.core.tools.DataTool;
import org.watermedia.core.tools.NetTool;

public class DrivePatch
extends AbstractPatch {
    private static final String DOWNLOAD_URL = "https://drive.usercontent.google.com/download?id=%s&export=download&authuser=0&acknowledgeAbuse=true";
    private static final String API_URL = "https://www.googleapis.com/drive/v3/files/%s?alt=media&acknowledgeAbuse=true&key=%s";
    private static final String LUCK = new String(Base64.getDecoder().decode(new String(Base64.getDecoder().decode("UVVsNllWTjVRVTVpVFhkWGQyWnhiSE5QWWtoVlEwODFjbUZ6TjBGcmNXaE5UWEphUVZWWg=="), StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    private static final Pattern HTML_PATTERN = Pattern.compile("<input[^>]*name=\"([^\"]+)\"[^>]*value=\"([^\"]+)\"", 42);

    @Override
    public String platform() {
        return "Google Drive";
    }

    @Override
    public boolean isValid(URI uri) {
        String host = uri.getHost();
        return host != null && host.equals("drive.google.com") && uri.getPath().startsWith("/file/d/");
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality preferQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, preferQuality);
        try {
            int start = uri.getPath().indexOf("/file/d/") + 8;
            int end = uri.getPath().indexOf(47, start);
            if (end == -1) {
                end = uri.getPath().length();
            }
            String fileID = uri.getPath().substring(start, end);
            return new AbstractPatch.Result(new URI(String.format(API_URL, fileID, LUCK)), false, false, this::fallback);
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)e);
        }
    }

    private AbstractPatch.Result fallback(URI uri) throws AbstractPatch.FixingURLException {
        try {
            String fileId = this.getFileID(uri.getPath());
            String url = String.format(DOWNLOAD_URL, fileId);
            HttpURLConnection conn = NetTool.connectToHTTP(url, "GET");
            int code = conn.getResponseCode();
            switch (code) {
                case 404: {
                    throw new NullPointerException("File doesn't exists or isn't available anymore");
                }
                case 401: 
                case 403: {
                    throw new IllegalAccessException("File has not public accesibility");
                }
            }
            if (code != 200) {
                throw new UnsupportedOperationException("Google responses with a unexpected status code: " + code);
            }
            if (conn.getContentType().startsWith("text/html")) {
                try (InputStream in = conn.getInputStream();){
                    String html = new String(DataTool.readAllBytes(in), StandardCharsets.UTF_8);
                    Matcher matcher = HTML_PATTERN.matcher(html);
                    HashMap<String, String> form = new HashMap<String, String>();
                    while (matcher.find()) {
                        form.put(matcher.group(1), matcher.group(2));
                    }
                    if (!form.containsKey("uuid")) {
                        throw new IllegalAccessException("File");
                    }
                    url = url + "&uuid=" + (String)form.get("uuid") + "&at=" + (String)form.get("at") + "&confirm=t";
                }
            }
            conn.disconnect();
            return new AbstractPatch.Result(new URI(url), conn.getContentType().startsWith("video"), false);
        }
        catch (Exception e) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)e);
        }
    }

    private String getFileID(String path) {
        int start = path.indexOf("/file/d/");
        if (start == -1) {
            throw new IllegalArgumentException("URL doesn't mach well-know paths");
        }
        int end = path.indexOf(47, start += 8);
        if (end == -1) {
            end = path.length();
        }
        return path.substring(start, end);
    }
}

