/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vsc.dynamicpack;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.vsc.CutBlockType;
import net.mehvahdjukaar.vsc.VSC;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ServerDynamicResourcesHandler
extends DynServerResourcesGenerator {
    public static final ServerDynamicResourcesHandler INSTANCE = new ServerDynamicResourcesHandler();
    private final Set<String> recipeLocations;

    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(VSC.res("generated_pack")));
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"minecraft"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"forge"});
        ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"quark"});
        ((DynamicDataPack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev());
        this.recipeLocations = Set.of("recipe", "recipe_2", "recipe_stonecutter");
    }

    public Logger getLogger() {
        return VSC.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(class_3300 manager) {
        this.recipeLocations.forEach(res -> {
            try {
                this.addBlocksRecipes(manager, ResType.GENERIC.getPath(VSC.res("template/" + res + ".json")));
            }
            catch (Exception e) {
                VSC.LOGGER.error("Failed to generate recipes for template at location {} ", res);
            }
        });
        this.addBlocksLootTable(manager, ResType.GENERIC.getPath(VSC.res("template/loot_table.json")));
        this.addTags(manager);
    }

    private void addTags(class_3300 manager) {
        SimpleTagBuilder tag = SimpleTagBuilder.of((class_2960)VSC.res("vertical_slabs"));
        tag.addEntries(VSC.VERTICAL_SLABS_ITEMS.values());
        ((DynamicDataPack)this.dynamicPack).addTag(tag, class_7924.field_41254);
        ((DynamicDataPack)this.dynamicPack).addTag(tag, class_7924.field_41197);
        SimpleTagBuilder quarkTag = SimpleTagBuilder.of((class_2960)new class_2960("quark:vertical_slabs"));
        SimpleTagBuilder quarkWoodenTag = SimpleTagBuilder.of((class_2960)new class_2960("quark:wooden_vertical_slabs"));
        quarkTag.addTag(tag);
        quarkWoodenTag.addEntries(VSC.VERTICAL_SLABS_ITEMS.entrySet().stream().filter(t -> ((CutBlockType)((Object)((Object)t.getKey()))).getWoodType() != null).map(Map.Entry::getValue).toList());
        ((DynamicDataPack)this.dynamicPack).addTag(quarkTag, class_7924.field_41254);
        ((DynamicDataPack)this.dynamicPack).addTag(quarkTag, class_7924.field_41197);
        ((DynamicDataPack)this.dynamicPack).addTag(quarkWoodenTag, class_7924.field_41254);
        ((DynamicDataPack)this.dynamicPack).addTag(quarkWoodenTag, class_7924.field_41197);
        this.copyTags(manager, class_3481.field_33719, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_33718, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_33717, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_33713, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_33714, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_33715, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_33716, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_17753, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_38835, class_7924.field_41254);
        this.copyTags(manager, class_3481.field_23800, class_7924.field_41254);
        this.copyTags(manager, class_3489.field_24481, class_7924.field_41197);
    }

    private <T> void copyTags(class_3300 manager, class_6862<T> tagKey, class_5321<class_2378<T>> registry) {
        Set<String> tagValues = ServerDynamicResourcesHandler.getTags(manager, tagKey);
        SimpleTagBuilder builer = SimpleTagBuilder.of(tagKey);
        for (Map.Entry<CutBlockType, class_1792> e : VSC.VERTICAL_SLABS_ITEMS.entrySet()) {
            class_2960 id = class_7923.field_41175.method_10221((Object)e.getKey().slab);
            if (!tagValues.contains(id.toString())) continue;
            builer.addEntry((Object)e.getValue());
        }
        List b = builer.method_26782();
        if (!b.isEmpty()) {
            ((DynamicDataPack)this.dynamicPack).addTag(builer, registry);
        }
    }

    @NotNull
    private static <T> Set<String> getTags(class_3300 manager, class_6862<T> tagKey) {
        InputStream res;
        List resources = manager.method_14489(ResType.TAGS.getPath(tagKey.comp_327().method_45138(tagKey.comp_326().method_29177().method_12832() + "s/")));
        HashSet tagValues = new HashSet();
        HashSet<String> actualTags = new HashSet<String>();
        for (class_3298 r : resources) {
            try {
                res = r.method_14482();
                try {
                    RPUtils.deserializeJson((InputStream)res).getAsJsonArray("values").asList().stream().filter(JsonElement::isJsonPrimitive).forEach(v -> tagValues.add(v.getAsString()));
                }
                finally {
                    if (res == null) continue;
                    res.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String s : tagValues) {
            if (s.startsWith("#")) {
                res = new class_2960(s.substring(1));
                if (!res.method_12832().contains("slab")) continue;
                class_6862 newKey = class_6862.method_40092((class_5321)tagKey.comp_326(), (class_2960)res);
                actualTags.addAll(ServerDynamicResourcesHandler.getTags(manager, newKey));
                continue;
            }
            actualTags.add(s);
        }
        return actualTags;
    }

    private void addBlocksLootTable(class_3300 manager, class_2960 templateLootTable) {
        StaticResource template = StaticResource.getOrFail((class_3300)manager, (class_2960)templateLootTable);
        VSC.VERTICAL_SLABS.forEach((w, i) -> {
            String fullText = new String(template.data, StandardCharsets.UTF_8);
            fullText = fullText.replace("$v_slab", Utils.getID((class_2248)i).toString());
            String id = template.location.toString();
            id = id.replace("template/loot_table", "loot_tables/" + i.method_26162().method_12832());
            ((DynamicDataPack)this.dynamicPack).addResource(StaticResource.create((byte[])fullText.getBytes(), (class_2960)new class_2960(id)));
        });
    }

    private void addBlocksRecipes(class_3300 manager, class_2960 templateRecipe) {
        StaticResource template = StaticResource.getOrFail((class_3300)manager, (class_2960)templateRecipe);
        VSC.VERTICAL_SLABS_ITEMS.forEach((w, i) -> {
            if (this.isSlabEnabled((CutBlockType)((Object)w), (class_1792)i)) {
                if (templateRecipe.method_12832().contains("stone") && w.getWoodType() != null) {
                    return;
                }
                String fullText = new String(template.data, StandardCharsets.UTF_8);
                fullText = fullText.replace("$slab", Utils.getID((class_2248)w.slab).toString());
                fullText = fullText.replace("$v_slab", Utils.getID((Object)w.getChild("vertical_slab")).toString());
                fullText = fullText.replace("$block", Utils.getID((class_2248)w.base).toString());
                String id = template.location.toString();
                id = id.replace("template/recipe", "recipes/" + w.getAppendableId());
                ((DynamicDataPack)this.dynamicPack).addResource(StaticResource.create((byte[])fullText.getBytes(), (class_2960)new class_2960(id)));
            }
        });
    }

    private boolean isSlabEnabled(CutBlockType w, class_1792 i) {
        String namespace = w.getNamespace();
        return !VSC.BLACKLIST.get().contains(namespace);
    }
}

