/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vsc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.vsc.CutBlockType;
import net.mehvahdjukaar.vsc.CutBlockTypeRegistry;
import net.mehvahdjukaar.vsc.VSCClient;
import net.mehvahdjukaar.vsc.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.vsc.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.vsc.temp.QuarkCompat;
import net.mehvahdjukaar.vsc.temp.TempVerticalSlabBlock;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class VSC {
    public static final String MOD_ID = "v_slab_compat";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean QUARK = PlatHelper.isModLoaded((String)"quark");
    public static final List<String> VERTICAL_SLABS_MODS = Stream.of("quark", "buildersaddition", "compatoplenty", "everycomp").filter(PlatHelper::isModLoaded).toList();
    public static final Map<CutBlockType, class_2248> VERTICAL_SLABS = new Object2ObjectOpenHashMap();
    public static final Map<CutBlockType, class_1792> VERTICAL_SLABS_ITEMS = new Object2ObjectOpenHashMap();
    public static Supplier<List<String>> BLACKLIST;

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void commonInit() {
        ConfigBuilder c = ConfigBuilder.create((String)MOD_ID, (ConfigType)ConfigType.COMMON);
        BLACKLIST = c.comment("mod ids blacklist").define("blacklist", List.of("securitycraft"), o -> o instanceof String);
        c.buildAndRegister().loadFromFile();
        if (PlatHelper.getPhysicalSide().isClient()) {
            VSCClient.init();
        }
        BlockSetAPI.registerBlockSetDefinition((BlockTypeRegistry)new CutBlockTypeRegistry("cut_block_type"));
        BlockSetAPI.addDynamicBlockRegistration(VSC::registerVerticalSlab, CutBlockType.class);
        BlockSetAPI.addDynamicRegistration(VSC::registerItems, CutBlockType.class, (class_2378)class_7923.field_41178);
        ServerDynamicResourcesHandler.INSTANCE.register();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientDynamicResourcesHandler.INSTANCE.register();
        }
        RegHelper.addItemsToTabsRegistration(VSC::addItemsToTabs);
    }

    private static void registerItems(Registrator<class_1792> itemRegistrator, Collection<CutBlockType> types) {
        for (Map.Entry<CutBlockType, class_2248> v : VERTICAL_SLABS.entrySet()) {
            CutBlockType type = v.getKey();
            class_2248 block = v.getValue();
            class_1792.class_1793 prop = new class_1792.class_1793();
            Object i = type.getWoodType() != null ? new WoodBasedBlockItem(block, prop, type.getWoodType(), 150) : new class_1747(block, prop);
            itemRegistrator.register(Utils.getID((class_2248)v.getValue()), i);
            VERTICAL_SLABS_ITEMS.put(type, (class_1792)i);
        }
    }

    private static void registerVerticalSlab(Registrator<class_2248> blockRegistrator, Collection<CutBlockType> types) {
        for (CutBlockType type : types) {
            if (type.getChild("vertical_slab") != null) continue;
            String name = type.getTypeName() + "_vertical_slab";
            class_2960 newId = VSC.res(type.getNamespace().equals("minecraft") ? name : type.getNamespace() + "/" + name);
            class_2248 block = VSC.createVSlab(type);
            blockRegistrator.register(newId, (Object)block);
            VERTICAL_SLABS.put(type, block);
            type.addChild("vertical_slab", block);
        }
    }

    @NotNull
    private static class_2248 createVSlab(CutBlockType type) {
        return QUARK ? QuarkCompat.createVSlab(type) : new TempVerticalSlabBlock(Utils.copyPropertySafe((class_2248)type.base), type);
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
        for (Map.Entry<CutBlockType, class_1792> v : VERTICAL_SLABS_ITEMS.entrySet()) {
            String namespace = v.getKey().getNamespace();
            if (BLACKLIST.get().contains(namespace)) continue;
            event.addAfter(class_7706.field_40195, i -> i.method_31574(((CutBlockType)((Object)((Object)v.getKey()))).slab.method_8389()), new class_1935[]{(class_1935)v.getValue()});
        }
    }
}

