/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vsc;

import com.google.common.base.Stopwatch;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.vsc.CutBlockType;
import net.mehvahdjukaar.vsc.VSC;
import net.mehvahdjukaar.vsc.fabric.CutBlockTypeRegistryImpl;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;

public class CutBlockTypeRegistry
extends BlockTypeRegistry<CutBlockType> {
    public static final CutBlockType STONE_TYPE = new CutBlockType(new class_2960("stone"), class_2246.field_10340, class_2246.field_10454);
    private final List<String> dyes = Arrays.stream(class_1767.values()).map(class_1767::method_7792).sorted(Comparator.comparingInt(String::length)).sorted(Collections.reverseOrder()).toList();
    private final Set<String> blacklist = Set.of("securitycraft", "betterend", "betternether");

    protected CutBlockTypeRegistry(String name) {
        super(CutBlockType.class, name);
    }

    public CutBlockType getDefaultType() {
        return STONE_TYPE;
    }

    public Optional<CutBlockType> detectTypeFromBlock(class_2248 block, class_2960 baseRes) {
        String name = null;
        String path = baseRes.method_12832();
        if (path.endsWith("_slab") && !path.endsWith("_vertical_slab")) {
            name = path.substring(0, path.length() - "_slab".length());
        } else if (path.startsWith("slab_")) {
            name = path.substring("slab_".length());
        }
        String namespace = baseRes.method_12836();
        if (name != null && block instanceof class_2482 && !this.blacklist.contains(namespace)) {
            class_2960 id = new class_2960(namespace, name);
            Optional parent = class_7923.field_41175.method_17966(id);
            if (parent.isEmpty() && namespace.equals("absentbydesign")) {
                String finalName = name.replace("silver", "light_gray");
                for (String d : this.dyes) {
                    if (!finalName.contains(d)) continue;
                    String n = d + "_" + finalName.replace("_" + d, "");
                    parent = class_7923.field_41175.method_17966(new class_2960(n));
                    if (!parent.isPresent()) break;
                    id = new class_2960("absentbydesign", n);
                    break;
                }
                name = name.replace("bricks_cracked", "cracked_stone_bricks");
            }
            if (parent.isEmpty()) {
                parent = class_7923.field_41175.method_17966(new class_2960(namespace, name + "s"));
            }
            if (parent.isEmpty()) {
                parent = class_7923.field_41175.method_17966(new class_2960(namespace, name + "_planks"));
            }
            if (parent.isEmpty()) {
                parent = class_7923.field_41175.method_17966(new class_2960(name));
            }
            if (parent.isPresent() && CutBlockTypeRegistry.hasRightShapeHack(block)) {
                return Optional.of(new CutBlockType(id, (class_2248)parent.get(), block));
            }
        }
        return Optional.empty();
    }

    public void buildAll() {
        Stopwatch watch = Stopwatch.createStarted();
        super.buildAll();
        VSC.LOGGER.info("Initialized slab sets in: {} ms", (Object)watch.elapsed().toMillis());
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasRightShapeHack(class_2248 block) {
        return CutBlockTypeRegistryImpl.hasRightShapeHack(block);
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(w -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }
}

