/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import java.util.Arrays;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.color.ColorProviderRegistry;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;

public class BlockRenderer {
    private final class_5819 random = new class_6575(42L);
    private final ColorProviderRegistry colorProviderRegistry;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData quadLightData = new QuadLightData();
    private final LightPipelineProvider lighters;
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private final boolean useAmbientOcclusion;
    private final int[] quadColors = new int[4];

    public BlockRenderer(ColorProviderRegistry colorRegistry, LightPipelineProvider lighters) {
        this.colorProviderRegistry = colorRegistry;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = class_310.method_1588();
    }

    public void renderModel(BlockRenderContext ctx, ChunkBuildBuffers buffers) {
        Material material = DefaultMaterials.forBlockState(ctx.state());
        ChunkModelBuilder meshBuilder = buffers.get(material);
        ColorProvider<class_2680> colorizer = this.colorProviderRegistry.getColorProvider(ctx.state().method_26204());
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(ctx.state(), ctx.model()));
        class_243 renderOffset = ctx.state().method_49228() ? ctx.state().method_26226((class_1922)ctx.world(), ctx.pos()) : class_243.field_1353;
        for (class_2350 face : DirectionUtil.ALL_DIRECTIONS) {
            List<class_777> quads = this.getGeometry(ctx, face);
            if (quads.isEmpty() || !this.isFaceVisible(ctx, face)) continue;
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, meshBuilder, quads, face);
        }
        List<class_777> all = this.getGeometry(ctx, null);
        if (!all.isEmpty()) {
            this.renderQuadList(ctx, material, lighter, colorizer, renderOffset, meshBuilder, all, null);
        }
    }

    private List<class_777> getGeometry(BlockRenderContext ctx, class_2350 face) {
        class_5819 random = this.random;
        random.method_43052(ctx.seed());
        return ctx.model().method_4707(ctx.state(), face, random);
    }

    private boolean isFaceVisible(BlockRenderContext ctx, class_2350 face) {
        return this.occlusionCache.shouldDrawSide(ctx.state(), (class_1922)ctx.world(), ctx.pos(), face);
    }

    private void renderQuadList(BlockRenderContext ctx, Material material, LightPipeline lighter, ColorProvider<class_2680> colorizer, class_243 offset, ChunkModelBuilder builder, List<class_777> quads, class_2350 cullFace) {
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuadView quad = (BakedQuadView)quads.get(i);
            QuadLightData lightData = this.getVertexLight(ctx, lighter, cullFace, quad);
            int[] vertexColors = this.getVertexColors(ctx, colorizer, quad);
            this.writeGeometry(ctx, builder, offset, material, quad, vertexColors, lightData);
            class_1058 sprite = quad.getSprite();
            if (sprite == null) continue;
            builder.addSprite(sprite);
        }
    }

    private QuadLightData getVertexLight(BlockRenderContext ctx, LightPipeline lighter, class_2350 cullFace, BakedQuadView quad) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, ctx.pos(), light, cullFace, quad.getLightFace(), quad.hasShade());
        return light;
    }

    private int[] getVertexColors(BlockRenderContext ctx, ColorProvider<class_2680> colorProvider, BakedQuadView quad) {
        int[] vertexColors = this.quadColors;
        if (colorProvider != null && quad.hasColor()) {
            colorProvider.getColors(ctx.world(), ctx.pos(), ctx.state(), quad, vertexColors);
        } else {
            Arrays.fill(vertexColors, -1);
        }
        return vertexColors;
    }

    private void writeGeometry(BlockRenderContext ctx, ChunkModelBuilder builder, class_243 offset, Material material, BakedQuadView quad, int[] colors, QuadLightData light) {
        ModelQuadOrientation orientation = ModelQuadOrientation.orientByBrightness(light.br, light.lm);
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        ModelQuadFacing normalFace = quad.getNormalFace();
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = ctx.origin().x() + quad.getX(srcIndex) + (float)offset.method_10216();
            out.y = ctx.origin().y() + quad.getY(srcIndex) + (float)offset.method_10214();
            out.z = ctx.origin().z() + quad.getZ(srcIndex) + (float)offset.method_10215();
            out.color = ColorABGR.withAlpha(colors != null ? colors[srcIndex] : -1, light.br[srcIndex]);
            out.u = quad.getTexU(srcIndex);
            out.v = quad.getTexV(srcIndex);
            out.light = light.lm[srcIndex];
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
    }

    private LightMode getLightingMode(class_2680 state, class_1087 model) {
        if (this.useAmbientOcclusion && model.method_4708() && state.method_26213() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

