/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.server.McServerLib;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.api.server.player.VoiceServerPlayerManager;
import su.plo.voice.server.player.BaseVoicePlayerManager;
import su.plo.voice.server.player.VoiceServerPlayerEntity;

public final class VoiceServerPlayerManagerImpl
extends BaseVoicePlayerManager<VoiceServerPlayer>
implements VoiceServerPlayerManager {
    private final PlasmoVoiceServer voiceServer;
    private final McServerLib minecraftServer;

    @Override
    public Optional<VoiceServerPlayer> getPlayerById(@NotNull UUID playerId, boolean useServerInstance) {
        VoiceServerPlayer voicePlayer = (VoiceServerPlayer)this.playerById.get(playerId);
        if (voicePlayer != null) {
            return Optional.of(voicePlayer);
        }
        if (!useServerInstance) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.minecraftServer.getPlayerById(playerId)).map(this::wrap);
    }

    @Override
    public Optional<VoiceServerPlayer> getPlayerByName(@NotNull String playerName, boolean useServerInstance) {
        VoiceServerPlayer voicePlayer = (VoiceServerPlayer)this.playerByName.get(playerName);
        if (voicePlayer != null) {
            return Optional.of(voicePlayer);
        }
        if (!useServerInstance) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.minecraftServer.getPlayerByName(playerName)).map(this::wrap);
    }

    @Override
    @NotNull
    public VoiceServerPlayer getPlayerByInstance(@NotNull Object instance) {
        return this.wrap(this.minecraftServer.getPlayerByInstance(instance));
    }

    @NotNull
    private VoiceServerPlayer wrap(@NotNull McServerPlayer serverPlayer) {
        return this.playerById.computeIfAbsent(serverPlayer.getUuid(), playerId -> {
            VoiceServerPlayerEntity newPlayer = new VoiceServerPlayerEntity(this.voiceServer, serverPlayer);
            this.playerByName.put(newPlayer.getInstance().getName(), newPlayer);
            return newPlayer;
        });
    }

    public VoiceServerPlayerManagerImpl(PlasmoVoiceServer voiceServer, McServerLib minecraftServer) {
        this.voiceServer = voiceServer;
        this.minecraftServer = minecraftServer;
    }
}

