/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.slib.api.event.player.McPlayerJoinEvent;
import su.plo.slib.api.event.player.McPlayerQuitEvent;
import su.plo.slib.api.server.channel.McServerChannelHandler;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.connection.PlayerChannelHandler;

public final class ServerChannelHandler
implements McServerChannelHandler {
    private final BaseVoiceServer voiceServer;
    private final Map<UUID, PlayerChannelHandler> channels = Maps.newConcurrentMap();
    private final Map<UUID, ScheduledFuture<?>> playerCheckFutures = Maps.newConcurrentMap();

    public ServerChannelHandler(@NotNull BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
        McPlayerJoinEvent.INSTANCE.registerListener(this::onPlayerJoin);
        McPlayerQuitEvent.INSTANCE.registerListener(this::onPlayerQuit);
    }

    @Override
    public void receive(@NotNull McServerPlayer serverPlayer, @NotNull byte[] bytes) {
        try {
            PacketTcpCodec.decode(ByteStreams.newDataInput((byte[])bytes)).ifPresent(packet -> {
                VoiceServerPlayer voicePlayer = this.voiceServer.getPlayerManager().getPlayerByInstance(serverPlayer.getInstance());
                this.cancelPlayerCheckFuture(voicePlayer.getInstance().getUuid());
                PlayerChannelHandler channel = this.channels.computeIfAbsent(serverPlayer.getUuid(), playerId -> new PlayerChannelHandler(this.voiceServer, voicePlayer));
                channel.handlePacket((Packet<PacketHandler>)packet);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.channels.clear();
    }

    public void onPlayerJoin(@NotNull McPlayer player) {
        if (!this.voiceServer.getUdpServer().isPresent() || this.voiceServer.getConfig() == null) {
            return;
        }
        VoiceServerPlayer voicePlayer = this.voiceServer.getPlayerManager().getPlayerByInstance(player.getInstance());
        this.voiceServer.getBackgroundExecutor().execute(() -> this.voiceServer.getMinecraftServer().executeInMainThread(() -> this.voiceServer.getTcpPacketManager().requestPlayerInfo(voicePlayer)));
        if (this.shouldKick(player)) {
            this.cancelPlayerCheckFuture(player.getUuid());
            this.playerCheckFutures.put(player.getUuid(), this.voiceServer.getBackgroundExecutor().schedule(() -> this.voiceServer.getMinecraftServer().executeInMainThread(() -> this.kickModRequired(player)), this.voiceServer.getConfig().voice().clientModRequiredCheckTimeoutMs(), TimeUnit.MILLISECONDS));
        }
    }

    public void onPlayerQuit(@NotNull McPlayer player) {
        this.channels.remove(player.getUuid());
        this.cancelPlayerCheckFuture(player.getUuid());
    }

    private boolean shouldKick(@NotNull McPlayer player) {
        return this.voiceServer.getConfig().voice().clientModRequired() && !player.hasPermission("pv.bypass_mod_requirement");
    }

    private void cancelPlayerCheckFuture(@NotNull UUID playerId) {
        ScheduledFuture<?> future = this.playerCheckFutures.remove(playerId);
        if (future != null) {
            future.cancel(false);
        }
    }

    private void kickModRequired(@NotNull McPlayer player) {
        player.kick(McTextComponent.translatable("pv.error.mod_missing_kick_message", new Object[0]));
    }
}

