/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.command;

import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.command.McCommand;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.server.BaseVoiceServer;

public final class VoiceListCommand
implements McCommand {
    private final BaseVoiceServer voiceServer;

    @Override
    public void execute(@NotNull McCommandSource source2, @NotNull String[] arguments) {
        int totalPlayerCount;
        List players;
        if (source2 instanceof McServerPlayer) {
            McServerPlayer sourcePlayer = (McServerPlayer)source2;
            players = this.voiceServer.getPlayerManager().getPlayers().stream().filter(VoicePlayer::hasVoiceChat).filter(player -> sourcePlayer.canSee(player.getInstance())).map(player -> player.getInstance().getName()).sorted().collect(Collectors.toList());
            totalPlayerCount = (int)this.voiceServer.getPlayerManager().getPlayers().stream().filter(player -> sourcePlayer.canSee(player.getInstance())).count();
        } else {
            players = this.voiceServer.getPlayerManager().getPlayers().stream().filter(VoicePlayer::hasVoiceChat).map(player -> player.getInstance().getName()).sorted().collect(Collectors.toList());
            totalPlayerCount = this.voiceServer.getPlayerManager().getPlayers().size();
        }
        source2.sendMessage(McTextComponent.translatable("pv.command.list.message", players.size(), totalPlayerCount, players.size() > 0 ? String.join((CharSequence)", ", players) : McTextComponent.translatable("pv.command.list.empty", new Object[0])));
    }

    @Override
    public boolean hasPermission(@NotNull McCommandSource source2, @Nullable String[] arguments) {
        return source2.hasPermission("pv.list");
    }

    public VoiceListCommand(BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }
}

