/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.line;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.line.ServerPlayerSet;
import su.plo.voice.api.server.audio.line.ServerPlayerSetManager;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayerAddPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayerRemovePacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceLinePlayersListPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsu/plo/voice/server/audio/line/VoiceServerPlayerSetManager;", "Lsu/plo/voice/api/server/audio/line/ServerPlayerSetManager;", "sourceLine", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "<init>", "(Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;)V", "playerSets", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/line/ServerPlayerSet;", "setPlayerSet", "", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "playerSet", "getPlayerSet", "createBroadcastSet", "onPlayerQuit", "event", "Lsu/plo/voice/api/server/event/connection/UdpClientDisconnectedEvent;", "VoiceBroadcastPlayerSet", "VoicePlayerSet", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nVoiceServerPlayerSetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerPlayerSetManager.kt\nsu/plo/voice/server/audio/line/VoiceServerPlayerSetManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,131:1\n1557#2:132\n1628#2,3:133\n381#3,7:136\n*S KotlinDebug\n*F\n+ 1 VoiceServerPlayerSetManager.kt\nsu/plo/voice/server/audio/line/VoiceServerPlayerSetManager\n*L\n36#1:132\n36#1:133,3\n41#1:136,7\n*E\n"})
public final class VoiceServerPlayerSetManager
implements ServerPlayerSetManager {
    @NotNull
    private final BaseServerSourceLine sourceLine;
    @NotNull
    private final Map<UUID, ServerPlayerSet> playerSets;

    public VoiceServerPlayerSetManager(@NotNull BaseServerSourceLine sourceLine) {
        Intrinsics.checkNotNullParameter(sourceLine, "sourceLine");
        this.sourceLine = sourceLine;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.playerSets = concurrentMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPlayerSet(@NotNull VoicePlayer player, @Nullable ServerPlayerSet playerSet) {
        Collection<McGameProfile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        if (playerSet == null) {
            this.playerSets.remove(player.getInstance().getUuid());
            player.sendPacket(new SourceLinePlayersListPacket(this.sourceLine.getId(), CollectionsKt.emptyList()));
            return;
        }
        this.playerSets.put(player.getInstance().getUuid(), playerSet);
        Iterable iterable = playerSet.getPlayers();
        UUID uUID = this.sourceLine.getId();
        VoicePlayer voicePlayer = player;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VoicePlayer voicePlayer2 = (VoicePlayer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInstance().getGameProfile());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        UUID uUID2 = uUID;
        voicePlayer.sendPacket(new SourceLinePlayersListPacket(uUID2, list));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ServerPlayerSet getPlayerSet(@NotNull VoicePlayer player) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Map<UUID, ServerPlayerSet> map2 = this.playerSets;
        UUID key$iv = player.getInstance().getUuid();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ServerPlayerSet answer$iv = new VoicePlayerSet(player);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ServerPlayerSet)object;
    }

    @Override
    @NotNull
    public ServerPlayerSet createBroadcastSet() {
        return new VoiceBroadcastPlayerSet();
    }

    @EventSubscribe
    public final void onPlayerQuit(@NotNull UdpClientDisconnectedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.playerSets.remove(event.getConnection().getPlayer().getInstance().getUuid());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0014\u0010\u0011\u001a\u00020\n2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lsu/plo/voice/server/audio/line/VoiceServerPlayerSetManager$VoiceBroadcastPlayerSet;", "Lsu/plo/voice/api/server/audio/line/ServerPlayerSet;", "<init>", "(Lsu/plo/voice/server/audio/line/VoiceServerPlayerSetManager;)V", "players", "", "Lsu/plo/voice/api/server/player/VoicePlayer;", "getPlayers", "()Ljava/util/Set;", "addPlayer", "", "player", "removePlayer", "", "playerId", "Ljava/util/UUID;", "clearPlayers", "broadcast", "packet", "Lsu/plo/voice/proto/packets/Packet;", "server-proxy-common"})
    public final class VoiceBroadcastPlayerSet
    implements ServerPlayerSet {
        @NotNull
        private final Set<VoicePlayer> players;

        public VoiceBroadcastPlayerSet() {
            CopyOnWriteArraySet copyOnWriteArraySet = Sets.newCopyOnWriteArraySet();
            Intrinsics.checkNotNullExpressionValue(copyOnWriteArraySet, "newCopyOnWriteArraySet(...)");
            this.players = copyOnWriteArraySet;
        }

        @NotNull
        public Set<VoicePlayer> getPlayers() {
            return this.players;
        }

        @Override
        public void addPlayer(@NotNull VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            if (this.getPlayers().contains(player)) {
                return;
            }
            this.broadcast(new SourceLinePlayerAddPacket(VoiceServerPlayerSetManager.this.sourceLine.getId(), player.getInstance().getGameProfile()));
            this.getPlayers().add(player);
            player.sendPacket(new SourceLinePlayersListPacket(VoiceServerPlayerSetManager.this.sourceLine.getId(), this.getPlayers().stream().map(arg_0 -> VoiceBroadcastPlayerSet.addPlayer$lambda$1(VoiceBroadcastPlayerSet::addPlayer$lambda$0, arg_0)).collect(Collectors.toList())));
        }

        @Override
        public boolean removePlayer(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Boolean bl = this.getPlayers().stream().filter(arg_0 -> VoiceBroadcastPlayerSet.removePlayer$lambda$3(arg_0 -> VoiceBroadcastPlayerSet.removePlayer$lambda$2(playerId, arg_0), arg_0)).findFirst().map(arg_0 -> VoiceBroadcastPlayerSet.removePlayer$lambda$5(arg_0 -> VoiceBroadcastPlayerSet.removePlayer$lambda$4(this, VoiceServerPlayerSetManager.this, playerId, arg_0), arg_0)).orElse(false);
            Intrinsics.checkNotNullExpressionValue(bl, "orElse(...)");
            return bl;
        }

        @Override
        public void clearPlayers() {
            this.getPlayers().forEach(arg_0 -> VoiceBroadcastPlayerSet.clearPlayers$lambda$6(VoiceServerPlayerSetManager.this, arg_0));
            this.getPlayers().clear();
        }

        private final void broadcast(Packet<?> packet) {
            this.getPlayers().forEach(arg_0 -> VoiceBroadcastPlayerSet.broadcast$lambda$7(packet, arg_0));
        }

        private static final McGameProfile addPlayer$lambda$0(VoicePlayer it) {
            return it.getInstance().getGameProfile();
        }

        private static final McGameProfile addPlayer$lambda$1(Function1 $tmp0, Object p0) {
            return (McGameProfile)$tmp0.invoke(p0);
        }

        private static final boolean removePlayer$lambda$2(UUID $playerId, VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return Intrinsics.areEqual(player.getInstance().getUuid(), $playerId);
        }

        private static final boolean removePlayer$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Boolean removePlayer$lambda$4(VoiceBroadcastPlayerSet this$0, VoiceServerPlayerSetManager this$1, UUID $playerId, VoicePlayer player) {
            this$0.broadcast(new SourceLinePlayerRemovePacket(this$1.sourceLine.getId(), $playerId));
            this$0.getPlayers().remove(player);
            return true;
        }

        private static final Boolean removePlayer$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void clearPlayers$lambda$6(VoiceServerPlayerSetManager this$0, VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            player.sendPacket(new SourceLinePlayersListPacket(this$0.sourceLine.getId(), CollectionsKt.emptyList()));
        }

        private static final void broadcast$lambda$7(Packet $packet, VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            player.sendPacket($packet);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lsu/plo/voice/server/audio/line/VoiceServerPlayerSetManager$VoicePlayerSet;", "Lsu/plo/voice/api/server/audio/line/ServerPlayerSet;", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "<init>", "(Lsu/plo/voice/server/audio/line/VoiceServerPlayerSetManager;Lsu/plo/voice/api/server/player/VoicePlayer;)V", "players", "", "getPlayers", "()Ljava/util/Set;", "addPlayer", "", "removePlayer", "", "playerId", "Ljava/util/UUID;", "clearPlayers", "server-proxy-common"})
    public final class VoicePlayerSet
    implements ServerPlayerSet {
        @NotNull
        private final VoicePlayer player;
        @NotNull
        private final Set<VoicePlayer> players;

        public VoicePlayerSet(VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.player = player;
            CopyOnWriteArraySet copyOnWriteArraySet = Sets.newCopyOnWriteArraySet();
            Intrinsics.checkNotNullExpressionValue(copyOnWriteArraySet, "newCopyOnWriteArraySet(...)");
            this.players = copyOnWriteArraySet;
        }

        @NotNull
        public Set<VoicePlayer> getPlayers() {
            return this.players;
        }

        @Override
        public void addPlayer(@NotNull VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.getPlayers().add(player);
            player.sendPacket(new SourceLinePlayerAddPacket(VoiceServerPlayerSetManager.this.sourceLine.getId(), player.getInstance().getGameProfile()));
        }

        @Override
        public boolean removePlayer(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Boolean bl = this.getPlayers().stream().filter(arg_0 -> VoicePlayerSet.removePlayer$lambda$1(arg_0 -> VoicePlayerSet.removePlayer$lambda$0(playerId, arg_0), arg_0)).findFirst().map(arg_0 -> VoicePlayerSet.removePlayer$lambda$3(arg_0 -> VoicePlayerSet.removePlayer$lambda$2(VoiceServerPlayerSetManager.this, playerId, this, arg_0), arg_0)).orElse(false);
            Intrinsics.checkNotNullExpressionValue(bl, "orElse(...)");
            return bl;
        }

        @Override
        public void clearPlayers() {
            this.player.sendPacket(new SourceLinePlayersListPacket(VoiceServerPlayerSetManager.this.sourceLine.getId()));
            this.getPlayers().clear();
        }

        private static final boolean removePlayer$lambda$0(UUID $playerId, VoicePlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            return Intrinsics.areEqual(player.getInstance().getUuid(), $playerId);
        }

        private static final boolean removePlayer$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Boolean removePlayer$lambda$2(VoiceServerPlayerSetManager this$0, UUID $playerId, VoicePlayerSet this$1, VoicePlayer player) {
            player.sendPacket(new SourceLinePlayerRemovePacket(this$0.sourceLine.getId(), $playerId));
            this$1.getPlayers().remove(player);
            return true;
        }

        private static final Boolean removePlayer$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

