/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.capture;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u007f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010\u0015\u001a\u00020\r\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0006H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0006H\u0016J\b\u0010+\u001a\u00020(H\u0016J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010/\u001a\u00020(2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\rH\u0016J\u0010\u00102\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u00103\u001a\u00020(2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u00104\u001a\u00020\u0004H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001705H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000606H\u0016J\u0010\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020\u001fH\u0016J\u0010\u00109\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u001fH\u0016J\b\u0010:\u001a\u00020(H\u0016J\u0010\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020\"H\u0016J\u0010\u0010=\u001a\u00020\u00102\u0006\u00108\u001a\u00020\"H\u0016J\b\u0010>\u001a\u00020(H\u0016J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020%H\u0016J\u0010\u0010A\u001a\u00020\u00102\u0006\u00108\u001a\u00020%H\u0016J\b\u0010B\u001a\u00020(H\u0016J\u0013\u0010C\u001a\u00020\u00102\b\u0010D\u001a\u0004\u0018\u00010EH\u0096\u0002J\b\u0010F\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001dR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001d\u00a8\u0006G"}, d2={"Lsu/plo/voice/server/audio/capture/VoiceServerActivation;", "Lsu/plo/voice/proto/data/audio/capture/VoiceActivation;", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "permissions", "", "distances", "", "", "defaultDistance", "proximity", "", "transitive", "stereoSupported", "encoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "weight", "requirements", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;", "<init>", "(Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/List;IZZZLsu/plo/voice/proto/data/audio/codec/CodecInfo;ILsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;)V", "getRequirements", "()Lsu/plo/voice/api/server/audio/capture/ServerActivation$Requirements;", "getPermissions", "()Ljava/util/Set;", "activationListeners", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$PlayerActivationListener;", "getActivationListeners", "activationStartListeners", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$PlayerActivationStartListener;", "getActivationStartListeners", "activationEndListeners", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$PlayerActivationEndListener;", "getActivationEndListeners", "addPermission", "", "permission", "removePermission", "clearPermissions", "checkPermissions", "serverPlayer", "Lsu/plo/slib/api/entity/player/McPlayer;", "setDistances", "checkDistance", "distance", "setTransitive", "setProximity", "getAddon", "Ljava/util/Optional;", "", "onPlayerActivation", "activationListener", "removePlayerActivationListener", "clearPlayerActivationListeners", "onPlayerActivationStart", "activationStartListener", "removePlayerActivationStartListener", "clearPlayerActivationStartListeners", "onPlayerActivationEnd", "activationEndListener", "removePlayerActivationEndListener", "clearPlayerActivationEndListeners", "equals", "other", "", "hashCode", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nVoiceServerActivation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerActivation.kt\nsu/plo/voice/server/audio/capture/VoiceServerActivation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1755#2,3:139\n*S KotlinDebug\n*F\n+ 1 VoiceServerActivation.kt\nsu/plo/voice/server/audio/capture/VoiceServerActivation\n*L\n65#1:139,3\n*E\n"})
public final class VoiceServerActivation
extends VoiceActivation
implements ServerActivation {
    @NotNull
    private final AddonContainer addon;
    @Nullable
    private final ServerActivation.Requirements requirements;
    @NotNull
    private final Set<String> permissions;
    @NotNull
    private final Set<ServerActivation.PlayerActivationListener> activationListeners;
    @NotNull
    private final Set<ServerActivation.PlayerActivationStartListener> activationStartListeners;
    @NotNull
    private final Set<ServerActivation.PlayerActivationEndListener> activationEndListeners;

    public VoiceServerActivation(@NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, @NotNull String icon, @NotNull Set<String> permissions, @NotNull List<Integer> distances, int defaultDistance, boolean proximity, boolean transitive, boolean stereoSupported, @Nullable CodecInfo encoderInfo, int weight, @Nullable ServerActivation.Requirements requirements) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(translation, "translation");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(permissions, "permissions");
        Intrinsics.checkNotNullParameter(distances, "distances");
        super(name, translation, icon, distances, defaultDistance, proximity, stereoSupported, transitive, encoderInfo, weight);
        this.addon = addon;
        this.requirements = requirements;
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue(set, "newConcurrentHashSet(...)");
        this.activationListeners = set;
        Set set2 = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue(set2, "newConcurrentHashSet(...)");
        this.activationStartListeners = set2;
        Set set3 = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue(set3, "newConcurrentHashSet(...)");
        this.activationEndListeners = set3;
        this.transitive = transitive;
        this.permissions = permissions;
    }

    @Nullable
    public final ServerActivation.Requirements getRequirements() {
        return this.requirements;
    }

    @NotNull
    public final Set<String> getPermissions() {
        return this.permissions;
    }

    @NotNull
    public final Set<ServerActivation.PlayerActivationListener> getActivationListeners() {
        return this.activationListeners;
    }

    @NotNull
    public final Set<ServerActivation.PlayerActivationStartListener> getActivationStartListeners() {
        return this.activationStartListeners;
    }

    @NotNull
    public final Set<ServerActivation.PlayerActivationEndListener> getActivationEndListeners() {
        return this.activationEndListeners;
    }

    @Override
    public void addPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        this.permissions.add(permission);
    }

    @Override
    public void removePermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        this.permissions.remove(permission);
    }

    @Override
    public void clearPermissions() {
        this.permissions.clear();
    }

    @Override
    public boolean checkPermissions(@NotNull McPlayer serverPlayer) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(serverPlayer, "serverPlayer");
            Iterable $this$any$iv = this.permissions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!serverPlayer.hasPermission(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void setDistances(@NotNull List<Integer> distances, int defaultDistance) {
        Intrinsics.checkNotNullParameter(distances, "distances");
        this.distances = distances;
        this.defaultDistance = VoiceActivation.validateDefaultDistance(distances, defaultDistance);
    }

    @Override
    public boolean checkDistance(int distance) {
        if (this.distances.isEmpty()) {
            return true;
        }
        if (this.distances.size() == 2) {
            Integer n = (Integer)this.distances.get(0);
            int n2 = -1;
            if (n != null && n == n2) {
                boolean bl;
                if (1 <= distance) {
                    Object e = this.distances.get(1);
                    Intrinsics.checkNotNullExpressionValue(e, "get(...)");
                    bl = distance <= ((Number)e).intValue();
                } else {
                    bl = false;
                }
                return bl;
            }
        }
        return this.distances.contains(distance);
    }

    @Override
    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    @Override
    public void setProximity(boolean proximity) {
        this.proximity = proximity;
    }

    @Override
    @NotNull
    public AddonContainer getAddon() {
        return this.addon;
    }

    @Override
    @NotNull
    public Optional<ServerActivation.Requirements> getRequirements() {
        Optional<ServerActivation.Requirements> optional = Optional.ofNullable(this.requirements);
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(...)");
        return optional;
    }

    @Override
    @NotNull
    public Collection<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public void onPlayerActivation(@NotNull ServerActivation.PlayerActivationListener activationListener) {
        Intrinsics.checkNotNullParameter(activationListener, "activationListener");
        this.activationListeners.add(activationListener);
    }

    @Override
    public boolean removePlayerActivationListener(@NotNull ServerActivation.PlayerActivationListener activationListener) {
        Intrinsics.checkNotNullParameter(activationListener, "activationListener");
        return this.activationListeners.remove(activationListener);
    }

    @Override
    public void clearPlayerActivationListeners() {
        this.activationListeners.clear();
    }

    @Override
    public void onPlayerActivationStart(@NotNull ServerActivation.PlayerActivationStartListener activationStartListener) {
        Intrinsics.checkNotNullParameter(activationStartListener, "activationStartListener");
        this.activationStartListeners.add(activationStartListener);
    }

    @Override
    public boolean removePlayerActivationStartListener(@NotNull ServerActivation.PlayerActivationStartListener activationListener) {
        Intrinsics.checkNotNullParameter(activationListener, "activationListener");
        return this.activationStartListeners.remove(activationListener);
    }

    @Override
    public void clearPlayerActivationStartListeners() {
        this.activationStartListeners.clear();
    }

    @Override
    public void onPlayerActivationEnd(@NotNull ServerActivation.PlayerActivationEndListener activationEndListener) {
        Intrinsics.checkNotNullParameter(activationEndListener, "activationEndListener");
        this.activationEndListeners.add(activationEndListener);
    }

    @Override
    public boolean removePlayerActivationEndListener(@NotNull ServerActivation.PlayerActivationEndListener activationListener) {
        Intrinsics.checkNotNullParameter(activationListener, "activationListener");
        return this.activationEndListeners.remove(activationListener);
    }

    @Override
    public void clearPlayerActivationEndListeners() {
        this.activationEndListeners.clear();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this || super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

