/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Map;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class LanguagePacket
implements Packet<ClientPacketTcpHandler> {
    private static final int MAX_SIZE = Short.MAX_VALUE;
    private String languageName;
    private Map<String, String> language;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.languageName = in.readUTF();
        this.language = Maps.newHashMap();
        int size = PacketUtil.readSafeInt(in, 0, Short.MAX_VALUE);
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.language.put(key, value);
        }
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        out.writeUTF((String)Preconditions.checkNotNull((Object)this.languageName));
        if (this.language.size() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Language size is too big");
        }
        out.writeInt(this.language.size());
        for (Map.Entry<String, String> entry : this.language.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public LanguagePacket(String languageName, Map<String, String> language) {
        this.languageName = languageName;
        this.language = language;
    }

    public LanguagePacket() {
    }

    public String toString() {
        return "LanguagePacket(languageName=" + this.getLanguageName() + ", language=" + this.getLanguage() + ")";
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public Map<String, String> getLanguage() {
        return this.language;
    }
}

