/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.source;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.data.audio.source.EntitySourceInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.packets.PacketUtil;

public abstract class SourceInfo
implements PacketSerializable {
    protected String addonId;
    protected UUID id;
    protected UUID lineId;
    @Nullable
    protected String name;
    protected byte state;
    @Nullable
    protected CodecInfo decoderInfo;
    protected boolean stereo;
    protected boolean iconVisible;
    protected int angle;

    public static SourceInfo of(ByteArrayDataInput in) throws IOException {
        Type type = Type.valueOf(in.readUTF());
        SourceInfo sourceInfo = type.createSourceInfo();
        sourceInfo.deserialize(in);
        return sourceInfo;
    }

    @Override
    public void deserialize(ByteArrayDataInput in) throws IOException {
        this.addonId = in.readUTF();
        this.id = PacketUtil.readUUID(in);
        this.name = PacketUtil.readNullableString(in);
        this.state = in.readByte();
        if (in.readBoolean()) {
            this.decoderInfo = new CodecInfo();
            this.decoderInfo.deserialize(in);
        }
        this.stereo = in.readBoolean();
        this.lineId = PacketUtil.readUUID(in);
        this.iconVisible = in.readBoolean();
        this.angle = in.readInt();
    }

    @Override
    public void serialize(ByteArrayDataOutput out) throws IOException {
        out.writeUTF(this.getType().name());
        out.writeUTF((String)Preconditions.checkNotNull((Object)this.addonId));
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.id));
        PacketUtil.writeNullableString(out, this.name);
        out.writeByte((int)this.state);
        out.writeBoolean(this.decoderInfo != null);
        if (this.decoderInfo != null) {
            this.decoderInfo.serialize(out);
        }
        out.writeBoolean(this.stereo);
        PacketUtil.writeUUID(out, this.lineId);
        out.writeBoolean(this.iconVisible);
        out.writeInt(this.angle);
    }

    public abstract Type getType();

    public SourceInfo(String addonId, UUID id, UUID lineId, @Nullable String name, byte state, @Nullable CodecInfo decoderInfo, boolean stereo, boolean iconVisible, int angle) {
        this.addonId = addonId;
        this.id = id;
        this.lineId = lineId;
        this.name = name;
        this.state = state;
        this.decoderInfo = decoderInfo;
        this.stereo = stereo;
        this.iconVisible = iconVisible;
        this.angle = angle;
    }

    public SourceInfo() {
    }

    public String toString() {
        return "SourceInfo(addonId=" + this.getAddonId() + ", id=" + this.getId() + ", lineId=" + this.getLineId() + ", name=" + this.getName() + ", state=" + this.getState() + ", decoderInfo=" + this.getDecoderInfo() + ", stereo=" + this.isStereo() + ", iconVisible=" + this.isIconVisible() + ", angle=" + this.getAngle() + ")";
    }

    public String getAddonId() {
        return this.addonId;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getLineId() {
        return this.lineId;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public byte getState() {
        return this.state;
    }

    @Nullable
    public CodecInfo getDecoderInfo() {
        return this.decoderInfo;
    }

    public boolean isStereo() {
        return this.stereo;
    }

    public boolean isIconVisible() {
        return this.iconVisible;
    }

    public int getAngle() {
        return this.angle;
    }

    public static enum Type {
        PLAYER(PlayerSourceInfo::new),
        ENTITY(EntitySourceInfo::new),
        STATIC(StaticSourceInfo::new),
        DIRECT(DirectSourceInfo::new);

        private final Supplier<SourceInfo> sourceInfoSupplier;

        private Type(Supplier<SourceInfo> sourceInfoSupplier) {
            this.sourceInfoSupplier = sourceInfoSupplier;
        }

        public SourceInfo createSourceInfo() {
            return this.sourceInfoSupplier.get();
        }
    }
}

