/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.line;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.serializer.McGameProfileSerializer;

public class VoiceSourceLine
implements SourceLine,
PacketSerializable {
    public static final String PROXIMITY_NAME = "proximity";
    public static final UUID PROXIMITY_ID = VoiceSourceLine.generateId("proximity");
    protected UUID id;
    protected String name;
    protected String translation;
    protected String icon;
    protected double defaultVolume;
    protected int weight;
    protected Set<McGameProfile> players = null;

    public static UUID generateId(@NotNull String name) {
        return UUID.nameUUIDFromBytes((name + "_line").getBytes(Charsets.UTF_8));
    }

    public VoiceSourceLine(@NotNull String name, @NotNull String translation, @NotNull String icon, double defaultVolume, int weight, @Nullable Set<McGameProfile> players) {
        this.id = VoiceSourceLine.generateId(name);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.translation = translation;
        this.icon = (String)Preconditions.checkNotNull((Object)icon);
        this.defaultVolume = Math.max(Math.min(defaultVolume, 1.0), 0.0);
        this.weight = weight;
        this.players = players;
    }

    @Override
    public void deserialize(ByteArrayDataInput in) throws IOException {
        this.name = in.readUTF();
        this.id = VoiceSourceLine.generateId(this.name);
        this.translation = in.readUTF();
        this.icon = in.readUTF();
        this.defaultVolume = in.readDouble();
        this.weight = in.readInt();
        if (in.readBoolean()) {
            this.players = new HashSet<McGameProfile>();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.players.add(McGameProfileSerializer.INSTANCE.deserialize(in));
            }
        }
    }

    @Override
    public void serialize(ByteArrayDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.translation);
        out.writeUTF(this.icon);
        out.writeDouble(this.defaultVolume);
        out.writeInt(this.weight);
        out.writeBoolean(this.hasPlayers());
        if (this.hasPlayers()) {
            out.writeInt(this.players.size());
            for (McGameProfile player : this.players) {
                McGameProfileSerializer.INSTANCE.serialize(player, out);
            }
        }
    }

    @Override
    public boolean hasPlayers() {
        return this.players != null;
    }

    @Override
    @Nullable
    public Collection<McGameProfile> getPlayers() {
        return this.players;
    }

    public VoiceSourceLine() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoiceSourceLine)) {
            return false;
        }
        VoiceSourceLine other = (VoiceSourceLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VoiceSourceLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        UUID $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result2;
    }

    public String toString() {
        return "VoiceSourceLine(id=" + this.getId() + ", name=" + this.getName() + ", translation=" + this.getTranslation() + ", icon=" + this.getIcon() + ", defaultVolume=" + this.getDefaultVolume() + ", weight=" + this.getWeight() + ", players=" + this.getPlayers() + ")";
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTranslation() {
        return this.translation;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public double getDefaultVolume() {
        return this.defaultVolume;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

