/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.audio.capture;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.data.audio.codec.CodecInfo;

public interface Activation {
    @NotNull
    public static final Pattern NAME_PATTERN = Pattern.compile("[a-z0-9-_]+");

    @NotNull
    public UUID getId();

    @NotNull
    public String getName();

    @NotNull
    public String getTranslation();

    @NotNull
    public String getIcon();

    public List<Integer> getDistances();

    public int getDefaultDistance();

    public int getMinDistance();

    public int getMaxDistance();

    public boolean isProximity();

    public boolean isTransitive();

    default public boolean isStereoSupported() {
        return false;
    }

    public Optional<CodecInfo> getEncoderInfo();

    default public int getWeight() {
        return 0;
    }

    default public boolean checkDistance(int distance) {
        List<Integer> distances = this.getDistances();
        if (distances.isEmpty()) {
            return true;
        }
        if (distances.size() == 2 && distances.get(0) == -1) {
            return distance >= 1 && distance <= distances.get(1);
        }
        return distances.contains(distance);
    }

    default public int calculateAllowedDistance(int distance) {
        if (this.checkDistance(distance)) {
            return distance;
        }
        return this.getDefaultDistance();
    }
}

