/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.language;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.component.McTranslatableText;
import su.plo.slib.api.command.McChatHolder;
import su.plo.voice.api.server.resource.ResourceLoader;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J2\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u001e\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H&J\u001e\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H&J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0010H\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0019R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\"\u00c0\u0006\u0001"}, d2={"Lsu/plo/voice/api/server/language/ServerLanguages;", "", "crowdinEnabled", "", "getCrowdinEnabled", "()Z", "setCrowdinEnabled", "(Z)V", "register", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "resourceLoader", "Lsu/plo/voice/api/server/resource/ResourceLoader;", "languagesFolder", "Ljava/io/File;", "crowdinProjectId", "", "fileName", "url", "Ljava/net/URL;", "getServerLanguage", "", "languageName", "getClientLanguage", "serverLanguage", "()Ljava/util/Map;", "holder", "Lsu/plo/slib/api/command/McChatHolder;", "clientLanguage", "translate", "Lsu/plo/slib/api/chat/component/McTextComponent;", "text", "Lsu/plo/slib/api/chat/component/McTranslatableText;", "key", "server-proxy-common"})
public interface ServerLanguages {
    public boolean getCrowdinEnabled();

    public void setCrowdinEnabled(boolean var1);

    @NotNull
    public CompletableFuture<Void> register(@NotNull ResourceLoader var1, @NotNull File var2);

    @NotNull
    default public CompletableFuture<Void> register(@NotNull String crowdinProjectId, @Nullable String fileName, @NotNull ResourceLoader resourceLoader, @NotNull File languagesFolder) {
        Intrinsics.checkNotNullParameter(crowdinProjectId, "crowdinProjectId");
        Intrinsics.checkNotNullParameter(resourceLoader, "resourceLoader");
        Intrinsics.checkNotNullParameter(languagesFolder, "languagesFolder");
        URL uRL = URI.create("https://crowdin.com/backend/download/project/" + crowdinProjectId + ".zip").toURL();
        Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
        return this.register(uRL, fileName, resourceLoader, languagesFolder);
    }

    @NotNull
    public CompletableFuture<Void> register(@NotNull URL var1, @Nullable String var2, @NotNull ResourceLoader var3, @NotNull File var4);

    @NotNull
    public Map<String, String> getServerLanguage(@Nullable String var1);

    @NotNull
    public Map<String, String> getClientLanguage(@Nullable String var1);

    @NotNull
    default public Map<String, String> getServerLanguage() {
        return this.getServerLanguage((String)null);
    }

    @NotNull
    default public Map<String, String> getServerLanguage(@NotNull McChatHolder holder) {
        Intrinsics.checkNotNullParameter(holder, "holder");
        return this.getServerLanguage(holder.getLanguage());
    }

    @NotNull
    default public Map<String, String> getClientLanguage() {
        return this.getClientLanguage((String)null);
    }

    @NotNull
    default public Map<String, String> getClientLanguage(@NotNull McChatHolder holder) {
        Intrinsics.checkNotNullParameter(holder, "holder");
        return this.getClientLanguage(holder.getLanguage());
    }

    @Nullable
    default public McTextComponent translate(@NotNull McTranslatableText text, @NotNull McChatHolder holder, @NotNull String key) {
        McTextComponent mcTextComponent;
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(holder, "holder");
        Intrinsics.checkNotNullParameter(key, "key");
        Map<String, String> language = this.getServerLanguage(holder.getLanguage());
        if (!language.containsKey(key)) {
            mcTextComponent = text;
        } else {
            String string = language.get(key);
            Intrinsics.checkNotNull(string);
            mcTextComponent = McTextComponent.Companion.literal(string);
        }
        return mcTextComponent;
    }
}

