/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.provider;

import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.provider.AudioFrameProvider;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.AbstractIterator;
import su.plo.voice.libs.kotlin.collections.ArraysKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\b&\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020\u001dJ\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0&*\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0004R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lsu/plo/voice/api/server/audio/provider/CollectionAudioFrameProvider;", "Lsu/plo/voice/api/server/audio/provider/AudioFrameProvider;", "Ljava/lang/AutoCloseable;", "Lsu/plo/voice/libs/kotlin/AutoCloseable;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "stereo", "", "<init>", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Z)V", "frameSize", "", "getFrameSize", "()I", "encryption", "Lsu/plo/voice/api/encryption/Encryption;", "Lorg/jetbrains/annotations/NotNull;", "getEncryption", "()Lsu/plo/voice/api/encryption/Encryption;", "encoder", "Lsu/plo/voice/api/audio/codec/AudioEncoder;", "getEncoder", "()Lsu/plo/voice/api/audio/codec/AudioEncoder;", "frames", "", "", "getFrames", "()Ljava/util/Collection;", "addSamples", "", "samples", "", "addEncodedFrame", "frame", "addEnd", "clear", "close", "splitFrames", "", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nCollectionAudioFrameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionAudioFrameProvider.kt\nsu/plo/voice/api/server/audio/provider/CollectionAudioFrameProvider\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,92:1\n32#2,2:93\n*S KotlinDebug\n*F\n+ 1 CollectionAudioFrameProvider.kt\nsu/plo/voice/api/server/audio/provider/CollectionAudioFrameProvider\n*L\n30#1:93,2\n*E\n"})
public abstract class CollectionAudioFrameProvider
implements AudioFrameProvider,
AutoCloseable {
    private final int frameSize;
    @NotNull
    private final Encryption encryption;
    @NotNull
    private final AudioEncoder encoder;

    public CollectionAudioFrameProvider(@NotNull PlasmoBaseVoiceServer voiceServer, boolean stereo) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        this.frameSize = stereo ? 1920 : 960;
        Encryption encryption = voiceServer.getDefaultEncryption();
        Intrinsics.checkNotNullExpressionValue(encryption, "getDefaultEncryption(...)");
        this.encryption = encryption;
        AudioEncoder audioEncoder = voiceServer.createOpusEncoder(stereo);
        Intrinsics.checkNotNullExpressionValue(audioEncoder, "createOpusEncoder(...)");
        this.encoder = audioEncoder;
    }

    protected final int getFrameSize() {
        return this.frameSize;
    }

    @NotNull
    protected final Encryption getEncryption() {
        return this.encryption;
    }

    @NotNull
    protected final AudioEncoder getEncoder() {
        return this.encoder;
    }

    @NotNull
    protected abstract Collection<byte[]> getFrames();

    public final void addSamples(@NotNull short[] samples) {
        Intrinsics.checkNotNullParameter(samples, "samples");
        if (!this.encoder.isOpen()) {
            throw new IllegalStateException("Frame provider is closed");
        }
        Iterator<short[]> $this$forEach$iv = this.splitFrames(samples, this.frameSize);
        boolean $i$f$forEach = false;
        Iterator<short[]> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            short[] element$iv;
            short[] it = element$iv = iterator2.next();
            boolean bl = false;
            byte[] byArray = this.encoder.encode(it);
            Intrinsics.checkNotNullExpressionValue(byArray, "encode(...)");
            this.addEncodedFrame(byArray);
        }
        this.addEnd();
    }

    public final void addEncodedFrame(@NotNull byte[] frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        if (!this.encoder.isOpen()) {
            throw new IllegalStateException("Frame provider is closed");
        }
        byte[] encrypted = this.encryption.encrypt(frame);
        Collection<byte[]> collection = this.getFrames();
        Intrinsics.checkNotNull(encrypted);
        collection.add(encrypted);
    }

    public final void addEnd() {
        if (!this.encoder.isOpen()) {
            throw new IllegalStateException("Frame provider is closed");
        }
        this.getFrames().add(new byte[0]);
        this.encoder.reset();
    }

    public final void clear() {
        this.getFrames().clear();
    }

    @Override
    public final void close() {
        this.encoder.close();
    }

    @NotNull
    protected final Iterator<short[]> splitFrames(@NotNull short[] $this$splitFrames, int frameSize) {
        Intrinsics.checkNotNullParameter($this$splitFrames, "<this>");
        return new AbstractIterator<short[]>($this$splitFrames, frameSize){
            private int index;
            final /* synthetic */ short[] $this_splitFrames;
            final /* synthetic */ int $frameSize;
            {
                this.$this_splitFrames = $receiver;
                this.$frameSize = $frameSize;
            }

            protected void computeNext() {
                short[] samples = this.$this_splitFrames;
                if (this.index >= samples.length || this.index + this.$frameSize > samples.length) {
                    this.done();
                    return;
                }
                short[] sArray = samples;
                int n = this.index;
                int n2 = this.index + this.$frameSize;
                short[] frame = ArraysKt.copyOfRange(sArray, n, n2);
                this.setNext(frame);
                this.index += this.$frameSize;
            }
        };
    }
}

