/*
 * Decompiled with CFR 0.152.
 */
package su.plo.config.entry;

import su.plo.config.entry.ConfigEntry;

public final class IntConfigEntry
extends ConfigEntry<Integer> {
    private int min;
    private int max;

    public IntConfigEntry(int defaultValue, int min, int max) {
        super(defaultValue);
        this.min = min;
        this.max = max;
    }

    public void increment() {
        this.set(((Integer)this.value() + 1) % (this.getMax() + 1));
    }

    public void decrement() {
        this.set((Integer)this.value() - 1 < this.getMin() ? this.getMax() : (Integer)this.value() - 1);
    }

    @Override
    public void set(Integer value) {
        if (this.min != this.max && this.min > 0 && this.max > 0) {
            super.set(Math.max(Math.min(value, this.max), this.min));
        } else {
            super.set(value);
        }
    }

    public void setDefault(int value, int min, int max) {
        super.setDefault(value);
        this.min = min;
        this.max = max;
    }

    @Override
    public void deserialize(Object object) {
        if (object instanceof Long) {
            super.deserialize(((Long)object).intValue());
        } else {
            super.deserialize(object);
        }
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

