/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.system.impl;

import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemAPI;

public class PlayerArgonautsPartySystem
implements IPlayerPartySystemAPI<Party> {
    @Override
    @Nullable
    public Party getPartyByOwner(@Nonnull UUID playerId) {
        Party party = PartyApi.API.getPlayerParty(playerId);
        if (party == null) {
            return null;
        }
        if (!((PartyMember)party.members().getLeader()).profile().getId().equals(playerId)) {
            return null;
        }
        return party;
    }

    @Override
    @Nullable
    public Party getPartyByMember(@Nonnull UUID playerId) {
        return PartyApi.API.getPlayerParty(playerId);
    }

    @Override
    public boolean isPlayerAllying(@Nonnull UUID playerId, @Nonnull UUID potentialAllyPlayerId) {
        return false;
    }

    @Override
    public boolean isPermittedToPartyClaim(@Nonnull UUID playerId) {
        Party party = this.getPartyByMember(playerId);
        if (party == null) {
            return false;
        }
        PartyMember member = (PartyMember)party.members().get(playerId);
        return member != null && member.hasPermission("xaero.pac_party_claim");
    }
}

