/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims.storage;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import net.minecraft.class_3508;
import net.minecraft.class_3532;
import net.minecraft.class_6490;
import xaero.pac.common.claims.PlayerChunkClaimHolder;
import xaero.pac.common.claims.RegionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;

public class RegionClaimsPaletteStorage {
    protected final Object2IntMap<PlayerChunkClaim> paletteHelper;
    private final IntList paletteInts;
    protected final ArrayList<PlayerChunkClaimHolder> palette;
    protected class_6490 storage;
    private boolean constantBits;
    private boolean needsHolderRecalculation;

    public RegionClaimsPaletteStorage(Object2IntMap<PlayerChunkClaim> paletteHelper, IntList paletteInts, ArrayList<PlayerChunkClaimHolder> palette, class_6490 storage, boolean constantBits) {
        if (storage.method_15215() != 1024 || constantBits && storage.method_34896() != 11 || palette.isEmpty() || palette.get(0) != null) {
            throw new IllegalArgumentException();
        }
        this.paletteHelper = paletteHelper;
        this.paletteInts = paletteInts;
        this.palette = palette;
        this.storage = storage;
        this.constantBits = constantBits;
    }

    private PlayerChunkClaimHolder getHolder(int x, int z) {
        return this.palette.get(this.storage.method_15211(RegionClaimsPaletteStorage.getIndex(x, z)));
    }

    public PlayerChunkClaim get(int x, int z) {
        PlayerChunkClaimHolder claimHolder = this.getHolder(x, z);
        return claimHolder == null ? null : claimHolder.getClaim();
    }

    public void set(int x, int z, PlayerChunkClaim value, RegionClaims<?, ?> region) {
        int newPaletteIndex;
        PlayerChunkClaimHolder newHolder;
        if (this.needsHolderRecalculation) {
            this.recalculateHolders();
        }
        PlayerChunkClaimHolder currentHolder = this.getHolder(x, z);
        if (value == null) {
            newHolder = null;
            newPaletteIndex = 0;
        } else {
            newPaletteIndex = this.paletteHelper.getInt((Object)value);
            if (newPaletteIndex == 0) {
                newPaletteIndex = this.palette.size();
                boolean add = true;
                for (int i = 1; i < this.palette.size(); ++i) {
                    if (this.palette.get(i) != null) continue;
                    newPaletteIndex = i;
                    add = false;
                    break;
                }
                this.paletteHelper.put((Object)value, newPaletteIndex);
                newHolder = new PlayerChunkClaimHolder(value);
                if (add) {
                    this.palette.add(newHolder);
                } else {
                    this.palette.set(newPaletteIndex, newHolder);
                }
                region.onAddedToPalette(this, value);
                if (this.paletteInts != null) {
                    if (add) {
                        this.paletteInts.add(value.getSyncIndex());
                    } else {
                        this.paletteInts.set(newPaletteIndex - 1, value.getSyncIndex());
                    }
                }
            } else {
                newHolder = this.palette.get(newPaletteIndex);
            }
        }
        if (newHolder != currentHolder) {
            int index = RegionClaimsPaletteStorage.getIndex(x, z);
            if (currentHolder != null) {
                currentHolder.decrement();
                if (currentHolder.getCount() == 0) {
                    int currentPaletteIndex = this.storage.method_15211(index);
                    this.removePaletteElement(currentPaletteIndex, region);
                }
            }
            if (newHolder != null) {
                newHolder.increment();
            }
            this.ensureSyncableStorageBits();
            this.storage.method_15210(index, newPaletteIndex);
        }
    }

    private void recalculateHolders() {
        for (int i = 0; i < this.storage.method_15215(); ++i) {
            int storageValue = this.storage.method_15211(i);
            if (storageValue <= 0) continue;
            this.palette.get(storageValue).increment();
        }
        this.needsHolderRecalculation = false;
    }

    private void ensureSyncableStorageBits() {
        if (this.constantBits) {
            return;
        }
        int neededBits = class_3532.method_15342((int)this.palette.size());
        if (neededBits <= 1) {
            neededBits = 1;
        } else if (neededBits < 11) {
            neededBits = (neededBits + 1) / 2 * 2;
        }
        if (this.storage.method_34896() < neededBits || this.storage.method_34896() >= 6 && this.storage.method_34896() / neededBits >= 2) {
            class_3508 newStorage = new class_3508(neededBits, 1024);
            int allowedValueLimit = 1 << neededBits;
            class_6490 oldStorage = this.storage;
            for (int i = 0; i < 1024; ++i) {
                int oldValue = oldStorage.method_15211(i);
                if (oldValue >= allowedValueLimit) continue;
                newStorage.method_15210(i, oldValue);
            }
            this.storage = newStorage;
        }
    }

    private void removePaletteElement(int paletteIndex, RegionClaims<?, ?> region) {
        if (paletteIndex == 0) {
            return;
        }
        PlayerChunkClaim removedState = ((PlayerChunkClaimHolder)this.palette.set(paletteIndex, null)).getClaim();
        this.paletteHelper.removeInt((Object)removedState);
        region.onRemovedFromPalette(this, removedState);
        if (this.paletteInts != null) {
            this.paletteInts.set(paletteIndex - 1, -1);
        }
        if (paletteIndex == this.palette.size() - 1) {
            while (this.palette.size() > 1 && this.palette.get(this.palette.size() - 1) == null) {
                this.palette.remove(this.palette.size() - 1);
                if (this.paletteInts == null) continue;
                this.paletteInts.removeInt(this.paletteInts.size() - 1);
            }
        }
    }

    public static int getIndex(int x, int z) {
        return x << 5 | z;
    }

    public int[] getPaletteArray() {
        return this.paletteInts == null ? null : this.paletteInts.toIntArray();
    }

    public int getStorageBits() {
        return this.storage.method_34896();
    }

    public long[] getStorageData() {
        return this.storage.method_15212();
    }

    public boolean isEmpty() {
        return this.palette.size() <= 1;
    }

    public boolean containsState(PlayerChunkClaim state) {
        return this.paletteHelper.containsKey((Object)state);
    }

    public void setNeedsHolderRecalculation(boolean needsHolderRecalculation) {
        this.needsHolderRecalculation = needsHolderRecalculation;
    }
}

