/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Duck
extends NaturalistAnimal
implements NaturalistGeoEntity {
    private static final class_1856 FOOD_ITEMS = class_1856.method_8106(NaturalistTags.ItemTags.DUCK_FOOD_ITEMS);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int eggTime;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.duck.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.duck.walk");
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.sf_nba.duck.swim");
    protected static final RawAnimation FLAP = RawAnimation.begin().thenLoop("animation.sf_nba.duck.flap");

    public Duck(@NotNull class_1299<? extends NaturalistAnimal> entityType, class_1937 level) {
        super(entityType, level);
        this.eggTime = this.field_5974.method_43048(6000) + 6000;
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new MMPathNavigatorGround((class_1308)this, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, FOOD_ITEMS, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1378((class_1314)this, 1.0, 10));
        this.field_6201.method_6277(6, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return this.method_6109() ? dimensions.field_18068 * 0.85f : dimensions.field_18068 * 0.92f;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23719, 0.25);
    }

    public boolean method_6481(class_1799 pStack) {
        return FOOD_ITEMS.method_8093(pStack);
    }

    protected float method_6120() {
        return 0.9f;
    }

    @Nullable
    public Duck getBreedOffspring(class_3218 serverLevel, class_1296 ageableMob) {
        return (Duck)NaturalistEntityTypes.DUCK.get().method_5883((class_1937)serverLevel);
    }

    public static boolean checkDuckSpawnRules(class_1299<? extends Duck> pType, @NotNull class_5425 pLevel, class_3730 pReason, class_2338 pPos, class_5819 pRandom) {
        return pLevel.method_8320(pPos.method_10074()).method_26164(NaturalistTags.BlockTags.DUCKS_SPAWNABLE_ON) || pLevel.method_8320(pPos.method_10074()).method_26227().method_15767(class_3486.field_15517);
    }

    @Nullable
    protected class_3414 method_5994() {
        return NaturalistSoundEvents.DUCK_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return NaturalistSoundEvents.DUCK_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return NaturalistSoundEvents.DUCK_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(NaturalistSoundEvents.DUCK_STEP.get(), 0.1f, 1.2f);
    }

    protected boolean method_5776() {
        return this.field_28627 > this.nextFlap;
    }

    protected void method_5801() {
        this.nextFlap = this.field_28627 + this.flapSpeed / 2.0f;
    }

    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    public void method_5958() {
        if (this.method_5962().method_6241()) {
            this.method_5728(this.method_5962().method_6242() >= 1.2);
        } else {
            this.method_5728(false);
            this.flapping = 0.9f;
        }
        super.method_5958();
    }

    public void method_6007() {
        super.method_6007();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.method_24828() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = class_3532.method_15363((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.method_24828() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        class_243 vec3 = this.method_18798();
        if (!this.method_24828() && vec3.field_1351 < 0.0) {
            this.method_18799(vec3.method_18805(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.method_37908().field_9236 && this.method_5805() && !this.method_6109() && --this.eggTime <= 0) {
            this.method_5783(class_3417.field_15219, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            this.method_5706((class_1935)NaturalistRegistry.DUCK_EGG.get());
            this.method_32876(class_5712.field_28738);
            this.eggTime = this.field_5974.method_43048(6000) + 6000;
        }
    }

    public int method_6110() {
        return 10;
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("EggLayTime")) {
            this.eggTime = compound.method_10550("EggLayTime");
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("EggLayTime", this.eggTime);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Duck> PlayState predicate(AnimationState<E> event) {
        if (this.method_5799()) {
            event.getController().setAnimation(SWIM);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.method_18798().method_37268() > 1.0E-6) {
            if (this.method_5624()) {
                event.getController().setAnimation(WALK);
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(WALK);
            event.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(IDLE);
        event.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    protected <E extends Duck> PlayState flapPredicate(AnimationState<E> event) {
        if (!this.method_24828() && !this.method_5799()) {
            event.getController().setAnimation(FLAP);
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "flapController", 2, this::flapPredicate)});
    }
}

