/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension;
import net.minecraft.class_1657;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_22.class})
public abstract class MapDataMixin
extends class_18
implements ExpandedMapData {
    @Final
    @Shadow
    public byte field_119;
    @Final
    @Shadow
    Map<String, class_20> field_117;
    @Shadow
    @Final
    private Map<String, class_17> field_123;
    @Shadow
    public int field_116;
    @Shadow
    public int field_115;
    @Shadow
    @Final
    private List<class_22.class_23> field_112;
    @Unique
    public Map<String, CustomMapDecoration> moonlight$customDecorations = Maps.newLinkedHashMap();
    @Unique
    private final Map<String, MapBlockMarker<?>> moonlight$customMapMarkers = Maps.newHashMap();
    @Unique
    public final Map<class_2960, CustomMapData<?>> moonlight$customData = new LinkedHashMap();

    @Override
    public void setCustomDecorationsDirty() {
        this.method_80();
        this.field_112.forEach(h -> ((IHoldingPlayerExtension)h).moonlight$setCustomMarkersDirty());
    }

    @Override
    public <H extends CustomMapData.DirtyCounter> void setCustomDataDirty(CustomMapData.Type<?> type, Consumer<H> dirtySetter) {
        this.method_80();
        this.field_112.forEach(h -> ((IHoldingPlayerExtension)h).moonlight$setCustomDataDirty(type, dirtySetter));
    }

    @Override
    public Map<class_2960, CustomMapData<?>> getCustomData() {
        return this.moonlight$customData;
    }

    @Override
    public Map<String, CustomMapDecoration> getCustomDecorations() {
        return this.moonlight$customDecorations;
    }

    @Override
    public Map<String, MapBlockMarker<?>> getCustomMarkers() {
        return this.moonlight$customMapMarkers;
    }

    @Override
    public int getVanillaDecorationSize() {
        return this.field_117.size();
    }

    @Override
    public <M extends MapBlockMarker<?>> void addCustomMarker(M marker) {
        Object decoration = marker.createDecorationFromMarker((class_22)this);
        if (decoration != null) {
            this.moonlight$customDecorations.put(marker.getMarkerId(), (CustomMapDecoration)decoration);
            if (marker.shouldSave()) {
                this.moonlight$customMapMarkers.put(marker.getMarkerId(), marker);
            }
            this.setCustomDecorationsDirty();
        }
    }

    @Override
    public boolean removeCustomMarker(String key) {
        this.moonlight$customDecorations.remove(key);
        if (this.moonlight$customMapMarkers.containsKey(key)) {
            this.moonlight$customMapMarkers.remove(key);
            this.setCustomDecorationsDirty();
            return true;
        }
        return false;
    }

    @Override
    public class_22 copy() {
        class_22 newData = class_22.method_32371((class_2487)this.method_75(new class_2487()));
        newData.method_80();
        return newData;
    }

    @Override
    public void resetCustomDecoration() {
        if (!this.field_123.isEmpty() || !this.moonlight$customMapMarkers.isEmpty()) {
            this.setCustomDecorationsDirty();
        }
        for (String key : this.moonlight$customMapMarkers.keySet()) {
            this.moonlight$customDecorations.remove(key);
        }
        this.moonlight$customMapMarkers.clear();
        for (String key : this.field_123.keySet()) {
            this.field_117.remove(key);
        }
        this.field_123.clear();
    }

    @Override
    public boolean toggleCustomDecoration(class_1936 world, class_2338 pos) {
        if (world.method_8608()) {
            List<MapBlockMarker<?>> markers = MapDataInternal.getMarkersFromWorld((class_1922)world, pos);
            return !markers.isEmpty();
        }
        double d0 = (double)pos.method_10263() + 0.5;
        double d1 = (double)pos.method_10260() + 0.5;
        int i = 1 << this.field_119;
        double d2 = (d0 - (double)this.field_116) / (double)i;
        double d3 = (d1 - (double)this.field_115) / (double)i;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            List<MapBlockMarker<?>> markers = MapDataInternal.getMarkersFromWorld((class_1922)world, pos);
            boolean changed = false;
            for (MapBlockMarker<?> marker : markers) {
                if (marker == null) continue;
                String id = marker.getMarkerId();
                if (marker.equals(this.moonlight$customMapMarkers.get(id))) {
                    this.removeCustomMarker(id);
                } else {
                    this.addCustomMarker(marker);
                }
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Inject(method={"locked"}, at={@At(value="RETURN")})
    public void locked(CallbackInfoReturnable<class_22> cir) {
        class_22 data = (class_22)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomMarkers().putAll(this.getCustomMarkers());
            expandedMapData.getCustomDecorations().putAll(this.getCustomDecorations());
        }
        this.moonlight$copyCustomData(data, false);
    }

    @Inject(method={"scaled"}, at={@At(value="RETURN")})
    public void scaled(CallbackInfoReturnable<class_22> cir) {
        class_22 data = (class_22)cir.getReturnValue();
        this.moonlight$copyCustomData(data, true);
    }

    @Unique
    private void moonlight$copyCustomData(class_22 data, boolean isScaled) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData ed = (ExpandedMapData)data;
            for (Map.Entry<class_2960, CustomMapData<?>> entry : this.moonlight$customData.entrySet()) {
                CustomMapData<?> customData = entry.getValue();
                boolean persists = isScaled ? customData.persistOnRescale() : customData.persistOnCopyOrLock();
                if (!persists) continue;
                class_2487 t = new class_2487();
                customData.save(t);
                ed.getCustomData().get(entry.getKey()).load(t);
            }
        }
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="TAIL")})
    public void tickCarriedBy(class_1657 player, class_1799 stack, CallbackInfo ci) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("CustomDecorations", 9)) {
            class_2499 listTag = tag.method_10554("CustomDecorations", 10);
            for (int j = 0; j < listTag.size(); ++j) {
                class_2487 com = listTag.method_10602(j);
                if (this.field_117.containsKey(com.method_10558("id"))) continue;
                String name = com.method_10558("type");
                MapDecorationType<CustomMapDecoration, ?> type = MapDataInternal.get(name);
                if (type != null) {
                    class_2338 pos = new class_2338(com.method_10550("x"), 64, com.method_10550("z"));
                    Object marker = type.createEmptyMarker();
                    ((MapBlockMarker)marker).setPos(pos);
                    this.addCustomMarker((MapBlockMarker)marker);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to load map decoration " + name + ". Skipping it");
            }
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private static void load(class_2487 compound, CallbackInfoReturnable<class_22> cir) {
        class_22 data = (class_22)cir.getReturnValue();
        if (compound.method_10545("customMarkers") && data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            class_2499 listNBT = compound.method_10554("customMarkers", 10);
            for (int j = 0; j < listNBT.size(); ++j) {
                MapBlockMarker<?> marker = MapDataInternal.readWorldMarker(listNBT.method_10602(j));
                if (marker == null) continue;
                mapData.getCustomMarkers().put(marker.getMarkerId(), marker);
                mapData.addCustomMarker(marker);
            }
            mapData.getCustomData().values().forEach(customMapData -> customMapData.load(compound));
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    public void save(class_2487 tag, CallbackInfoReturnable<class_2487> cir) {
        class_2487 com = (class_2487)cir.getReturnValue();
        class_2499 listNBT = new class_2499();
        for (MapBlockMarker<?> marker : this.moonlight$customMapMarkers.values()) {
            if (!marker.shouldSave()) continue;
            class_2487 com2 = new class_2487();
            com2.method_10566(marker.getTypeId(), (class_2520)marker.saveToNBT());
            listNBT.add((Object)com2);
        }
        com.method_10566("customMarkers", (class_2520)listNBT);
        this.moonlight$customData.forEach((s, o) -> o.save(tag));
    }

    @Inject(method={"checkBanners"}, at={@At(value="TAIL")})
    public void checkCustomDeco(class_1922 world, int x, int z, CallbackInfo ci) {
        ArrayList<String> toRemove = new ArrayList<String>();
        ArrayList toAdd = new ArrayList();
        for (Map.Entry<String, MapBlockMarker<?>> e : this.moonlight$customMapMarkers.entrySet()) {
            MapBlockMarker<?> marker = e.getValue();
            if (marker.getPos().method_10263() != x || marker.getPos().method_10260() != z || !marker.shouldRefresh()) continue;
            Object newMarker = marker.getType().getWorldMarkerFromWorld(world, marker.getPos());
            String id = e.getKey();
            if (newMarker == null) {
                toRemove.add(id);
                continue;
            }
            if (Objects.equals(marker, newMarker)) continue;
            toRemove.add(id);
            toAdd.add(newMarker);
        }
        toRemove.forEach(this::removeCustomMarker);
        toAdd.forEach(this::addCustomMarker);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initCustomData(int i, int j, byte b, boolean bl, boolean bl2, boolean bl3, class_5321 resourceKey, CallbackInfo ci) {
        for (CustomMapData.Type<?> d : MapDataInternal.CUSTOM_MAP_DATA_TYPES.values()) {
            this.moonlight$customData.put(d.id(), (CustomMapData)d.factory().get());
        }
    }
}

