/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemListScreen
extends class_437 {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/item_list.png");
    protected final class_437 parent;
    protected final List<class_1799> items;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int titleLabelX = 8;
    protected int titleLabelY = 6;
    protected int leftPos;
    protected int topPos;
    protected int rowsCount;
    @Nullable
    protected class_1735 hoveredSlot;
    protected List<class_1735> slots = new ArrayList<class_1735>();
    protected long openedAt;

    public ItemListScreen(class_437 parent, class_2561 title, List<class_1799> items) {
        super(title);
        this.parent = parent;
        this.items = items;
        this.openedAt = class_156.method_658();
        class_1277 container = new class_1277((class_1799[])items.toArray(class_1799[]::new));
        List rows = Lists.partition(items, (int)9);
        this.rowsCount = rows.size();
        int rowX = 8;
        int rowY = 18;
        for (int row = 0; row < rows.size(); ++row) {
            List stacks = (List)rows.get(row);
            int rowXToCenterOffset = (162 - stacks.size() * 18) / 2;
            for (int column = 0; column < stacks.size(); ++column) {
                int slotIndex = row * 9 + column;
                this.slots.add(new class_1735((class_1263)container, slotIndex, rowX + rowXToCenterOffset + column * 18, rowY){

                    public boolean method_7680(class_1799 stack) {
                        return false;
                    }

                    public boolean method_7674(class_1657 player) {
                        return false;
                    }
                });
            }
            rowY += 18;
        }
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)Exposure.SoundEvents.CAMERA_GENERIC_CLICK.get(), (float)1.0f));
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        this.imageWidth = 176;
        this.imageHeight = 24 + this.rowsCount * 18;
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        long currentTime = class_156.method_658();
        float animProgress = Math.min(1.0f, (float)(currentTime - this.openedAt) / 200.0f);
        animProgress = 1.0f - (float)Math.pow(1.0f - animProgress, 3.5);
        int left = this.leftPos;
        int top = this.topPos;
        this.method_25420(guiGraphics);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22905(animProgress, animProgress, animProgress);
        guiGraphics.method_51448().method_46416(-((float)this.field_22789 / 2.0f), -((float)this.field_22790 / 2.0f), 0.0f);
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)left, (float)top, 0.0f);
        this.hoveredSlot = null;
        for (class_1735 slot : this.slots) {
            if (slot.method_7682()) {
                this.renderSlot(guiGraphics, slot);
            }
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.method_7682()) continue;
            this.hoveredSlot = slot;
            if (!this.hoveredSlot.method_51306()) continue;
            ItemListScreen.renderSlotHighlight(guiGraphics, slot.field_7873, slot.field_7872, 0);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.method_51448().method_22909();
        RenderSystem.enableDepthTest();
        guiGraphics.method_51448().method_22909();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, 17);
        for (int i = 0; i < this.rowsCount; ++i) {
            guiGraphics.method_25302(TEXTURE, this.leftPos, this.topPos + 17 + i * 18, 0, 17, this.imageWidth, 18);
        }
        guiGraphics.method_25302(TEXTURE, this.leftPos, this.topPos + 17 + this.rowsCount * 18, 0, 35, this.imageWidth, 7);
        for (class_1735 slot : this.slots) {
            guiGraphics.method_25302(TEXTURE, this.leftPos + slot.field_7873 - 1, this.topPos + slot.field_7872 - 1, 176, 0, 18, 18);
        }
    }

    protected void renderLabels(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderSlot(class_332 guiGraphics, class_1735 slot) {
        int x = slot.field_7873;
        int y = slot.field_7872;
        class_1799 itemStack = slot.method_7677();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        guiGraphics.method_51428(itemStack, x, y, slot.field_7873 + slot.field_7872 * this.imageWidth);
        guiGraphics.method_51432(this.field_22793, itemStack, x, y, null);
        guiGraphics.method_51448().method_22909();
    }

    public static void renderSlotHighlight(class_332 guiGraphics, int x, int y, int blitOffset) {
        guiGraphics.method_51740(class_1921.method_51785(), x, y, x + 16, y + 16, -2130706433, -2130706433, blitOffset);
    }

    protected void renderTooltip(class_332 guiGraphics, int x, int y) {
        if (this.hoveredSlot != null && this.hoveredSlot.method_7681()) {
            class_1799 itemStack = this.hoveredSlot.method_7677();
            guiGraphics.method_51437(this.field_22793, this.getTooltipFromContainerItem(itemStack), itemStack.method_32347(), x, y);
        }
    }

    protected List<class_2561> getTooltipFromContainerItem(class_1799 stack) {
        return class_465.method_25408((class_310)class_310.method_1551(), (class_1799)stack);
    }

    protected boolean isHovering(class_1735 slot, double mouseX, double mouseY) {
        return this.isHovering(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        double d;
        double d2;
        int i = this.leftPos;
        int j = this.topPos;
        mouseX -= (double)i;
        if (!(d2 >= (double)(x - 1))) return false;
        if (!(mouseX < (double)(x + width + 1))) return false;
        mouseY -= (double)j;
        if (!(d >= (double)(y - 1))) return false;
        if (!(mouseY < (double)(y + height + 1))) return false;
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }
}

