/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.sound.download;

import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.common.sound.download.SoundCloudSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_3521;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class SoundCloudIdTracker {
    private static final Object LOCK = new Object();
    private static final Pattern PAGE_APP_SCRIPT_PATTERN = Pattern.compile("https://[A-Za-z0-9-.]+/assets/[a-f0-9-]+\\.js");
    private static final Pattern APP_SCRIPT_CLIENT_ID_PATTERN = Pattern.compile(",client_id:\"([a-zA-Z0-9-_]+)\"");
    private static volatile String currentId;
    private static volatile CompletableFuture<?> currentRequest;

    private SoundCloudIdTracker() {
    }

    private static String getLastMatchWithinLimit(Matcher m) {
        String lastMatch = null;
        for (int i = 0; m.find() && i < 9; ++i) {
            lastMatch = m.group();
        }
        return lastMatch;
    }

    private static String findScriptUrl(Proxy proxy) throws IOException {
        try {
            URL uRL = new URL("https://soundcloud.com");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            httpURLConnection.setInstanceFollowRedirects(true);
            Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (httpURLConnection.getResponseCode() != 200) {
                throw new IOException(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            }
            String result = SoundCloudIdTracker.getLastMatchWithinLimit(PAGE_APP_SCRIPT_PATTERN.matcher(IOUtils.toString((InputStream)httpURLConnection.getInputStream(), (Charset)StandardCharsets.UTF_8)));
            if (result == null) {
                throw new IllegalStateException("Could not find application script from main page.");
            }
            return result;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Nullable
    private static String findIdFromScript(String url, Proxy proxy) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection(proxy);
            httpURLConnection.setInstanceFollowRedirects(true);
            Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (httpURLConnection.getResponseCode() != 200) {
                throw new IOException(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            }
            Matcher clientIdMatcher = APP_SCRIPT_CLIENT_ID_PATTERN.matcher(IOUtils.toString((InputStream)httpURLConnection.getInputStream(), (Charset)StandardCharsets.UTF_8));
            return clientIdMatcher.find() ? clientIdMatcher.group(1) : null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static synchronized void findIdFromSite(Proxy proxy) {
        if (currentId != null) {
            return;
        }
        if (currentRequest == null || currentRequest.isDone()) {
            currentRequest = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                SoundCloudSource.LOGGER.info("Retrieving sound cloud id");
                try {
                    String clientId = SoundCloudIdTracker.findIdFromScript(SoundCloudIdTracker.findScriptUrl(proxy), proxy);
                    if (clientId == null) {
                        throw new IOException("Failed to find client id from soundcloud script");
                    }
                    return clientId;
                }
                catch (Throwable e) {
                    throw new CompletionException(e);
                }
            }, (Executor)class_3521.field_15664).thenApplyAsync(clientId -> {
                Object object = LOCK;
                synchronized (object) {
                    currentId = clientId;
                    return currentId;
                }
            }, (Executor)class_156.method_18349())).exceptionally(e -> null);
        }
        currentRequest.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        Object object = LOCK;
        synchronized (object) {
            currentId = null;
        }
    }

    public static String fetch(Proxy proxy) {
        if (currentId == null) {
            SoundCloudIdTracker.findIdFromSite(proxy);
            return currentId;
        }
        return currentId;
    }
}

