/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.network.play.handler;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundTracker;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.common.menu.AlbumJukeboxMenu;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayEntityMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundPlayMusicPacket;
import gg.moonflower.etched.common.network.play.ClientboundSetUrlPacket;
import gg.moonflower.etched.common.network.play.SetAlbumJukeboxTrackPacket;
import gg.moonflower.etched.core.mixin.LevelRendererAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class EtchedClientPlayPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handlePlayMusicPacket(ClientboundPlayMusicPacket pkt, class_310 client) {
        class_638 level = client.field_1687;
        if (level == null) {
            return;
        }
        client.execute(() -> {
            TrackData[] tracks;
            class_2338 pos = pkt.pos();
            Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)client.field_1769).getPlayingRecords();
            class_1113 soundInstance = playingRecords.get(pos);
            if (soundInstance != null) {
                client.method_1483().method_4870(soundInstance);
                playingRecords.remove(pos);
            }
            if ((tracks = pkt.tracks()).length == 0) {
                return;
            }
            SoundTracker.playBlockRecord(pos, tracks, 0);
        });
    }

    public static void handlePlayEntityMusicPacket(ClientboundPlayEntityMusicPacket pkt, class_310 client) {
        class_638 level = client.field_1687;
        if (level == null) {
            return;
        }
        client.execute(() -> {
            int entityId = pkt.getEntityId();
            class_1113 soundInstance = SoundTracker.getEntitySound(entityId);
            if (soundInstance != null) {
                if (soundInstance instanceof StopListeningSound) {
                    ((StopListeningSound)soundInstance).stopListening();
                }
                if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.RESTART && client.method_1483().method_4877(soundInstance)) {
                    return;
                }
                SoundTracker.setEntitySound(entityId, null);
            }
            if (pkt.getAction() == ClientboundPlayEntityMusicPacket.Action.STOP) {
                return;
            }
            class_1297 entity = level.method_8469(entityId);
            if (entity == null) {
                LOGGER.error("Server sent sound for nonexistent entity: " + entityId);
                return;
            }
            class_1799 record = pkt.getRecord();
            if (!PlayableRecord.isPlayableRecord(record)) {
                LOGGER.error("Server sent invalid music disc: " + String.valueOf(record));
                return;
            }
            Optional<? extends class_1113> sound = ((PlayableRecord)record.method_7909()).createEntitySound(record, entity, 0);
            if (sound.isEmpty()) {
                LOGGER.error("Server sent invalid music disc: " + String.valueOf(record));
                return;
            }
            StopListeningSound entitySound = StopListeningSound.create(sound.get(), () -> client.method_18858(() -> {
                SoundTracker.setEntitySound(entityId, null);
                SoundTracker.playEntityRecord(record, entityId, 1, false);
            }));
            SoundTracker.setEntitySound(entityId, entitySound);
        });
    }

    public static void handleSetInvalidEtch(ClientboundInvalidEtchUrlPacket pkt, class_310 client) {
        client.execute(() -> {
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof EtchingScreen) {
                EtchingScreen screen = (EtchingScreen)patt0$temp;
                screen.setReason(pkt.exception());
            }
        });
    }

    public static void handleSetUrl(ClientboundSetUrlPacket pkt, class_310 client) {
        client.execute(() -> {
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof RadioScreen) {
                RadioScreen screen = (RadioScreen)patt0$temp;
                screen.receiveUrl(pkt.url());
            }
        });
    }

    public static void handleSetAlbumJukeboxTrack(SetAlbumJukeboxTrackPacket pkt, class_310 client) {
        client.execute(() -> {
            class_437 patt0$temp;
            if (client.field_1687 != null && (patt0$temp = client.field_1755) instanceof AlbumJukeboxScreen) {
                AlbumJukeboxScreen screen = (AlbumJukeboxScreen)patt0$temp;
                class_2338 pos = ((AlbumJukeboxMenu)screen.method_17577()).getPos();
                if (((AlbumJukeboxMenu)screen.method_17577()).setPlayingTrack((class_1937)client.field_1687, pkt)) {
                    AlbumJukeboxBlockEntity entity = (AlbumJukeboxBlockEntity)Objects.requireNonNull(client.field_1687.method_8321(pos));
                    SoundTracker.playAlbum(entity, entity.method_11010(), client.field_1687, pos, true);
                }
            }
        });
    }
}

