/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.menu;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.common.item.BlankMusicDiscItem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.item.SimpleMusicLabelItem;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.etched.core.registry.EtchedSounds;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3521;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;

public class EtchingMenu
extends class_1703 {
    public static final class_2960 EMPTY_SLOT_MUSIC_DISC = new class_2960("etched", "item/empty_etching_table_slot_music_disc");
    public static final class_2960 EMPTY_SLOT_MUSIC_LABEL = new class_2960("etched", "item/empty_etching_table_slot_music_label");
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("\\s*;\\s*");
    private static final Cache<String, CompletableFuture<TrackData[]>> DATA_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final boolean IGNORE_CACHE = false;
    private static final Set<String> VALID_FORMATS;
    private final class_3914 access;
    private final class_3915 labelIndex;
    private final class_1735 discSlot;
    private final class_1735 labelSlot;
    private final class_1735 resultSlot;
    private final class_1263 input;
    private final class_1263 result;
    private final class_1657 player;
    private String url;
    private int urlId;
    private long lastSoundTime;
    private CompletableFuture<?> currentRequest;
    private int currentRequestId;

    public EtchingMenu(int id, class_1661 inventory) {
        this(id, inventory, class_3914.field_17304);
    }

    public EtchingMenu(class_3917<?> menuType, int id, class_1661 inventory) {
        this(menuType, id, inventory, class_3914.field_17304);
    }

    public EtchingMenu(int id, class_1661 inventory, class_3914 containerLevelAccess) {
        this(EtchedMenus.ETCHING_MENU, id, inventory, containerLevelAccess);
    }

    public EtchingMenu(class_3917<?> menuType, int id, class_1661 inventory, final class_3914 containerLevelAccess) {
        super(menuType, id);
        this.player = inventory.field_7546;
        this.labelIndex = class_3915.method_17403();
        this.input = new class_1277(2){

            public void method_5431() {
                super.method_5431();
                EtchingMenu.this.method_7609((class_1263)this);
            }
        };
        this.result = new class_1277(1){

            public void method_5431() {
                super.method_5431();
            }
        };
        this.access = containerLevelAccess;
        this.discSlot = this.method_7621(new class_1735(this.input, 0, 44, 43){

            public boolean method_7680(class_1799 stack) {
                return stack.method_7909() == EtchedItems.BLANK_MUSIC_DISC.method_8389() || stack.method_7909() == EtchedItems.ETCHED_MUSIC_DISC.method_8389();
            }

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_SLOT_MUSIC_DISC);
            }
        });
        this.labelSlot = this.method_7621(new class_1735(this.input, 1, 62, 43){

            public boolean method_7680(class_1799 stack) {
                return stack.method_7909() instanceof SimpleMusicLabelItem;
            }

            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_SLOT_MUSIC_LABEL);
            }
        });
        this.resultSlot = this.method_7621(new class_1735(this.result, 0, 116, 43){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                EtchingMenu.this.discSlot.method_7671(1);
                EtchingMenu.this.labelSlot.method_7671(1);
                if (!EtchingMenu.this.discSlot.method_7681() || !EtchingMenu.this.labelSlot.method_7681()) {
                    EtchingMenu.this.labelIndex.method_17404(0);
                }
                EtchingMenu.this.setupResultSlot();
                EtchingMenu.this.method_7623();
                containerLevelAccess.method_17393((level, pos) -> {
                    long l = level.method_8510();
                    if (EtchingMenu.this.lastSoundTime != l) {
                        level.method_8396(null, pos, EtchedSounds.UI_ETCHER_TAKE_RESULT, class_3419.field_15245, 1.0f, 1.0f);
                        EtchingMenu.this.lastSoundTime = l;
                    }
                });
                super.method_7667(player, stack);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)inventory, x + y * 9 + 9, 8 + x * 18, 98 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 8 + x * 18, 156));
        }
        this.method_17362(this.labelIndex);
    }

    private static void checkStatus(String url) throws IOException {
        URL uri = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uri.openConnection(Proxy.NO_PROXY);
        if (!uri.getHost().equals("www.dropbox.com")) {
            httpURLConnection.setRequestMethod("HEAD");
        }
        httpURLConnection.setInstanceFollowRedirects(true);
        Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IOException(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
        }
        String contentType = httpURLConnection.getContentType();
        if (!VALID_FORMATS.contains(CONTENT_TYPE_PATTERN.split(contentType.toLowerCase(Locale.ROOT))[0])) {
            throw new IOException("Unsupported Content-Type: " + contentType);
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.access.method_17393((level, pos) -> this.method_7607(player, this.input));
    }

    public boolean method_7597(class_1657 player) {
        return EtchingMenu.method_17695((class_3914)this.access, (class_1657)player, (class_2248)((class_2248)EtchedBlocks.ETCHING_TABLE.get()));
    }

    public boolean method_7604(class_1657 player, int index) {
        if (index >= 0 && index < EtchedMusicDiscItem.LabelPattern.values().length) {
            this.labelIndex.method_17404(index);
            this.setupResultSlot();
            return true;
        }
        return false;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            if (index < 3 ? !this.method_7616(itemStack2, 3, this.field_7761.size(), true) : !this.method_7616(itemStack2, 0, 3, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    public void method_7609(class_1263 container) {
        class_1799 discStack = this.discSlot.method_7677();
        class_1799 labelStack = this.labelSlot.method_7677();
        class_1799 resultStack = this.resultSlot.method_7677();
        if (resultStack.method_7960() && labelStack.method_7960()) {
            if (!discStack.method_7960() && discStack.method_7909() == EtchedItems.ETCHED_MUSIC_DISC.method_8389()) {
                this.labelIndex.method_17404(EtchedMusicDiscItem.getPattern(discStack).ordinal());
            } else {
                this.labelIndex.method_17404(0);
            }
        }
        this.setupResultSlot();
        super.method_7609(container);
    }

    private void setupResultSlot() {
        class_1937 level = this.player.method_37908();
        if (level.method_8608()) {
            return;
        }
        if (this.currentRequest != null && !this.currentRequest.isDone() && this.urlId == this.currentRequestId) {
            return;
        }
        new ClientboundInvalidEtchUrlPacket("").sendToClient((class_3222)this.player);
        this.resultSlot.method_7673(class_1799.field_8037);
        if (this.labelIndex.method_17407() >= 0 && this.labelIndex.method_17407() < EtchedMusicDiscItem.LabelPattern.values().length) {
            class_1799 discStack = this.discSlot.method_7677();
            class_1799 labelStack = this.labelSlot.method_7677();
            if (discStack.method_7909() == EtchedItems.ETCHED_MUSIC_DISC.get() || !discStack.method_7960() && !labelStack.method_7960()) {
                if (this.url == null && !discStack.method_7960()) {
                    this.url = PlayableRecord.getStackAlbum(discStack).map(TrackData::url).orElse(null);
                }
                if (!TrackData.isValidURL(this.url)) {
                    return;
                }
                int currentId = this.currentRequestId = this.urlId;
                this.currentRequest = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    class_1799 resultStack = new class_1799((class_1935)EtchedItems.ETCHED_MUSIC_DISC.get());
                    resultStack.method_7939(1);
                    int discColor = 0x515151;
                    int primaryLabelColor = 0xFFFFFF;
                    int secondaryLabelColor = 0xFFFFFF;
                    TrackData[] data = new TrackData[]{TrackData.EMPTY};
                    if (discStack.method_7909() == EtchedItems.ETCHED_MUSIC_DISC.get()) {
                        discColor = EtchedMusicDiscItem.getDiscColor(discStack);
                        primaryLabelColor = EtchedMusicDiscItem.getLabelPrimaryColor(discStack);
                        secondaryLabelColor = EtchedMusicDiscItem.getLabelSecondaryColor(discStack);
                        data = PlayableRecord.getStackMusic(discStack).orElse(data);
                    }
                    if (data.length == 1 && !labelStack.method_7960()) {
                        data[0] = data[0].withTitle(MusicLabelItem.getTitle(labelStack)).withArtist(MusicLabelItem.getAuthor(labelStack));
                    }
                    if (SoundSourceManager.isValidUrl(this.url)) {
                        try {
                            data = (TrackData[])((CompletableFuture)DATA_CACHE.get((Object)this.url, () -> SoundSourceManager.resolveTracks(this.url, null, Proxy.NO_PROXY))).join();
                        }
                        catch (Exception e) {
                            if (!level.method_8608()) {
                                ClientboundInvalidEtchUrlPacket exceptionPacket = new ClientboundInvalidEtchUrlPacket(e instanceof CompletionException ? e.getCause().getMessage() : e.getMessage());
                                exceptionPacket.sendToClient((class_3222)this.player);
                            }
                            if (e instanceof CompletionException) {
                                throw (CompletionException)e;
                            }
                            throw new CompletionException(e);
                        }
                    }
                    if (!TrackData.isLocalSound(this.url)) {
                        try {
                            EtchingMenu.checkStatus(this.url);
                            data = new TrackData[]{data[0].withUrl(this.url)};
                        }
                        catch (UnknownHostException e) {
                            if (!level.method_8608()) {
                                ClientboundInvalidEtchUrlPacket exception = new ClientboundInvalidEtchUrlPacket("Unknown host: " + this.url);
                                exception.sendToClient((class_3222)this.player);
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                        catch (Exception e) {
                            if (!level.method_8608()) {
                                ClientboundInvalidEtchUrlPacket exception = new ClientboundInvalidEtchUrlPacket(e.getLocalizedMessage());
                                exception.sendToClient((class_3222)this.player);
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                    }
                    if (discStack.method_7909() instanceof BlankMusicDiscItem) {
                        discColor = ((BlankMusicDiscItem)discStack.method_7909()).method_7800(discStack);
                    }
                    if (labelStack.method_7909() instanceof MusicLabelItem) {
                        secondaryLabelColor = primaryLabelColor = MusicLabelItem.getLabelColor(labelStack);
                    } else if (labelStack.method_7909() instanceof ComplexMusicLabelItem) {
                        primaryLabelColor = ComplexMusicLabelItem.getPrimaryColor(labelStack);
                        secondaryLabelColor = ComplexMusicLabelItem.getSecondaryColor(labelStack);
                    }
                    for (int i = 0; i < data.length; ++i) {
                        TrackData trackData = data[i];
                        if (trackData.artist().equals(TrackData.EMPTY.artist())) {
                            trackData = trackData.withArtist(MusicLabelItem.getAuthor(labelStack));
                        }
                        if (TrackData.isLocalSound(this.url)) {
                            trackData = trackData.withUrl(new class_2960(this.url).toString());
                        }
                        data[i] = trackData;
                    }
                    EtchedMusicDiscItem.setMusic(resultStack, data);
                    EtchedMusicDiscItem.setColor(resultStack, discColor, primaryLabelColor, secondaryLabelColor);
                    EtchedMusicDiscItem.setPattern(resultStack, EtchedMusicDiscItem.LabelPattern.values()[this.labelIndex.method_17407()]);
                    return resultStack;
                }, (Executor)class_3521.field_15664).thenAcceptAsync(resultStack -> {
                    if (this.urlId == currentId && !class_1799.method_7973((class_1799)resultStack, (class_1799)this.resultSlot.method_7677()) && !class_1799.method_7973((class_1799)resultStack, (class_1799)this.discSlot.method_7677())) {
                        this.resultSlot.method_7673(resultStack);
                        ++this.urlId;
                        this.urlId %= 1000;
                        this.method_7623();
                    }
                }, (Executor)level.method_8503())).exceptionally(e -> {
                    e.printStackTrace();
                    return null;
                });
            }
        }
    }

    public int getLabelIndex() {
        return this.labelIndex.method_17407();
    }

    public void setUrl(String string) {
        if (!Objects.equals(this.url, string)) {
            this.url = string;
            ++this.urlId;
            this.urlId %= 1000;
            this.setupResultSlot();
        }
    }

    static {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object[])new String[]{"audio/wav", "audio/x-wav", "audio/opus", "application/ogg", "audio/ogg", "audio/mpeg", "application/octet-stream", "application/binary"});
        VALID_FORMATS = builder.build();
    }
}

