/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.item;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.PlayableRecordItem;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.common.item.ContainerItem;
import gg.moonflower.etched.common.menu.AlbumCoverMenu;
import gg.moonflower.etched.core.fabric.EtchedConfig;
import gg.moonflower.etched.core.registry.EtchedItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;

public class AlbumCoverItem
extends PlayableRecordItem
implements ContainerItem {
    public static final int MAX_RECORDS = 9;

    public AlbumCoverItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_21823()) {
            if (AlbumCoverItem.dropContents(stack, player)) {
                this.playDropContentsSound((class_1297)player);
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                return class_1271.method_29237((Object)stack, (boolean)level.method_8608());
            }
            return class_1271.method_22430((Object)stack);
        }
        if (!((EtchedConfig)EtchedConfig.HANDLER.instance()).useAlbumCoverMenu) {
            return class_1271.method_22431((Object)stack);
        }
        return this.use(this, level, player, hand);
    }

    @Override
    public class_1703 constructMenu(int containerId, class_1661 inventory, class_1657 player, int index) {
        return new AlbumCoverMenu(containerId, inventory, index);
    }

    public boolean method_31565(class_1799 albumCover, class_1735 slot, class_5536 clickAction, class_1657 player) {
        if (((EtchedConfig)EtchedConfig.HANDLER.instance()).useAlbumCoverMenu) {
            return false;
        }
        if (clickAction != class_5536.field_27014) {
            return false;
        }
        class_1799 clickItem = slot.method_7677();
        if (clickItem.method_7960()) {
            AlbumCoverItem.removeOne(albumCover).ifPresent(record -> {
                this.playRemoveOneSound((class_1297)player);
                AlbumCoverItem.add(albumCover, slot.method_32756(record));
            });
        } else if (AlbumCoverItem.canAdd(albumCover, clickItem)) {
            this.playInsertSound((class_1297)player);
            AlbumCoverItem.add(albumCover, slot.method_32753(clickItem.method_7947(), 1, player));
        }
        return true;
    }

    public boolean method_31566(class_1799 albumCover, class_1799 clickItem, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (((EtchedConfig)EtchedConfig.HANDLER.instance()).useAlbumCoverMenu) {
            return false;
        }
        if (clickAction == class_5536.field_27014 && slot.method_32754(player)) {
            if (clickItem.method_7960()) {
                AlbumCoverItem.removeOne(albumCover).ifPresent(removedRecord -> {
                    this.playRemoveOneSound((class_1297)player);
                    slotAccess.method_32332(removedRecord);
                });
            } else if (AlbumCoverItem.canAdd(albumCover, clickItem)) {
                this.playInsertSound((class_1297)player);
                AlbumCoverItem.add(albumCover, clickItem);
            }
            return true;
        }
        return false;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        for (class_1799 record : AlbumCoverItem.getRecords(stack)) {
            if (!(record.method_7909() instanceof PlayableRecord)) continue;
            record.method_7909().method_7851(record, level, list, tooltipFlag);
        }
    }

    public void method_33261(class_1542 itemEntity) {
        class_5328.method_33263((class_1542)itemEntity, AlbumCoverItem.getRecords(itemEntity.method_6983()).stream());
    }

    private void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34375, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private static Optional<class_1799> removeOne(class_1799 albumCover) {
        class_2487 tag = albumCover.method_7948();
        if (!tag.method_10573("Records", 9)) {
            return Optional.empty();
        }
        class_2499 recordsNbt = tag.method_10554("Records", 10);
        if (recordsNbt.isEmpty()) {
            return Optional.empty();
        }
        class_2487 recordNbt = recordsNbt.method_10602(recordsNbt.size() - 1);
        class_1799 recordStack = class_1799.method_7915((class_2487)recordNbt);
        recordsNbt.method_10536(recordsNbt.size() - 1);
        return Optional.of(recordStack);
    }

    private static boolean dropContents(class_1799 itemStack, class_1657 player) {
        class_2487 tag = itemStack.method_7948();
        if (!tag.method_10545("Records")) {
            return false;
        }
        if (player instanceof class_3222) {
            class_2499 listTag = tag.method_10554("Records", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                player.method_31548().method_7398(class_1799.method_7915((class_2487)listTag.method_10602(i)));
            }
        }
        itemStack.method_7983("Records");
        return true;
    }

    private static void add(class_1799 albumCover, class_1799 record) {
        if (!albumCover.method_31574(EtchedItems.ALBUM_COVER.method_8389()) || !AlbumCoverMenu.isValid(record)) {
            return;
        }
        class_2487 tag = albumCover.method_7948();
        if (!tag.method_10545("Records")) {
            tag.method_10566("Records", (class_2520)new class_2499());
        }
        class_2499 recordsNbt = tag.method_10554("Records", 10);
        class_1799 singleRecord = record.method_7971(1);
        class_2487 recordTag = new class_2487();
        singleRecord.method_7953(recordTag);
        recordsNbt.add((Object)recordTag);
        if (AlbumCoverItem.getCoverStack(albumCover).isEmpty()) {
            AlbumCoverItem.getRecords(albumCover).stream().filter(stack -> !stack.method_7960()).findFirst().ifPresent(stack -> AlbumCoverItem.setCover(albumCover, stack));
        }
    }

    private static boolean canAdd(class_1799 albumCover, class_1799 record) {
        if (!albumCover.method_31574(EtchedItems.ALBUM_COVER.method_8389()) || !AlbumCoverMenu.isValid(record)) {
            return false;
        }
        return albumCover.method_7969() == null || !albumCover.method_7969().method_10573("Records", 9) || albumCover.method_7969().method_10554("Records", 10).size() < 9;
    }

    @Override
    public Optional<TrackData[]> getMusic(class_1799 stack) {
        List<class_1799> records = AlbumCoverItem.getRecords(stack);
        return records.isEmpty() ? Optional.empty() : Optional.of((TrackData[])records.stream().filter(record -> record.method_7909() instanceof PlayableRecord).flatMap(record -> Arrays.stream(((PlayableRecord)record.method_7909()).getMusic((class_1799)record).orElseGet(() -> new TrackData[0]))).toArray(TrackData[]::new));
    }

    @Override
    public Optional<TrackData> getAlbum(class_1799 stack) {
        return Optional.empty();
    }

    @Override
    public int getTrackCount(class_1799 stack) {
        return AlbumCoverItem.getRecords(stack).stream().filter(record -> record.method_7909() instanceof PlayableRecord).mapToInt(record -> ((PlayableRecord)record.method_7909()).getTrackCount((class_1799)record)).sum();
    }

    public static Optional<class_1799> getCoverStack(class_1799 stack) {
        if (stack.method_7909() != EtchedItems.ALBUM_COVER.method_8389()) {
            return Optional.empty();
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10573("CoverRecord", 10)) {
            return Optional.empty();
        }
        class_1799 cover = class_1799.method_7915((class_2487)nbt.method_10562("CoverRecord"));
        return cover.method_7960() ? Optional.empty() : Optional.of(cover);
    }

    public static List<class_1799> getRecords(class_1799 stack) {
        if (stack.method_7909() != EtchedItems.ALBUM_COVER.method_8389()) {
            return Collections.emptyList();
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10573("Records", 9)) {
            return Collections.emptyList();
        }
        class_2499 recordsNbt = nbt.method_10554("Records", 10);
        if (recordsNbt.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<class_1799> list = new ArrayList<class_1799>(recordsNbt.size());
        for (int i = 0; i < Math.min(9, recordsNbt.size()); ++i) {
            class_1799 record = class_1799.method_7915((class_2487)recordsNbt.method_10602(i));
            if (record.method_7960()) continue;
            list.add(record);
        }
        return list;
    }

    public static void setCover(class_1799 stack, class_1799 record) {
        if (stack.method_7909() != EtchedItems.ALBUM_COVER.method_8389()) {
            return;
        }
        if (record.method_7960()) {
            stack.method_7983("CoverRecord");
            return;
        }
        stack.method_7948().method_10566("CoverRecord", (class_2520)record.method_7953(new class_2487()));
    }

    public static void setRecords(class_1799 stack, Collection<class_1799> records) {
        if (stack.method_7909() != EtchedItems.ALBUM_COVER.method_8389() || records.isEmpty()) {
            return;
        }
        class_2487 nbt = stack.method_7948();
        class_2499 recordsNbt = new class_2499();
        int i = 0;
        for (class_1799 record : records) {
            if (record.method_7960()) continue;
            if (i >= 9) break;
            recordsNbt.add((Object)record.method_7953(new class_2487()));
            ++i;
        }
        nbt.method_10566("Records", (class_2520)recordsNbt);
    }
}

