/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound.source;

import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.AccumulatingDownloadProgressListener;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.StreamingInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_3521;
import org.jetbrains.annotations.Nullable;

public class StreamingAudioSource
implements AudioSource {
    private final URL[] urls;
    private final boolean temporary;
    private final AudioSource.AudioFileType type;
    private final CompletableFuture<?> downloadFuture;
    private CompletableFuture<InputStream> stream;

    public StreamingAudioSource(URL[] urls, @Nullable DownloadProgressListener progressListener, boolean temporary, AudioSource.AudioFileType type) {
        this.urls = urls;
        this.temporary = temporary;
        this.type = type;
        int files = Math.min(urls.length, 3);
        AccumulatingDownloadProgressListener accumulatingListener = progressListener != null ? new AccumulatingDownloadProgressListener(progressListener, files) : null;
        this.downloadFuture = CompletableFuture.allOf((CompletableFuture[])IntStream.range(0, files).mapToObj(i -> CompletableFuture.runAsync(() -> AudioSource.downloadTo(urls[i], temporary, accumulatingListener, type), (Executor)class_3521.field_15664)).toArray(CompletableFuture[]::new));
    }

    @Override
    public CompletableFuture<InputStream> openStream() {
        if (this.stream == null) {
            this.stream = this.downloadFuture.thenApplyAsync(__ -> {
                try {
                    return new StreamingInputStream(this.urls, i -> CompletableFuture.supplyAsync(() -> AudioSource.downloadTo(this.urls[i], this.temporary, null, this.type), (Executor)class_3521.field_15664).thenApplyAsync(stream -> {
                        try {
                            return stream.get();
                        }
                        catch (Exception e) {
                            throw new CompletionException("Failed to open channel", e);
                        }
                    }, (Executor)class_156.method_27958()));
                }
                catch (Exception e) {
                    throw new CompletionException("Failed to open stream", e);
                }
            }, (Executor)class_156.method_27958());
        }
        return this.stream;
    }
}

