/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.AbstractOnlineSoundInstance;
import gg.moonflower.etched.api.sound.OnlineRecordSoundInstance;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.block.RadioBlock;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.core.mixin.LevelRendererAccessor;
import gg.moonflower.etched.core.mixin.client.GuiAccessor;
import gg.moonflower.etched.core.registry.EtchedTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoubleSupplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class SoundTracker {
    private static final Int2ObjectArrayMap<class_1113> ENTITY_PLAYING_SOUNDS = new Int2ObjectArrayMap();
    private static final Set<String> FAILED_URLS = new HashSet<String>();
    private static final class_2561 RADIO = class_2561.method_43471((String)"sound_source.etched.radio");

    private static synchronized void setRecordPlayingNearby(class_1937 level, class_2338 pos, boolean playing) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26164(EtchedTags.AUDIO_PROVIDER) || state.method_27852(class_2246.field_10223)) {
            for (class_1309 livingEntity : level.method_18467(class_1309.class, new class_238(pos).method_1014(3.0))) {
                livingEntity.method_6006(pos, playing);
            }
        }
    }

    @Nullable
    public static class_1113 getEntitySound(int entity) {
        return (class_1113)ENTITY_PLAYING_SOUNDS.get(entity);
    }

    public static void setEntitySound(int entity, @Nullable class_1113 instance) {
        class_1144 soundManager = class_310.method_1551().method_1483();
        if (instance == null) {
            class_1113 old = (class_1113)ENTITY_PLAYING_SOUNDS.remove(entity);
            if (old != null) {
                if (old instanceof StopListeningSound) {
                    ((StopListeningSound)old).stopListening();
                }
                soundManager.method_4870(old);
            }
        } else {
            ENTITY_PLAYING_SOUNDS.put(entity, (Object)instance);
            soundManager.method_4873(instance);
        }
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(final String url, final class_2561 title, final class_1297 entity, int attenuationDistance, boolean stream) {
        return new OnlineRecordSoundInstance(url, entity, attenuationDistance, new MusicDownloadListener(title, () -> ((class_1297)entity).method_23317(), () -> ((class_1297)entity).method_23318(), () -> ((class_1297)entity).method_23321()){

            @Override
            public void onSuccess() {
                if (!entity.method_5805() || !ENTITY_PLAYING_SOUNDS.containsKey(entity.method_5628())) {
                    this.clearComponent();
                } else if (PlayableRecord.canShowMessage(entity.method_23317(), entity.method_23318(), entity.method_23321())) {
                    class_310.method_1551().field_1705.method_1732(title);
                }
            }

            @Override
            public void onFail() {
                class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"record.etched.downloadFail", (Object[])new Object[]{title}), true);
                FAILED_URLS.add(url);
            }
        }, stream ? AudioSource.AudioFileType.STREAM : AudioSource.AudioFileType.FILE);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, class_2561 title, class_1297 entity, boolean stream) {
        return SoundTracker.getEtchedRecord(url, title, entity, 16, stream);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(final String url, final class_2561 title, final class_638 level, final class_2338 pos, int attenuationDistance, AudioSource.AudioFileType type) {
        class_2680 aboveState = level.method_8320(pos.method_10084());
        boolean muffled = aboveState.method_26164(class_3481.field_15481);
        final boolean hidden = !aboveState.method_26215();
        final Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        return new OnlineRecordSoundInstance(url, (float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f, muffled ? 2.0f : 4.0f, muffled ? attenuationDistance / 2 : attenuationDistance, new MusicDownloadListener(title, () -> (double)pos.method_10263() + 0.5, () -> (double)pos.method_10264() + 0.5, () -> (double)pos.method_10260() + 0.5){

            @Override
            public void onSuccess() {
                if (!playingRecords.containsKey(pos)) {
                    this.clearComponent();
                } else {
                    if (!hidden && PlayableRecord.canShowMessage((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)) {
                        class_310.method_1551().field_1705.method_1732(title);
                    }
                    SoundTracker.setRecordPlayingNearby((class_1937)level, pos, true);
                }
            }

            @Override
            public void onFail() {
                class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"record.etched.downloadFail", (Object[])new Object[]{title}), true);
                FAILED_URLS.add(url);
            }
        }, type);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, class_2561 title, class_638 level, class_2338 pos, AudioSource.AudioFileType type) {
        return SoundTracker.getEtchedRecord(url, title, level, pos, 16, type);
    }

    private static void playRecord(class_2338 pos, class_1113 sound) {
        class_1144 soundManager = class_310.method_1551().method_1483();
        Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        playingRecords.put(pos, sound);
        soundManager.method_4873(sound);
    }

    private static void playNextRecord(class_638 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        AlbumJukeboxBlockEntity jukebox = (AlbumJukeboxBlockEntity)blockEntity;
        jukebox.next();
        SoundTracker.playAlbum((AlbumJukeboxBlockEntity)blockEntity, blockEntity.method_11010(), level, pos, true);
    }

    public static void playBlockRecord(class_2338 pos, TrackData[] tracks, int track) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (track >= tracks.length) {
            SoundTracker.setRecordPlayingNearby((class_1937)level, pos, false);
            return;
        }
        TrackData trackData = tracks[track];
        String url = trackData.url();
        if (!TrackData.isValidURL(url) || FAILED_URLS.contains(url)) {
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
            return;
        }
        SoundTracker.playRecord(pos, StopListeningSound.create((class_1113)SoundTracker.getEtchedRecord(url, trackData.getDisplayName(), level, pos, AudioSource.AudioFileType.FILE), () -> class_310.method_1551().method_18858(() -> {
            if (!((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords().containsKey(pos)) {
                return;
            }
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
        })));
    }

    public static void playEntityRecord(class_1799 record, int entityId, int track, int attenuationDistance, boolean loop) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(entityId);
        if (entity == null) {
            return;
        }
        Optional<? extends class_1113> sound = ((PlayableRecord)record.method_7909()).createEntitySound(record, entity, track, attenuationDistance);
        if (sound.isEmpty()) {
            if (loop && track != 0) {
                SoundTracker.playEntityRecord(record, entityId, 0, attenuationDistance, true);
            }
            return;
        }
        class_1113 entitySound = (class_1113)ENTITY_PLAYING_SOUNDS.remove(entity.method_5628());
        if (entitySound != null) {
            if (entitySound instanceof StopListeningSound) {
                ((StopListeningSound)entitySound).stopListening();
            }
            class_310.method_1551().method_1483().method_4870(entitySound);
        }
        entitySound = StopListeningSound.create(sound.get(), () -> class_310.method_1551().method_18858(() -> {
            ENTITY_PLAYING_SOUNDS.remove(entityId);
            SoundTracker.playEntityRecord(record, entityId, track + 1, attenuationDistance, loop);
        }));
        ENTITY_PLAYING_SOUNDS.put(entityId, (Object)entitySound);
        class_310.method_1551().method_1483().method_4873(entitySound);
    }

    public static void playEntityRecord(class_1799 record, int entityId, int track, boolean loop) {
        SoundTracker.playEntityRecord(record, entityId, track, 16, loop);
    }

    public static void playBoombox(int entityId, class_1799 record) {
        SoundTracker.setEntitySound(entityId, null);
        if (!record.method_7960()) {
            SoundTracker.playEntityRecord(record, entityId, 0, 8, true);
        }
    }

    public static void playRadio(@Nullable String url, class_2680 state, class_638 level, class_2338 pos) {
        class_1144 soundManager = class_310.method_1551().method_1483();
        Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        class_1113 soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.method_4870(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby((class_1937)level, pos, false);
        }
        if (FAILED_URLS.contains(url)) {
            return;
        }
        if (!state.method_28498((class_2769)RadioBlock.POWERED) || ((Boolean)state.method_11654((class_2769)RadioBlock.POWERED)).booleanValue()) {
            return;
        }
        if (TrackData.isValidURL(url)) {
            AbstractOnlineSoundInstance record = SoundTracker.getEtchedRecord(url, RADIO, level, pos, 8, AudioSource.AudioFileType.BOTH);
            record.setLoop(true);
            SoundTracker.playRecord(pos, (class_1113)record);
        }
    }

    public static void playAlbum(AlbumJukeboxBlockEntity jukebox, class_2680 state, class_638 level, class_2338 pos, boolean force) {
        Optional<TrackData[]> optional;
        class_1144 soundManager = class_310.method_1551().method_1483();
        Map<class_2338, class_1113> playingRecords = ((LevelRendererAccessor)class_310.method_1551().field_1769).getPlayingRecords();
        if (!state.method_28498((class_2769)AlbumJukeboxBlock.POWERED) || !((Boolean)state.method_11654((class_2769)AlbumJukeboxBlock.POWERED)).booleanValue() && !force && !jukebox.recalculatePlayingIndex(false)) {
            return;
        }
        class_1113 soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.method_4870(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby((class_1937)level, pos, false);
        }
        if (((Boolean)state.method_11654((class_2769)AlbumJukeboxBlock.POWERED)).booleanValue()) {
            jukebox.stopPlaying();
        }
        if (jukebox.getPlayingIndex() < 0) {
            return;
        }
        class_1799 disc = jukebox.method_5438(jukebox.getPlayingIndex());
        StopListeningSound sound = null;
        if (disc.method_7909() instanceof class_1813) {
            sound = StopListeningSound.create((class_1113)SoundTracker.getEtchedRecord(((class_1813)disc.method_7909()).method_8009().method_14833().toString(), (class_2561)((class_1813)disc.method_7909()).method_8011(), level, pos, AudioSource.AudioFileType.FILE), () -> class_310.method_1551().method_18858(() -> SoundTracker.playNextRecord(level, pos)));
        } else if (disc.method_7909() instanceof PlayableRecord && (optional = PlayableRecord.getStackMusic(disc)).isPresent()) {
            TrackData[] tracks = optional.get();
            TrackData track = jukebox.getTrack() < 0 || jukebox.getTrack() >= tracks.length ? tracks[0] : tracks[jukebox.getTrack()];
            String url = track.url();
            if (TrackData.isValidURL(url) && !FAILED_URLS.contains(url)) {
                sound = StopListeningSound.create((class_1113)SoundTracker.getEtchedRecord(url, track.getDisplayName(), level, pos, AudioSource.AudioFileType.FILE), () -> class_310.method_1551().method_18858(() -> SoundTracker.playNextRecord(level, pos)));
            }
        }
        if (sound == null) {
            return;
        }
        SoundTracker.playRecord(pos, sound);
        SoundTracker.setRecordPlayingNearby((class_1937)level, pos, true);
    }

    static {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> FAILED_URLS.clear());
    }

    private static abstract class MusicDownloadListener
    implements DownloadProgressListener {
        private final class_2561 title;
        private final DoubleSupplier x;
        private final DoubleSupplier y;
        private final DoubleSupplier z;
        private final class_2338.class_2339 pos;
        private float size;
        private class_2561 requesting;
        private DownloadTextComponent component;

        protected MusicDownloadListener(class_2561 title, DoubleSupplier x, DoubleSupplier y, DoubleSupplier z) {
            this.title = title;
            this.x = x;
            this.y = y;
            this.z = z;
            this.pos = new class_2338.class_2339();
        }

        private class_2338.class_2339 getPos() {
            return this.pos.method_10102(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble());
        }

        private void setComponent(class_2561 text) {
            if (!(this.component != null || class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_8320((class_2338)this.getPos().method_10098(class_2350.field_11036)).method_26215() && PlayableRecord.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble()))) {
                return;
            }
            if (this.component == null) {
                this.component = new DownloadTextComponent();
                class_310.method_1551().field_1705.method_1758((class_2561)this.component, true);
                ((GuiAccessor)class_310.method_1551().field_1705).setOverlayMessageTime(Short.MAX_VALUE);
            }
            this.component.setText(text.getString());
        }

        protected void clearComponent() {
            if (class_310.method_1551().field_1705.field_2018 == this.component) {
                ((GuiAccessor)class_310.method_1551().field_1705).setOverlayMessageTime(60);
                this.component = null;
            }
        }

        @Override
        public void progressStartRequest(class_2561 component) {
            this.requesting = component;
            this.setComponent(component);
        }

        @Override
        public void progressStartDownload(float size) {
            this.size = size;
            this.requesting = null;
            this.progressStagePercentage(0);
        }

        @Override
        public void progressStagePercentage(int percentage) {
            if (this.requesting != null) {
                this.setComponent((class_2561)this.requesting.method_27661().method_27693(" " + percentage + "%"));
            } else if (this.size != 0.0f) {
                this.setComponent((class_2561)class_2561.method_43469((String)"record.etched.downloadProgress", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf((float)percentage / 100.0f * this.size)), String.format(Locale.ROOT, "%.2f", Float.valueOf(this.size)), this.title}));
            }
        }

        @Override
        public void progressStartLoading() {
            this.requesting = null;
            this.setComponent((class_2561)class_2561.method_43469((String)"record.etched.loading", (Object[])new Object[]{this.title}));
        }

        @Override
        public void onFail() {
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43469((String)"record.etched.downloadFail", (Object[])new Object[]{this.title}), true);
        }
    }

    private static class DownloadTextComponent
    implements class_2561 {
        private class_7417 contents = class_7417.field_39004;
        private class_5481 visualOrderText = class_5481.field_26385;
        private class_2477 decomposedWith = null;

        public class_7417 method_10851() {
            return this.contents;
        }

        public List<class_2561> method_10855() {
            return Collections.emptyList();
        }

        public class_2583 method_10866() {
            return class_2583.field_24360;
        }

        public class_5481 method_30937() {
            class_2477 language = class_2477.method_10517();
            if (this.decomposedWith != language) {
                this.visualOrderText = language.method_30934((class_5348)this);
                this.decomposedWith = language;
            }
            return this.visualOrderText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownloadTextComponent that = (DownloadTextComponent)o;
            return this.contents.equals((Object)that.contents);
        }

        public int hashCode() {
            return this.contents.hashCode();
        }

        public String toString() {
            return this.contents.toString();
        }

        public void setText(String text) {
            this.contents = new class_2585(text);
            this.decomposedWith = null;
        }
    }
}

