/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.SoundStreamModifier;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.sound.stream.MonoWrapper;
import gg.moonflower.etched.api.sound.stream.RawAudioStream;
import gg.moonflower.etched.api.util.AAC.AACInputStream;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.api.util.Mp3InputStream;
import gg.moonflower.etched.api.util.WaveDataReader;
import gg.moonflower.etched.client.sound.EmptyAudioStream;
import gg.moonflower.etched.client.sound.SoundCache;
import gg.moonflower.etched.core.fabric.EtchedConfig;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.class_1102;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_1148;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4228;
import net.minecraft.class_4234;
import net.minecraft.class_4237;
import net.minecraft.class_4856;
import net.minecraft.class_5862;
import net.minecraft.class_7373;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AbstractOnlineSoundInstance
extends class_1102 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String url;
    private final String subtitle;
    private final int attenuationDistance;
    private final DownloadProgressListener progressListener;
    private final AudioSource.AudioFileType type;
    private final boolean stereo;

    public AbstractOnlineSoundInstance(String url, @Nullable String subtitle, int attenuationDistance, class_3419 source, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
        super(new class_2960("etched", DigestUtils.sha1Hex((String)url)), source, class_1113.method_43221());
        this.url = url;
        this.subtitle = subtitle;
        this.attenuationDistance = attenuationDistance;
        this.progressListener = progressListener;
        this.type = type;
        this.stereo = ((EtchedConfig)EtchedConfig.HANDLER.instance()).forceStereo || stereo;
    }

    private static class_4234 getStream(class_4234 stream, class_1111 sound) {
        return sound instanceof SoundStreamModifier ? ((SoundStreamModifier)sound).modifyStream(stream) : new MonoWrapper(stream);
    }

    public class_1146 method_4783(class_1144 soundManager) {
        class_1146 weighedSoundEvents = new class_1146(this.method_4775(), this.subtitle);
        weighedSoundEvents.method_4885((class_1148)new OnlineSound(this.method_4775(), this.url, this.attenuationDistance, this.progressListener, this.type, this.stereo));
        this.field_5444 = weighedSoundEvents.method_4887(this.field_38800);
        return weighedSoundEvents;
    }

    public AbstractOnlineSoundInstance setLoop(boolean loop) {
        this.field_5446 = loop;
        return this;
    }

    public CompletableFuture<class_4234> getAudioStream(class_4237 loader, class_2960 id, boolean repeatInstantly) {
        class_1111 sound = this.method_4776();
        if (!(sound instanceof OnlineSound)) {
            return super.getAudioStream(loader, id, repeatInstantly);
        }
        OnlineSound onlineSound = (OnlineSound)sound;
        if (TrackData.isLocalSound(onlineSound.getURL())) {
            class_1146 weighedSoundEvents = class_310.method_1551().method_1483().method_4869(new class_2960(onlineSound.getURL()));
            if (weighedSoundEvents == null) {
                CompletableFuture<class_4234> future = new CompletableFuture<class_4234>();
                future.completeExceptionally(new FileNotFoundException("Unable to play unknown soundEvent: " + String.valueOf(sound.method_4766())));
                return future;
            }
            return ((CompletableFuture)loader.method_19744(weighedSoundEvents.method_4887(this.field_38800).method_4766(), repeatInstantly).thenApply(MonoWrapper::new)).handleAsync((stream, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Failed to load audio from client: {}", (Object)onlineSound.getURL(), throwable);
                    onlineSound.getProgressListener().onFail();
                    return EmptyAudioStream.INSTANCE;
                }
                onlineSound.getProgressListener().onSuccess();
                return stream;
            }, (Executor)class_156.method_18349());
        }
        return ((CompletableFuture)((CompletableFuture)SoundCache.getAudioStream(onlineSound.getURL(), onlineSound.getProgressListener(), onlineSound.getAudioFileType()).thenCompose(AudioSource::openStream)).thenApplyAsync(stream -> {
            onlineSound.getProgressListener().progressStartLoading();
            try {
                int bytesRead;
                BufferedInputStream is = new BufferedInputStream((InputStream)stream);
                int headerSize = 32768;
                ByteArrayOutputStream headerBuffer = new ByteArrayOutputStream(32768);
                byte[] temp = new byte[4096];
                for (int totalRead = 0; totalRead < 32768 && (bytesRead = ((InputStream)is).read(temp)) != -1; totalRead += bytesRead) {
                    headerBuffer.write(temp, 0, bytesRead);
                }
                byte[] headerBytes = headerBuffer.toByteArray();
                Supplier<InputStream> createCombinedStream = () -> {
                    ByteArrayInputStream headerStream = new ByteArrayInputStream(headerBytes);
                    return new SequenceInputStream(headerStream, is);
                };
                try {
                    InputStream combinedStream = createCombinedStream.get();
                    return AbstractOnlineSoundInstance.getStream((class_4234)(repeatInstantly ? new class_4856(class_4228::new, combinedStream) : new class_4228(combinedStream)), sound);
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to load as OGG", (Throwable)e);
                    try {
                        InputStream combinedStream = createCombinedStream.get();
                        AudioInputStream ais = WaveDataReader.getAudioInputStream(combinedStream);
                        AudioFormat format = ais.getFormat();
                        return AbstractOnlineSoundInstance.getStream((class_4234)(repeatInstantly ? new class_4856(input -> new RawAudioStream(format, input), (InputStream)ais) : new RawAudioStream(format, ais)), sound);
                    }
                    catch (Exception e1) {
                        LOGGER.debug("Failed to load as WAV", (Throwable)e1);
                        try {
                            InputStream combinedStream = createCombinedStream.get();
                            Mp3InputStream mp3InputStream = new Mp3InputStream(combinedStream);
                            return AbstractOnlineSoundInstance.getStream((class_4234)(repeatInstantly ? new class_4856(input -> new RawAudioStream(mp3InputStream.getFormat(), input), (InputStream)mp3InputStream) : new RawAudioStream(mp3InputStream.getFormat(), mp3InputStream)), sound);
                        }
                        catch (Exception e2) {
                            LOGGER.debug("Failed to load as MP3", (Throwable)e2);
                            try {
                                InputStream combinedStream = createCombinedStream.get();
                                AACInputStream aacInputStream = new AACInputStream(combinedStream);
                                AudioFormat format = aacInputStream.getFormat();
                                return AbstractOnlineSoundInstance.getStream((class_4234)(repeatInstantly ? new class_4856(input -> new RawAudioStream(format, input), (InputStream)aacInputStream) : new RawAudioStream(format, aacInputStream)), sound);
                            }
                            catch (Exception e3) {
                                LOGGER.debug("Failed to load as AAC", (Throwable)e3);
                                UnsupportedAudioFileException cause = new UnsupportedAudioFileException("Could not load as OGG, WAV, MP3, or AAC");
                                cause.addSuppressed(e);
                                cause.addSuppressed(e1);
                                cause.addSuppressed(e2);
                                cause.addSuppressed(e3);
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (Exception e4) {
                                    cause.addSuppressed(e4);
                                }
                                throw new CompletionException(cause);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)class_156.method_18349())).handleAsync((stream, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    CompletionException e = (CompletionException)throwable;
                    throwable = e.getCause();
                }
                LOGGER.error("Failed to load audio from url: {}", (Object)onlineSound.getURL(), throwable);
                onlineSound.getProgressListener().onFail();
                return EmptyAudioStream.INSTANCE;
            }
            onlineSound.getProgressListener().onSuccess();
            return stream;
        }, (Executor)class_156.method_18349());
    }

    public static class OnlineSound
    extends class_1111
    implements SoundStreamModifier {
        private final String url;
        private final DownloadProgressListener progressListener;
        private final AudioSource.AudioFileType type;
        private final boolean stereo;

        public OnlineSound(class_2960 location, String url, int attenuationDistance, DownloadProgressListener progressListener, AudioSource.AudioFileType type, boolean stereo) {
            super(location.toString(), (class_7373)class_5862.method_33908((float)1.0f), (class_7373)class_5862.method_33908((float)1.0f), 1, class_1111.class_1112.field_5474, true, false, attenuationDistance);
            this.url = url;
            this.progressListener = progressListener;
            this.type = type;
            this.stereo = stereo;
        }

        public String getURL() {
            return this.url;
        }

        public DownloadProgressListener getProgressListener() {
            return this.progressListener;
        }

        public AudioSource.AudioFileType getAudioFileType() {
            return this.type;
        }

        @Override
        public class_4234 modifyStream(class_4234 stream) {
            return this.stereo ? stream : new MonoWrapper(stream);
        }
    }
}

