/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.multiblock.controller;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.IInteractionChecker;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.List;
import lib.multiblock.test.SimpleMultiBlockAislePatternBuilder;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.nuclearteam.createnuclear.block.CNBlocks;
import net.nuclearteam.createnuclear.config.CNConfigs;
import net.nuclearteam.createnuclear.gui.CNIconButton;
import net.nuclearteam.createnuclear.item.CNItems;
import net.nuclearteam.createnuclear.multiblock.IHeat;
import net.nuclearteam.createnuclear.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.multiblock.controller.ReactorControllerInventory;
import net.nuclearteam.createnuclear.multiblock.input.ReactorInputEntity;
import net.nuclearteam.createnuclear.multiblock.output.ReactorOutput;
import net.nuclearteam.createnuclear.multiblock.output.ReactorOutputEntity;
import org.jetbrains.annotations.Nullable;

public class ReactorControllerBlockEntity
extends SmartBlockEntity
implements IInteractionChecker,
SidedStorageBlockEntity,
IHaveGoggleInformation {
    public boolean destroyed = false;
    public boolean created = false;
    public boolean test = true;
    public boolean sendUpdate;
    public ReactorControllerBlock controller;
    public ReactorControllerInventory inventory;
    public State powered = State.OFF;
    public float reactorPower;
    public float lastReactorPower;
    public int countUraniumRod;
    public int countGraphiteRod;
    int overFlowHeatTimer = 0;
    int overFlowLimiter = 30;
    double overHeat = 0.0;
    public int baseUraniumHeat;
    public int baseGraphiteHeat;
    public int proximityUraniumHeat;
    public int proximityGraphiteHeat;
    public int maxUraniumPerGraphite;
    public int graphiteTimer;
    public int uraniumTimer;
    public int heat;
    public double total;
    public class_2487 screen_pattern;
    private List<CNIconButton> switchButtons;
    public class_1799 configuredPattern;
    private class_1799 fuelItem;
    private class_1799 coolerItem;
    private final int[][] formattedPattern;
    private final int[][] offsets;

    public ReactorControllerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.baseUraniumHeat = (Integer)CNConfigs.common().rods.baseValueUranium.get();
        this.baseGraphiteHeat = (Integer)CNConfigs.common().rods.baseValueGraphite.get();
        this.proximityUraniumHeat = (Integer)CNConfigs.common().rods.BoProxyUranium.get();
        this.proximityGraphiteHeat = (Integer)CNConfigs.common().rods.MaProxigraphite.get();
        this.maxUraniumPerGraphite = (Integer)CNConfigs.common().rods.uraMaxGraph.get();
        this.graphiteTimer = (Integer)CNConfigs.common().rods.graphiteRodLifetime.get();
        this.uraniumTimer = (Integer)CNConfigs.common().rods.uraniumRodLifetime.get();
        this.screen_pattern = new class_2487();
        this.formattedPattern = new int[][]{{99, 99, 99, 0, 1, 2, 99, 99, 99}, {99, 99, 3, 4, 5, 6, 7, 99, 99}, {99, 8, 9, 10, 11, 12, 13, 14, 99}, {15, 16, 17, 18, 19, 20, 21, 22, 23}, {24, 25, 26, 27, 28, 29, 30, 31, 32}, {33, 34, 35, 36, 37, 38, 39, 40, 41}, {99, 42, 43, 44, 45, 46, 47, 48, 99}, {99, 99, 49, 50, 51, 52, 53, 99, 99}, {99, 99, 99, 54, 55, 56, 99, 99, 99}};
        this.offsets = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}};
        this.inventory = new ReactorControllerInventory(this);
        this.configuredPattern = class_1799.field_8037;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean getAssembled() {
        class_2680 state = this.method_11010();
        return (Boolean)state.method_11654((class_2769)ReactorControllerBlock.ASSEMBLED);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!this.configuredPattern.method_7948().method_33133()) {
            tooltip.add((class_2561)componentSpacing.method_27662().method_10852((class_2561)Lang.translateDirect((String)"gui.gauge.info_header", (Object[])new Object[0])));
            IHeat.HeatLevel.getName("reactor_controller").style(class_124.field_1080).forGoggles(tooltip);
            IHeat.HeatLevel.getFormattedHeatText(this.configuredPattern.method_7948().method_10550("heat")).forGoggles(tooltip);
            if (this.fuelItem.method_7960()) {
                IHeat.HeatLevel.getFormattedItemText(new class_1799((class_1935)CNItems.URANIUM_ROD.method_8389(), 1), true).forGoggles(tooltip);
            } else {
                IHeat.HeatLevel.getFormattedItemText(this.fuelItem, false).forGoggles(tooltip);
            }
            if (this.fuelItem.method_7960()) {
                IHeat.HeatLevel.getFormattedItemText(new class_1799((class_1935)CNItems.GRAPHITE_ROD.method_8389(), 1), true).forGoggles(tooltip);
            } else {
                IHeat.HeatLevel.getFormattedItemText(this.coolerItem, false).forGoggles(tooltip);
            }
        }
        return true;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.method_10562("pattern"));
        }
        this.configuredPattern = class_1799.method_7915((class_2487)compound.method_10562("items"));
        if (class_1799.method_7915((class_2487)compound.method_10562("cooler")) != null || class_1799.method_7915((class_2487)compound.method_10562("fuel")) != null) {
            this.coolerItem = class_1799.method_7915((class_2487)compound.method_10562("cooler"));
            this.fuelItem = class_1799.method_7915((class_2487)compound.method_10562("fuel"));
        }
        this.total = compound.method_10574("total");
        super.read(compound, clientPacket);
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        if (!clientPacket) {
            compound.method_10566("pattern", (class_2520)this.inventory.serializeNBT());
        }
        compound.method_10566("items", this.configuredPattern.serializeNBT());
        if (this.coolerItem != null || this.fuelItem != null) {
            compound.method_10566("cooler", this.coolerItem.serializeNBT());
            compound.method_10566("fuel", this.fuelItem.serializeNBT());
        }
        compound.method_10549("total", this.calculateProgress());
        super.write(compound, clientPacket);
    }

    private void explodeReactorCore(class_1937 level, class_2338 pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 currentPos = pos.method_10069(x, y, z);
                    if (!level.method_8320(currentPos).method_27852((class_2248)CNBlocks.REACTOR_CORE.get())) continue;
                    class_1927 explosion = new class_1927(level, null, (double)currentPos.method_10263(), (double)currentPos.method_10264(), (double)currentPos.method_10260(), 4.0f, false, class_1927.class_4179.field_18687);
                    explosion.method_8348();
                    explosion.method_8350(true);
                }
            }
        }
    }

    public void tick() {
        StorageProvider storage;
        class_2586 class_25862;
        super.tick();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.isEmptyConfiguredPattern() && (class_25862 = (storage = StorageProvider.createForItems((class_1937)this.field_11863, (class_2338)this.getBlockPosForReactor('I'))).findBlockEntity()) instanceof ReactorInputEntity) {
            ReactorInputEntity be = (ReactorInputEntity)class_25862;
            class_2487 tag = (class_2487)be.serializeNBT();
            class_2499 inventoryTag = tag.method_10562("Inventory").method_10554("Items", 10);
            this.fuelItem = class_1799.method_7915((class_2487)inventoryTag.method_10602(0));
            this.coolerItem = class_1799.method_7915((class_2487)inventoryTag.method_10602(1));
            if (this.fuelItem.method_7947() > 0 && this.coolerItem.method_7947() > 0) {
                this.configuredPattern.method_7948().method_10549("heat", this.calculateHeat(tag));
                if (this.updateTimers()) {
                    TransferUtil.extract((Storage)be.inventory, (Object)ItemVariant.of((class_1799)this.fuelItem), (long)1L);
                    TransferUtil.extract((Storage)be.inventory, (Object)ItemVariant.of((class_1799)this.coolerItem), (long)1L);
                    this.total = this.calculateProgress();
                    int heat = (int)this.configuredPattern.method_7948().method_10574("heat");
                    if (IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.SAFETY || IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.CAUTION || IHeat.HeatLevel.of(heat) == IHeat.HeatLevel.WARNING) {
                        this.rotate(this.method_11010(), new class_2338(this.method_11016().method_10263(), this.method_11016().method_10264() + ReactorControllerBlockEntity.FindController('O').method_10264(), this.method_11016().method_10260()), this.method_10997(), heat / 4);
                    } else {
                        this.rotate(this.method_11010(), new class_2338(this.method_11016().method_10263(), this.method_11016().method_10264() + ReactorControllerBlockEntity.FindController('O').method_10264(), this.method_11016().method_10260()), this.method_10997(), 0);
                    }
                    return;
                }
            } else {
                this.rotate(this.method_11010(), new class_2338(this.method_11016().method_10263(), this.method_11016().method_10264() + ReactorControllerBlockEntity.FindController('O').method_10264(), this.method_11016().method_10260()), this.method_10997(), 0);
            }
            this.notifyUpdate();
        }
    }

    private boolean isEmptyConfiguredPattern() {
        return !this.configuredPattern.method_7960() || !this.configuredPattern.method_7948().method_33133();
    }

    private boolean updateTimers() {
        this.total -= 1.0;
        return this.total <= 0.0;
    }

    private double calculateProgress() {
        this.countGraphiteRod = this.configuredPattern.method_7948().method_10550("countGraphiteRod");
        this.countUraniumRod = this.configuredPattern.method_7948().method_10550("countUraniumRod");
        double totalGraphiteRodLife = (double)this.graphiteTimer / (double)this.countGraphiteRod;
        double totalUraniumRodLife = (double)this.uraniumTimer / (double)this.countUraniumRod;
        return totalGraphiteRodLife + totalUraniumRodLife;
    }

    private double calculateHeat(class_2487 tag) {
        this.countGraphiteRod = this.configuredPattern.method_7948().method_10550("countGraphiteRod");
        this.countUraniumRod = this.configuredPattern.method_7948().method_10550("countUraniumRod");
        this.heat = 0;
        if (this.countUraniumRod > this.countGraphiteRod * this.maxUraniumPerGraphite) {
            ++this.overFlowHeatTimer;
            if (this.overFlowHeatTimer >= this.overFlowLimiter) {
                this.overHeat += 1.0;
                this.overFlowHeatTimer = 0;
                if (this.overFlowLimiter > 1) {
                    --this.overFlowLimiter;
                }
            }
        } else {
            this.overFlowHeatTimer = 0;
            this.overFlowLimiter = 30;
            this.overHeat = this.overHeat > 0.0 ? (this.overHeat -= 2.0) : 0.0;
        }
        String currentRod = "";
        class_2499 list = this.inventory.getStackInSlot(0).method_7948().method_10562("pattern").method_10554("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            if (list.method_10602(i).method_10558("id").equals("createnuclear:uranium_rod")) {
                this.heat += this.baseUraniumHeat;
                currentRod = "u";
            } else if (list.method_10602(i).method_10558("id").equals("createnuclear:graphite_rod")) {
                this.heat += this.baseGraphiteHeat;
                currentRod = "g";
            }
            for (int j = 0; j < this.formattedPattern.length; ++j) {
                for (int k = 0; k < this.formattedPattern[j].length; ++k) {
                    if (this.formattedPattern[j][k] == 99 || list.method_10602(i).method_10550("Slot") != this.formattedPattern[j][k]) continue;
                    for (int[] offset : this.offsets) {
                        int nj = j + offset[0];
                        int nk = k + offset[1];
                        if (nj < 0 || nj >= this.formattedPattern.length || nk < 0 || nk >= this.formattedPattern[j].length) continue;
                        int neighborSlot = this.formattedPattern[nj][nk];
                        for (int l = 0; l < list.size(); ++l) {
                            if (list.method_10602(l).method_10550("Slot") != neighborSlot || !currentRod.equals("u")) continue;
                            String id = list.method_10602(l).method_10558("id");
                            if (id.equals("createnuclear:uranium_rod")) {
                                this.heat += this.proximityUraniumHeat;
                                continue;
                            }
                            if (!id.equals("createnuclear:graphite_rod")) continue;
                            this.heat += this.proximityGraphiteHeat;
                        }
                    }
                }
            }
        }
        return (double)this.heat + this.overHeat;
    }

    private class_2338 getBlockPosForReactor(char character) {
        int[][] directions;
        class_2338 pos = ReactorControllerBlockEntity.FindController(character);
        class_2338 posController = this.method_11016();
        class_2338 posInput = new class_2338(posController.method_10263(), posController.method_10264(), posController.method_10260());
        for (int[] direction : directions = new int[][]{{0, 0, pos.method_10263()}, {0, 0, -pos.method_10263()}, {-pos.method_10263(), 0, 0}, {pos.method_10263(), 0, 0}}) {
            class_2338 newPos = posController.method_10069(direction[0], direction[1], direction[2]);
            if (!this.field_11863.method_8320(newPos).method_27852((class_2248)CNBlocks.REACTOR_INPUT.get())) continue;
            posInput = newPos;
            break;
        }
        return posInput;
    }

    private class_2487 convertePattern(class_2487 compoundTag) {
        class_2499 pattern = compoundTag.method_10554("Items", 10);
        return null;
    }

    private static class_2338 FindController(char character) {
        return SimpleMultiBlockAislePatternBuilder.start().aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAAAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAIAA", "ADADA", "BACAB", "ADADA", "AA*AA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AABAA", "ADADA", "BACAB", "ADADA", "AABAA").aisle("AAAAA", "AAAAA", "AAAAA", "AAAAA", "AAOAA").where('A', a -> a.method_11681().method_27852((class_2248)CNBlocks.REACTOR_CASING.get())).where('B', a -> a.method_11681().method_27852((class_2248)CNBlocks.REACTOR_FRAME.get())).where('C', a -> a.method_11681().method_27852((class_2248)CNBlocks.REACTOR_CORE.get())).where('D', a -> a.method_11681().method_27852((class_2248)CNBlocks.REACTOR_COOLER.get())).where('*', a -> a.method_11681().method_27852((class_2248)CNBlocks.REACTOR_CONTROLLER.get())).where('O', a -> a.method_11681().method_27852((class_2248)CNBlocks.REACTOR_OUTPUT.get())).where('I', a -> a.method_11681().method_27852((class_2248)CNBlocks.REACTOR_INPUT.get())).getDistanceController(character);
    }

    public void rotate(class_2680 state, class_2338 pos, class_1937 level, int rotation) {
        if (level.method_8320(pos).method_27852((class_2248)CNBlocks.REACTOR_OUTPUT.get()) && rotation > 0) {
            class_2248 class_22482 = level.method_8320(pos).method_26204();
            if (class_22482 instanceof ReactorOutput) {
                ReactorOutput block = (ReactorOutput)class_22482;
                ReactorOutputEntity entity = (ReactorOutputEntity)block.getBlockEntityType().method_24182((class_1922)level, pos);
                if (((Boolean)state.method_11654((class_2769)ReactorControllerBlock.ASSEMBLED)).booleanValue()) {
                    entity.speed = rotation;
                    entity.heat = rotation;
                    entity.updateSpeed = true;
                    entity.updateGeneratedRotation();
                } else {
                    entity.speed = 0;
                    entity.heat = 0.0f;
                    entity.updateSpeed = true;
                    entity.updateGeneratedRotation();
                }
                entity.setSpeed(rotation);
            }
        } else {
            Object entity = level.method_8320(pos).method_26204();
            if (entity instanceof ReactorOutput) {
                ReactorOutput block = (ReactorOutput)((Object)entity);
                entity = (ReactorOutputEntity)block.getBlockEntityType().method_24182((class_1922)level, pos);
                ((ReactorOutputEntity)((Object)entity)).setSpeed(0);
                ((ReactorOutputEntity)((Object)entity)).heat = 0.0f;
                ((ReactorOutputEntity)((Object)entity)).updateSpeed = true;
                entity.updateGeneratedRotation();
            }
        }
    }

    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.inventory;
    }

    public class_1269 onClick(class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_31574((class_1792)CNItems.REACTOR_BLUEPRINT.get()) && !heldItem.method_7960()) {
            if (this.configuredPattern.method_7960()) {
                this.inventory.setStackInSlot(0, heldItem);
                this.configuredPattern = heldItem;
            }
            this.notifyUpdate();
            return class_1269.field_5812;
        }
        if (heldItem.method_7960() && this.configuredPattern.method_7960()) {
            if (!this.field_11863.field_9236) {
                if (player.method_7270(this.configuredPattern)) {
                    this.configuredPattern = class_1799.field_8037;
                    this.notifyUpdate();
                    return class_1269.field_21466;
                }
                player.method_6122(hand, this.configuredPattern);
                this.inventory.setStackInSlot(0, class_1799.field_8037);
                this.notifyUpdate();
                return class_1269.field_21466;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static enum State {
        ON,
        OFF;

    }
}

