/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.multiblock;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.nuclearteam.createnuclear.config.CNConfigs;
import net.nuclearteam.createnuclear.multiblock.HeatLevelMapper;
import net.nuclearteam.createnuclear.multiblock.HeatThresholds;
import net.nuclearteam.createnuclear.tags.CNTag;

public interface IHeat
extends IWrenchable {

    public static enum HeatLevel {
        NONE(class_124.field_1063, 0),
        SAFETY(class_124.field_1060, 6867971),
        CAUTION(class_124.field_1054, 13224963),
        WARNING(class_124.field_1065, 16738816),
        DANGER(class_124.field_1061, 16738816);

        private final class_124 color;
        private final Integer intColor;
        private final int colorCode;

        private HeatLevel(class_124 textColor, int colorCode) {
            this.color = textColor;
            this.intColor = null;
            this.colorCode = colorCode;
        }

        private HeatLevel(int intColor, int colorCode) {
            this.color = null;
            this.intColor = intColor;
            this.colorCode = colorCode;
        }

        public class_124 getTextColor() {
            return this.color;
        }

        public int getColorCode() {
            return this.colorCode;
        }

        public int getHeatValue() {
            return switch (this.ordinal()) {
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                default -> 0;
            };
        }

        public static HeatLevel of(int heat) {
            return HeatLevel.ofInit(heat);
        }

        public static HeatLevel ofInit(int heat) {
            if (heat < 0) {
                return NONE;
            }
            if ((heat = Math.abs(heat)) > 0 && heat < 500) {
                return SAFETY;
            }
            if (heat >= 501 && heat <= 800) {
                return CAUTION;
            }
            if (heat >= 801 && heat <= 1000) {
                return WARNING;
            }
            if (heat >= 1001) {
                return DANGER;
            }
            return NONE;
        }

        public static HeatLevel ofTest1(int heat) {
            HeatThresholds thresholds;
            if (heat < 0) {
                return NONE;
            }
            int h = Math.min(heat = Math.abs(heat), (thresholds = HeatThresholds.of((Integer)CNConfigs.common().rods.maxHeat.get())).maxHeat());
            return h < thresholds.safety() ? SAFETY : (h < thresholds.caution() ? CAUTION : (h < thresholds.maxHeat() ? WARNING : DANGER));
        }

        public static HeatLevel ofTest2(int heat) {
            HeatThresholds thresholds;
            if (heat < 0) {
                return NONE;
            }
            if ((heat = Math.abs(heat)) < (thresholds = HeatThresholds.of((Integer)CNConfigs.common().rods.maxHeat.get())).safety()) {
                return SAFETY;
            }
            if (heat < thresholds.caution()) {
                return CAUTION;
            }
            if (heat < thresholds.maxHeat()) {
                return WARNING;
            }
            return DANGER;
        }

        public static HeatLevel ofTest3(int heat) {
            if (heat < 0) {
                return NONE;
            }
            heat = Math.abs(heat);
            int maxHeat = (Integer)CNConfigs.common().rods.maxHeat.get();
            int safetyThreshold = (int)(0.5 * (double)maxHeat);
            int cautionThreshold = (int)(0.8 * (double)maxHeat);
            HeatLevelMapper mapper = HeatLevelMapper.newBuilder().level(SAFETY).ifHeatBelow(safetyThreshold).level(CAUTION).ifHeatBetween(safetyThreshold, cautionThreshold).level(WARNING).ifHeatBetween(cautionThreshold + 1, maxHeat).otherwise(DANGER).build();
            return mapper.map(heat);
        }

        public static LangBuilder getFormattedHeatText(int heat) {
            HeatLevel heatLevel = HeatLevel.of(heat);
            LangBuilder builder = Lang.builder((String)"createnuclear").text(TooltipHelper.makeProgressBar((int)5, (int)(heatLevel.ordinal() + 1)));
            builder.translate("tooltip.heatLevel." + Lang.asId((String)heatLevel.name()), new Object[0]).space().text("(").add(Lang.number((double)heat)).space().translate("generic.unit.heat", new Object[0]).text(")").space();
            if (heatLevel == DANGER) {
                builder.style(DANGER.getTextColor()).style(class_124.field_1055);
            } else {
                builder.style(heatLevel.getTextColor());
            }
            return builder;
        }

        public static LangBuilder getFormattedItemText(class_1799 itemRod, Boolean IsEmpty) {
            LangBuilder builder = Lang.builder((String)"createnuclear");
            String tooltip = "unknown";
            if (itemRod.method_31573(CNTag.ItemTags.FUEL.tag)) {
                tooltip = "uranium";
            }
            if (itemRod.method_31573(CNTag.ItemTags.COOLER.tag)) {
                tooltip = "graphene";
            }
            builder.translate("tooltip.item." + tooltip + ".rod", new Object[0]).add(Lang.number((double)Math.abs(IsEmpty != false ? itemRod.method_7947() - 1 : itemRod.method_7947()))).style(class_124.field_1078);
            return builder;
        }

        public static LangBuilder getName(String name) {
            LangBuilder builder = Lang.builder((String)"createnuclear");
            builder.translate("gui." + name + ".info_header.title", new Object[0]);
            return builder;
        }
    }
}

