/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.multiblock;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import net.nuclearteam.createnuclear.multiblock.IHeat;

public class HeatLevelMapper {
    private final List<LevelRule> rules = new ArrayList<LevelRule>();
    private IHeat.HeatLevel defaultLevel = IHeat.HeatLevel.NONE;

    public static Builder newBuilder() {
        return new Builder();
    }

    public IHeat.HeatLevel map(int heat) {
        for (LevelRule rule : this.rules) {
            if (!rule.predicate().test(heat)) continue;
            return rule.level();
        }
        return this.defaultLevel;
    }

    public static class Builder {
        private final HeatLevelMapper mapper = new HeatLevelMapper();

        public ConditionBuilder level(IHeat.HeatLevel level) {
            return new ConditionBuilder(this, level);
        }

        public Builder otherwise(IHeat.HeatLevel level) {
            this.mapper.defaultLevel = level;
            return this;
        }

        public HeatLevelMapper build() {
            return this.mapper;
        }

        public static class ConditionBuilder {
            private final Builder parent;
            private final IHeat.HeatLevel level;

            public ConditionBuilder(Builder parent, IHeat.HeatLevel level) {
                this.parent = parent;
                this.level = level;
            }

            public Builder ifHeatBelow(int threshold) {
                this.parent.mapper.rules.add(new LevelRule(this.level, h -> h < threshold));
                return this.parent;
            }

            public Builder ifHeatAbove(int threshold) {
                this.parent.mapper.rules.add(new LevelRule(this.level, h -> h > threshold));
                return this.parent;
            }

            public Builder ifHeatBetween(int min, int max) {
                this.parent.mapper.rules.add(new LevelRule(this.level, h -> h >= min && h <= max));
                return this.parent;
            }
        }
    }

    private record LevelRule(IHeat.HeatLevel level, IntPredicate predicate) {
    }
}

