/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.item.cloth;

import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_6328;
import net.nuclearteam.createnuclear.item.CNItems;
import org.jetbrains.annotations.NotNull;

@class_6328
@ParametersAreNonnullByDefault
public class ClothItem
extends class_1792 {
    private final class_1767 color;

    public ClothItem(class_1792.class_1793 properties, class_1767 color) {
        super(properties);
        this.color = color;
    }

    public static enum Cloths {
        WHITE_CLOTH(class_1767.field_7952),
        YELLOW_CLOTH(class_1767.field_7947),
        RED_CLOTH(class_1767.field_7964),
        BLUE_CLOTH(class_1767.field_7966),
        GREEN_CLOTH(class_1767.field_7942),
        BLACK_CLOTH(class_1767.field_7963),
        ORANGE_CLOTH(class_1767.field_7946),
        PURPLE_CLOTH(class_1767.field_7945),
        BROWN_CLOTH(class_1767.field_7957),
        PINK_CLOTH(class_1767.field_7954),
        CYAN_CLOTH(class_1767.field_7955),
        LIGHT_GRAY_CLOTH(class_1767.field_7967),
        GRAY_CLOTH(class_1767.field_7944),
        LIGHT_BLUE_CLOTH(class_1767.field_7951),
        LIME_CLOTH(class_1767.field_7961),
        MAGENTA_CLOTH(class_1767.field_7958);

        private static final Map<class_1767, ItemEntry<ClothItem>> clothMap;
        private final class_1767 color;

        private Cloths(class_1767 color) {
            this.color = color;
        }

        public ItemEntry<ClothItem> getItem() {
            return clothMap.get(this.color);
        }

        public static ItemEntry<ClothItem> getByColor(class_1767 color) {
            return clothMap.get(color);
        }

        static {
            clothMap = new EnumMap<class_1767, ItemEntry<ClothItem>>(class_1767.class);
            for (class_1767 color : class_1767.values()) {
                clothMap.put(color, CNItems.CLOTHS.get(color));
            }
        }
    }

    public static class DyeItemList<T extends class_1792>
    implements Iterable<ItemEntry<T>> {
        private static final int COLOR_AMOUNT = class_1767.values().length;
        private final ItemEntry<?>[] entry = new ItemEntry[COLOR_AMOUNT];

        public DyeItemList(Function<class_1767, ItemEntry<? extends T>> filler) {
            for (class_1767 color : class_1767.values()) {
                this.entry[color.ordinal()] = filler.apply(color);
            }
        }

        public ItemEntry<T> get(class_1767 color) {
            return this.entry[color.ordinal()];
        }

        public boolean contains(class_1792 block) {
            for (ItemEntry<?> entry : this.entry) {
                if (!entry.is(block)) continue;
                return true;
            }
            return false;
        }

        public ItemEntry<T>[] toArray() {
            return Arrays.copyOf(this.entry, this.entry.length);
        }

        @Override
        public Iterator<ItemEntry<T>> iterator() {
            return new Iterator<ItemEntry<T>>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < entry.length;
                }

                @Override
                public ItemEntry<T> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return entry[this.index++];
                }
            };
        }
    }

    public static class DyeRecipeList
    implements Iterable<CreateRecipeProvider.GeneratedRecipe> {
        private static final int COLOR_AMOUNT = class_1767.values().length;
        protected final CreateRecipeProvider.GeneratedRecipe[] recipes = new CreateRecipeProvider.GeneratedRecipe[this.getColorCount()];

        public DyeRecipeList(Function<class_1767, CreateRecipeProvider.GeneratedRecipe> filler) {
            for (class_1767 color : class_1767.values()) {
                this.recipes[color.ordinal()] = filler.apply(color);
            }
        }

        protected int getColorCount() {
            return COLOR_AMOUNT;
        }

        public CreateRecipeProvider.GeneratedRecipe get(class_1767 color) {
            return this.recipes[color.ordinal()];
        }

        public CreateRecipeProvider.GeneratedRecipe[] toArrays() {
            return Arrays.copyOf(this.recipes, this.recipes.length);
        }

        @Override
        @NotNull
        public Iterator<CreateRecipeProvider.GeneratedRecipe> iterator() {
            return new Iterator<CreateRecipeProvider.GeneratedRecipe>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < recipes.length;
                }

                @Override
                public CreateRecipeProvider.GeneratedRecipe next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return recipes[this.index++];
                }
            };
        }

        public static class NullableDyedRecipeList
        extends DyeRecipeList {
            public NullableDyedRecipeList(Function<class_1767, CreateRecipeProvider.GeneratedRecipe> fillter) {
                super(fillter);
                this.recipes[this.recipes.length - 1] = fillter.apply(null);
            }

            @Override
            protected int getColorCount() {
                return COLOR_AMOUNT + 1;
            }

            @Override
            public CreateRecipeProvider.GeneratedRecipe get(class_1767 color) {
                return color == null ? this.recipes[this.recipes.length - 1] : super.get(color);
            }
        }
    }
}

