/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.item.armor;

import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import io.github.fabricators_of_create.porting_lib.item.ArmorTextureItem;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6328;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.item.CNItems;
import net.nuclearteam.createnuclear.item.armor.CNArmorMaterials;
import org.jetbrains.annotations.NotNull;

@class_6328
@ParametersAreNonnullByDefault
public class AntiRadiationArmorItem {
    public static final class_1738.class_8051 HELMET = class_1738.class_8051.field_41934;
    public static final class_1738.class_8051 CHESTPLATE = class_1738.class_8051.field_41935;
    public static final class_1738.class_8051 LEGGINGS = class_1738.class_8051.field_41936;
    public static final class_1738.class_8051 BOOTS = class_1738.class_8051.field_41937;
    public static final class_1741 ARMOR_MATERIAL = CNArmorMaterials.ANTI_RADIATION_SUIT;

    public static enum Armor {
        WHITE_ARMOR(class_1767.field_7952),
        YELLOW_ARMOR(class_1767.field_7947),
        RED_ARMOR(class_1767.field_7964),
        BLUE_ARMOR(class_1767.field_7966),
        GREEN_ARMOR(class_1767.field_7942),
        BLACK_ARMOR(class_1767.field_7963),
        ORANGE_ARMOR(class_1767.field_7946),
        PURPLE_ARMOR(class_1767.field_7945),
        BROWN_ARMOR(class_1767.field_7957),
        PINK_ARMOR(class_1767.field_7954),
        CYAN_ARMOR(class_1767.field_7955),
        LIGHT_GRAY_ARMOR(class_1767.field_7967),
        GRAY_ARMOR(class_1767.field_7944),
        LIGHT_BLUE_ARMOR(class_1767.field_7951),
        LIME_ARMOR(class_1767.field_7961),
        MAGENTA_ARMOR(class_1767.field_7958);

        private static final Map<class_1767, ItemEntry<Helmet>> helmetMap;
        private static final Map<class_1767, ItemEntry<Chestplate>> chestplateMap;
        private static final Map<class_1767, ItemEntry<Leggings>> leggingsMap;
        private final class_1767 color;

        private Armor(class_1767 dyeColor) {
            this.color = dyeColor;
        }

        public ItemEntry<Helmet> getHelmetItem() {
            return helmetMap.get(this.color);
        }

        public static ItemEntry<Helmet> getHelmetByColor(class_1767 color) {
            return helmetMap.get(color);
        }

        public ItemEntry<Chestplate> getChestplateItem() {
            return chestplateMap.get(this.color);
        }

        public static ItemEntry<Chestplate> getChestplateByColor(class_1767 color) {
            return chestplateMap.get(color);
        }

        public ItemEntry<Leggings> getLeggingsItem() {
            return leggingsMap.get(this.color);
        }

        public static ItemEntry<Leggings> getLeggingsByColor(class_1767 color) {
            return leggingsMap.get(color);
        }

        public static boolean isArmored(class_1799 item) {
            return CNItems.ANTI_RADIATION_HELMETS.contains(item.method_7909()) || CNItems.ANTI_RADIATION_CHESTPLATES.contains(item.method_7909()) || CNItems.ANTI_RADIATION_LEGGINGS.contains(item.method_7909()) || CNItems.ANTI_RADIATION_BOOTS.is(item.method_7909());
        }

        static {
            helmetMap = new EnumMap<class_1767, ItemEntry<Helmet>>(class_1767.class);
            chestplateMap = new EnumMap<class_1767, ItemEntry<Chestplate>>(class_1767.class);
            leggingsMap = new EnumMap<class_1767, ItemEntry<Leggings>>(class_1767.class);
            for (class_1767 color : class_1767.values()) {
                helmetMap.put(color, CNItems.ANTI_RADIATION_HELMETS.get(color));
                chestplateMap.put(color, CNItems.ANTI_RADIATION_CHESTPLATES.get(color));
                leggingsMap.put(color, CNItems.ANTI_RADIATION_LEGGINGS.get(color));
            }
        }
    }

    public static class DyeRecipeArmorList
    implements Iterable<CreateRecipeProvider.GeneratedRecipe> {
        private static final int COLOR_AMOUNT = class_1767.values().length;
        protected final CreateRecipeProvider.GeneratedRecipe[] recipes = new CreateRecipeProvider.GeneratedRecipe[this.getColorCount()];

        public DyeRecipeArmorList(Function<@NotNull class_1767, // Could not load outer class - annotation placement on inner may be incorrect
        CreateRecipeProvider.GeneratedRecipe> filler) {
            for (class_1767 color : class_1767.values()) {
                this.recipes[color.ordinal()] = filler.apply(color);
            }
        }

        protected int getColorCount() {
            return COLOR_AMOUNT;
        }

        public CreateRecipeProvider.GeneratedRecipe get(class_1767 color) {
            return this.recipes[color.ordinal()];
        }

        public CreateRecipeProvider.GeneratedRecipe[] toArrays() {
            return Arrays.copyOf(this.recipes, this.recipes.length);
        }

        @Override
        @NotNull
        public Iterator<CreateRecipeProvider.GeneratedRecipe> iterator() {
            return new Iterator<CreateRecipeProvider.GeneratedRecipe>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < recipes.length;
                }

                @Override
                public CreateRecipeProvider.GeneratedRecipe next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return recipes[this.index++];
                }
            };
        }
    }

    public static class Boot
    extends class_1738
    implements ArmorTextureItem {
        public Boot(class_1792.class_1793 properties) {
            super(ARMOR_MATERIAL, BOOTS, properties);
        }

        public String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
            return String.valueOf(CreateNuclear.asResource("textures/models/armor/white_anti_radiation_suit_layer_1.png"));
        }
    }

    public static class Leggings
    extends class_1738
    implements ArmorTextureItem {
        protected final class_1767 color;

        public Leggings(class_1792.class_1793 properties, class_1767 color) {
            super(ARMOR_MATERIAL, LEGGINGS, properties);
            this.color = color;
        }

        public String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
            return String.valueOf(CreateNuclear.asResource("textures/models/armor/" + String.valueOf(this.color) + "_anti_radiation_suit_layer_" + (slot == class_1304.field_6172 ? 2 : 1) + ".png"));
        }

        public static class DyeItemLeggingsList<T extends Leggings>
        implements Iterable<ItemEntry<T>> {
            private static final int COLOR_AMOUNT = class_1767.values().length;
            private final ItemEntry<?>[] entry = new ItemEntry[COLOR_AMOUNT];

            public DyeItemLeggingsList(Function<class_1767, ItemEntry<? extends T>> filler) {
                for (class_1767 color : class_1767.values()) {
                    this.entry[color.ordinal()] = filler.apply(color);
                }
            }

            public ItemEntry<T> get(class_1767 color) {
                return this.entry[color.ordinal()];
            }

            public boolean contains(class_1792 block) {
                for (ItemEntry<?> entry : this.entry) {
                    if (!entry.is(block)) continue;
                    return true;
                }
                return false;
            }

            public ItemEntry<T>[] toArray() {
                return Arrays.copyOf(this.entry, this.entry.length);
            }

            @Override
            public Iterator<ItemEntry<T>> iterator() {
                return new Iterator<ItemEntry<T>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < entry.length;
                    }

                    @Override
                    public ItemEntry<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return entry[this.index++];
                    }
                };
            }
        }
    }

    public static class Chestplate
    extends class_1738
    implements ArmorTextureItem {
        protected final class_1767 color;

        public Chestplate(class_1792.class_1793 properties, class_1767 color) {
            super(ARMOR_MATERIAL, CHESTPLATE, properties);
            this.color = color;
        }

        public String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
            return String.valueOf(CreateNuclear.asResource("textures/models/armor/" + String.valueOf(this.color) + "_anti_radiation_suit_layer_" + (slot == class_1304.field_6172 ? 2 : 1) + ".png"));
        }

        public static class DyeItemChestplateList<T extends Chestplate>
        implements Iterable<ItemEntry<T>> {
            private static final int COLOR_AMOUNT = class_1767.values().length;
            private final ItemEntry<?>[] entry = new ItemEntry[COLOR_AMOUNT];

            public DyeItemChestplateList(Function<class_1767, ItemEntry<? extends T>> filler) {
                for (class_1767 color : class_1767.values()) {
                    this.entry[color.ordinal()] = filler.apply(color);
                }
            }

            public ItemEntry<T> get(class_1767 color) {
                return this.entry[color.ordinal()];
            }

            public boolean contains(class_1792 block) {
                for (ItemEntry<?> entry : this.entry) {
                    if (!entry.is(block)) continue;
                    return true;
                }
                return false;
            }

            public ItemEntry<T>[] toArray() {
                return Arrays.copyOf(this.entry, this.entry.length);
            }

            @Override
            public Iterator<ItemEntry<T>> iterator() {
                return new Iterator<ItemEntry<T>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < entry.length;
                    }

                    @Override
                    public ItemEntry<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return entry[this.index++];
                    }
                };
            }
        }
    }

    public static class Helmet
    extends class_1738
    implements ArmorTextureItem {
        protected final class_1767 color;

        public Helmet(class_1792.class_1793 properties, class_1767 color) {
            super(ARMOR_MATERIAL, HELMET, properties);
            this.color = color;
        }

        public String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
            return String.valueOf(CreateNuclear.asResource("textures/models/armor/" + String.valueOf(this.color) + "_anti_radiation_suit_layer_" + (slot == class_1304.field_6172 ? 2 : 1) + ".png"));
        }

        public static class DyeItemHelmetList<T extends Helmet>
        implements Iterable<ItemEntry<T>> {
            private static final int COLOR_AMOUNT = class_1767.values().length;
            private final ItemEntry<?>[] entry = new ItemEntry[COLOR_AMOUNT];

            public DyeItemHelmetList(Function<class_1767, ItemEntry<? extends T>> filler) {
                for (class_1767 color : class_1767.values()) {
                    this.entry[color.ordinal()] = filler.apply(color);
                }
            }

            public ItemEntry<T> get(class_1767 color) {
                return this.entry[color.ordinal()];
            }

            public boolean contains(class_1792 block) {
                for (ItemEntry<?> entry : this.entry) {
                    if (!entry.is(block)) continue;
                    return true;
                }
                return false;
            }

            public ItemEntry<T>[] toArray() {
                return Arrays.copyOf(this.entry, this.entry.length);
            }

            @Override
            public Iterator<ItemEntry<T>> iterator() {
                return new Iterator<ItemEntry<T>>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < entry.length;
                    }

                    @Override
                    public ItemEntry<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return entry[this.index++];
                    }
                };
            }
        }
    }
}

