/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.fluid;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class FluidInteractionManager {
    private static final Map<class_3609, List<FluidInteractionRule>> RULES = new HashMap<class_3609, List<FluidInteractionRule>>();
    private static final ImmutableList<class_2350> DIRS = class_2404.field_34006;

    public static void addRule(class_3609 source, FluidInteractionRule rule) {
        RULES.computeIfAbsent(source, f -> new ArrayList()).add(rule);
    }

    public static Optional<Boolean> applyRules(class_3609 fluid, class_1936 world, class_2338 pos) {
        List<FluidInteractionRule> list = RULES.get(fluid);
        if (list == null || list.isEmpty()) {
            return Optional.empty();
        }
        boolean isSource = world.method_8316(pos).method_15771();
        InteractionContext ctx = new InteractionContext(world, pos, isSource, fluid);
        List<FluidInteractionRule> sorted = list.stream().sorted(Comparator.comparingInt(r -> r.priority)).toList();
        for (FluidInteractionRule rule : sorted) {
            boolean adjacentMatch = DIRS.stream().map(d -> world.method_8316(pos.method_10093(d))).anyMatch(fs -> rule.checkFluid().test((class_3610)fs) && (rule.excludeSelf() == false || !fs.method_15772().method_15780((class_3611)fluid)));
            if (!adjacentMatch) continue;
            if (world instanceof class_1937) {
                class_1937 level = (class_1937)world;
                level.method_8501(pos, rule.resultState.apply(isSource));
            }
            world.method_20290(1501, pos, 0);
            rule.onInteract.accept(ctx);
            return Optional.of(rule.returnValue);
        }
        return Optional.empty();
    }

    public record InteractionContext(class_1936 world, class_2338 pos, boolean isSource, class_3609 fluid) {
    }

    public record FluidInteractionRule(int priority, Predicate<class_3610> checkFluid, Boolean excludeSelf, Function<Boolean, class_2680> resultState, Consumer<InteractionContext> onInteract, boolean returnValue) {
    }
}

