/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.entity.irradiatedcat;

import com.google.common.collect.ImmutableList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_6328;
import net.nuclearteam.createnuclear.entity.irradiatedcat.IrradiatedCat;

@ParametersAreNonnullByDefault
@class_6328
public class IrradiatedCatModel<T extends IrradiatedCat>
extends class_4592<T> {
    private static final float PI = (float)Math.PI;
    private static final float HALF_PI = 1.5707964f;
    private final class_630 pustule3;
    private final class_630 pustule2;
    private final class_630 teeth2;
    private final class_630 teeth;
    private final class_630 pustule;
    private final class_630 head;
    private final class_630 body;
    private final class_630 leftFrontLeg;
    private final class_630 rightFrontLeg;
    private final class_630 leftHindLeg;
    private final class_630 rightHindLeg;
    private final class_630 tail1;
    private final class_630 tail2;
    private final ImmutableList<class_630> headParts;
    private final ImmutableList<class_630> bodyParts;
    protected int state = 1;

    public IrradiatedCatModel(class_630 root) {
        this.pustule = root.method_32086("pustule");
        this.pustule3 = root.method_32086("pustule3");
        this.pustule2 = root.method_32086("pustule2");
        this.teeth2 = root.method_32086("teeth2");
        this.teeth = root.method_32086("teeth");
        this.head = root.method_32086("head");
        this.body = root.method_32086("body");
        this.leftFrontLeg = root.method_32086("left_front_leg");
        this.rightFrontLeg = root.method_32086("right_front_leg");
        this.leftHindLeg = root.method_32086("left_hind_leg");
        this.rightHindLeg = root.method_32086("right_hind_leg");
        this.tail1 = root.method_32086("tail1");
        this.tail2 = root.method_32086("tail2");
        this.headParts = ImmutableList.of((Object)this.head, (Object)this.pustule);
        this.bodyParts = ImmutableList.of((Object)this.body, (Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail1, (Object)this.tail2, (Object)this.pustule2, (Object)this.pustule3);
    }

    protected Iterable<class_630> method_22946() {
        return this.headParts;
    }

    protected Iterable<class_630> method_22948() {
        return this.bodyParts;
    }

    public static class_5607 createBodyLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 root = meshdefinition.method_32111();
        IrradiatedCatModel.addPustule(root, "pustule", -2.1f, 15.5f, -10.0f, -0.2597f, 0.0338f, 1.6973f);
        IrradiatedCatModel.addPustule(root, "pustule2", 1.5f, 14.6f, 4.5f, 1.442f, 0.0338f, 1.6973f);
        IrradiatedCatModel.addPustule(root, "pustule3", 1.5f, 19.6f, -4.5f, 1.8282f, -1.4377f, 3.0129f);
        IrradiatedCatModel.addTooth(root, "teeth", 0.8f, 17.1f, -12.2f);
        IrradiatedCatModel.addTooth(root, "teeth2", -0.8f, 17.1f, -12.2f);
        root.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f).method_32101(0, 24).method_32097(-1.5f, -0.02f, -4.0f, 3.0f, 2.0f, 2.0f).method_32101(0, 10).method_32097(-2.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f).method_32101(6, 10).method_32097(1.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)15.0f, (float)-9.0f));
        root.method_32117("body", class_5606.method_32108().method_32101(20, 0).method_32097(-2.0f, 3.0f, -8.0f, 4.0f, 16.0f, 6.0f), class_5603.method_32091((float)0.0f, (float)12.0f, (float)-10.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        IrradiatedCatModel.addLeg(root, "left_front_leg", 1.1f, 14.1f, -5.0f, 10, false);
        IrradiatedCatModel.addLeg(root, "right_front_leg", -1.1f, 14.1f, -5.0f, 10, false);
        IrradiatedCatModel.addLeg(root, "left_hind_leg", 1.1f, 18.0f, 5.0f, 6, true);
        IrradiatedCatModel.addLeg(root, "right_hind_leg", -1.1f, 18.0f, 5.0f, 6, true);
        IrradiatedCatModel.addTailSegment(root, "tail1", 0.0f, 15.0f, 8.0f, 0.9f);
        IrradiatedCatModel.addTailSegment(root, "tail2", 0.0f, 20.0f, 14.0f, 0.0f);
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_3654 = headPitch * ((float)Math.PI / 180);
        this.head.field_3675 = netHeadYaw * ((float)Math.PI / 180);
        if (this.state != 3) {
            this.body.field_3654 = 1.5707964f;
            boolean isWalking = this.state == 2;
            this.setupLegs(limbSwing, limbSwingAmount, isWalking);
            this.setupTail(limbSwing, limbSwingAmount, this.state);
        }
    }

    private void setupLegs(float swing, float amount, boolean offset) {
        float swingSpeed = 0.6662f;
        float frontOffset = offset ? 0.3f : (float)Math.PI;
        float backOffset = offset ? 0.3f : 0.0f;
        this.leftHindLeg.field_3654 = class_3532.method_15362((float)(swing * swingSpeed)) * amount;
        this.rightHindLeg.field_3654 = class_3532.method_15362((float)(swing * swingSpeed + backOffset)) * amount;
        this.leftFrontLeg.field_3654 = class_3532.method_15362((float)(swing * swingSpeed + (float)Math.PI + frontOffset)) * amount;
        this.rightFrontLeg.field_3654 = class_3532.method_15362((float)(swing * swingSpeed + (float)Math.PI - frontOffset)) * amount;
    }

    private void setupTail(float swing, float amount, int state) {
        float base = 1.7278761f;
        float factor = switch (state) {
            case 1 -> 0.7853982f;
            case 2 -> 0.31415927f;
            default -> 0.47123894f;
        };
        this.tail2.field_3654 = base + factor * class_3532.method_15362((float)swing) * amount;
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (class_630 part : this.headParts) {
            part.method_22699(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        for (class_630 part : this.bodyParts) {
            part.method_22699(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    private static void addPustule(class_5610 root, String name, float x, float y, float z, float rx, float ry, float rz) {
        root.method_32117(name, class_5606.method_32108().method_32101(46, 24).method_32097(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), class_5603.method_32091((float)x, (float)y, (float)z, (float)rx, (float)ry, (float)rz));
    }

    private static void addTooth(class_5610 root, String name, float x, float y, float z) {
        root.method_32117(name, class_5606.method_32108().method_32101(41, 23).method_32097(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f), class_5603.method_32091((float)x, (float)y, (float)z, (float)0.3927f, (float)0.0f, (float)0.0f));
    }

    private static void addLeg(class_5610 root, String name, float x, float y, float z, int height, boolean hind) {
        int texX = hind ? 8 : 40;
        int texY = hind ? 13 : 0;
        boolean dz = hind;
        root.method_32117(name, class_5606.method_32108().method_32101(texX, texY).method_32097(-1.0f, 0.0f, (float)dz, 2.0f, (float)height, 2.0f), class_5603.method_32090((float)x, (float)y, (float)z));
    }

    private static void addTailSegment(class_5610 root, String name, float x, float y, float z, float rotationX) {
        int texY = name.equals("tail1") ? 15 : 15;
        int texX = name.equals("tail1") ? 0 : 4;
        root.method_32117(name, class_5606.method_32108().method_32101(texX, texY).method_32097(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f), class_5603.method_32091((float)x, (float)y, (float)z, (float)rotationX, (float)0.0f, (float)0.0f));
    }
}

