/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.datagen.recipe.crafting;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import io.github.fabricators_of_create.porting_lib.tags.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2246;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6328;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_8074;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.block.CNBlocks;
import net.nuclearteam.createnuclear.item.CNItems;
import net.nuclearteam.createnuclear.item.armor.AntiRadiationArmorItem;
import net.nuclearteam.createnuclear.item.cloth.ClothItem;
import net.nuclearteam.createnuclear.tags.CNTag;

@class_6328
@ParametersAreNonnullByDefault
public class CNStandardRecipeGen
extends CreateRecipeProvider {
    private final String CRAFTING = this.enterFolder("crafting");
    CreateRecipeProvider.GeneratedRecipe WHITE_CLOTH_FROM_STRING = this.create((Supplier<class_1935>)((Supplier)ClothItem.Cloths.WHITE_CLOTH::getItem)).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> class_1802.field_8276)).viaShaped(b -> b.method_10433(Character.valueOf('#'), Tags.Items.STRING).method_10439("###").method_10439("###").method_49380(true));
    CreateRecipeProvider.GeneratedRecipe WHITE_CLOTH_FROM_WOOL = this.create((Supplier<class_1935>)((Supplier)ClothItem.Cloths.WHITE_CLOTH::getItem)).returns(6).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> class_1802.field_19044)).withSuffix("_wool").viaShaped(b -> b.method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10446).method_10439("###").method_10439("###").method_49380(true));
    CreateRecipeProvider.GeneratedRecipe ENRICHED_SOUL_SOIL = this.create((ItemProviderEntry<? extends class_1935>)CNBlocks.ENRICHED_SOUL_SOIL).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> class_1802.field_8137)).viaShaped(b -> b.method_10434(Character.valueOf('S'), (class_1935)class_2246.field_22090).method_10434(Character.valueOf('O'), (class_1935)class_2246.field_10540).method_10434(Character.valueOf('N'), (class_1935)class_1802.field_8137).method_10439("SOS").method_10439("ONO").method_10439("SOS").method_49380(true));
    CreateRecipeProvider.GeneratedRecipe ENRICHING_CAMPFIRE = this.create((ItemProviderEntry<? extends class_1935>)CNBlocks.ENRICHING_CAMPFIRE).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> CNBlocks.ENRICHED_SOUL_SOIL.get())).viaShaped(b -> b.method_10434(Character.valueOf('E'), CNBlocks.ENRICHED_SOUL_SOIL).method_10433(Character.valueOf('L'), class_3489.field_15539).method_10433(Character.valueOf('S'), Tags.Items.RODS_WOODEN).method_10439(" S ").method_10439("SES").method_10439("LLL").method_49380(true));
    CreateRecipeProvider.GeneratedRecipe REACTOR_BLUEPRINT_ITEM = this.create((ItemProviderEntry<? extends class_1935>)CNItems.REACTOR_BLUEPRINT).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> CNBlocks.REACTOR_CONTROLLER.get())).viaShaped(b -> b.method_10433(Character.valueOf('S'), CNTag.forgeItemTag("ingots/steel")).method_10434(Character.valueOf('D'), (class_1935)AllBlocks.DISPLAY_BOARD).method_10434(Character.valueOf('P'), (class_1935)AllItems.PRECISION_MECHANISM).method_10434(Character.valueOf('E'), (class_1935)AllItems.EMPTY_SCHEMATIC).method_10439("SDS").method_10439("SPS").method_10439("SES").method_49380(true));
    private final String CRAFTING_MATERIALS = this.enterFolder("crafting/materials");
    CreateRecipeProvider.GeneratedRecipe RAW_URANIUM_BLOCK = this.create((ItemProviderEntry<? extends class_1935>)CNBlocks.RAW_URANIUM_BLOCK).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> CNItems.RAW_URANIUM.get())).viaShaped(b -> b.method_10434(Character.valueOf('R'), (class_1935)CNItems.RAW_URANIUM.get()).method_10439("RRR").method_10439("RRR").method_10439("RRR").method_49380(true));
    CreateRecipeProvider.GeneratedRecipe LEAD_COMPACTING = this.metalCompacting((List<ItemProviderEntry<? extends class_1935>>)ImmutableList.of(CNItems.LEAD_NUGGET, CNItems.LEAD_INGOT, CNBlocks.LEAD_BLOCK), (List<Supplier<class_6862<class_1792>>>)ImmutableList.of(() -> CNTag.forgeItemTag("nuggets/lead"), () -> CNTag.forgeItemTag("ingots/lead"), () -> CNTag.forgeItemTag("storage_blocks/lead")));
    CreateRecipeProvider.GeneratedRecipe STEEL_COMPACTING = this.metalCompacting((List<ItemProviderEntry<? extends class_1935>>)ImmutableList.of(CNItems.STEEL_NUGGET, CNItems.STEEL_INGOT, CNBlocks.STEEL_BLOCK), (List<Supplier<class_6862<class_1792>>>)ImmutableList.of(() -> CNTag.forgeItemTag("nuggets/steel"), () -> CNTag.forgeItemTag("ingots/steel"), () -> CNTag.forgeItemTag("storage_blocks/steel")));
    CreateRecipeProvider.GeneratedRecipe RAW_LEAD_BLOCK = this.create((ItemProviderEntry<? extends class_1935>)CNBlocks.RAW_LEAD_BLOCK).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> CNItems.RAW_LEAD.get())).viaShaped(b -> b.method_10434(Character.valueOf('R'), (class_1935)CNItems.RAW_LEAD.get()).method_10439("RRR").method_10439("RRR").method_10439("RRR").method_49380(true));
    private final String CRAFTING_REACTOR = this.enterFolder("crafting/reactor");
    CreateRecipeProvider.GeneratedRecipe REINFORCED_GLASS = this.create((ItemProviderEntry<? extends class_1935>)CNBlocks.REINFORCED_GLASS).unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> CNBlocks.REACTOR_CASING.get())).viaShaped(b -> b.method_10433(Character.valueOf('G'), CNTag.forgeItemTag("glass_blocks")).method_10433(Character.valueOf('S'), CNTag.forgeItemTag("ingots/lead")).method_10439("SGS").method_10439("GSG").method_10439("SGS").method_49380(true));
    private final String CRAFTING_ITEMS = this.enterFolder("crafting/items/armors");
    AntiRadiationArmorItem.DyeRecipeArmorList ANTI_RADIATION_HELMETS = new AntiRadiationArmorItem.DyeRecipeArmorList(color -> this.create((ItemProviderEntry<? extends class_1935>)CNItems.ANTI_RADIATION_HELMETS.get((class_1767)color)).unlockedByTag((Supplier<class_6862<class_1792>>)((Supplier)() -> CNTag.ItemTags.CLOTH.tag)).withCategory(class_7800.field_40639).viaShaped(i -> i.method_10433(Character.valueOf('X'), CNTag.forgeItemTag("ingots/lead")).method_10434(Character.valueOf('Y'), (class_1935)ClothItem.Cloths.getByColor(color).get()).method_10434(Character.valueOf('Z'), CNBlocks.REINFORCED_GLASS).method_10439("YXY").method_10439("XZX").method_49380(true)));
    AntiRadiationArmorItem.DyeRecipeArmorList ANTI_RADIATION_CHESTPLATES = new AntiRadiationArmorItem.DyeRecipeArmorList(color -> this.create((ItemProviderEntry<? extends class_1935>)CNItems.ANTI_RADIATION_CHESTPLATES.get((class_1767)color)).unlockedByTag((Supplier<class_6862<class_1792>>)((Supplier)() -> CNTag.ItemTags.CLOTH.tag)).withCategory(class_7800.field_40639).viaShaped(i -> i.method_10433(Character.valueOf('X'), CNTag.forgeItemTag("ingots/lead")).method_10434(Character.valueOf('Y'), (class_1935)ClothItem.Cloths.getByColor(color).get()).method_10434(Character.valueOf('Z'), CNItems.GRAPHITE_ROD).method_10439("Y Y").method_10439("XXX").method_10439("ZXZ").method_49380(true)));
    AntiRadiationArmorItem.DyeRecipeArmorList ANTI_RADIATION_LEGGINS = new AntiRadiationArmorItem.DyeRecipeArmorList(color -> this.create((ItemProviderEntry<? extends class_1935>)CNItems.ANTI_RADIATION_LEGGINGS.get((class_1767)color)).unlockedByTag((Supplier<class_6862<class_1792>>)((Supplier)() -> CNTag.ItemTags.CLOTH.tag)).withCategory(class_7800.field_40639).viaShaped(i -> i.method_10433(Character.valueOf('X'), CNTag.forgeItemTag("ingots/lead")).method_10434(Character.valueOf('Y'), (class_1935)ClothItem.Cloths.getByColor(color).get()).method_10439("YXY").method_10439("X X").method_10439("Y Y").method_49380(true)));
    CreateRecipeProvider.GeneratedRecipe ANTI_RADIATION_BOOTS = this.create((ItemProviderEntry<? extends class_1935>)CNItems.ANTI_RADIATION_BOOTS).unlockedByTag((Supplier<class_6862<class_1792>>)((Supplier)() -> CNTag.ItemTags.CLOTH.tag)).withCategory(class_7800.field_40639).viaShaped(b -> b.method_10433(Character.valueOf('X'), CNTag.forgeItemTag("ingots/lead")).method_10434(Character.valueOf('Y'), ClothItem.Cloths.WHITE_CLOTH.getItem()).method_10439("Y Y").method_10439("X X").method_49380(true));
    String currentFolder = "";

    String enterFolder(String folder) {
        this.currentFolder = folder;
        return this.currentFolder;
    }

    GeneratedRecipeBuilder create(Supplier<class_1935> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(class_2960 result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends class_1935> result) {
        return this.create((Supplier<class_1935>)((Supplier)() -> result.get()));
    }

    CreateRecipeProvider.GeneratedRecipe metalCompacting(List<ItemProviderEntry<? extends class_1935>> variants, List<Supplier<class_6862<class_1792>>> ingredients) {
        CreateRecipeProvider.GeneratedRecipe result = null;
        int i = 0;
        while (i + 1 < variants.size()) {
            ItemProviderEntry<? extends class_1935> currentEntry = variants.get(i);
            ItemProviderEntry<? extends class_1935> nextEntry = variants.get(i + 1);
            Supplier<class_6862<class_1792>> currentIngredient = ingredients.get(i);
            Supplier<class_6862<class_1792>> nextIngredient = ingredients.get(i + 1);
            result = this.create(nextEntry).withSuffix("_from_compacting").unlockedBy((Supplier<? extends class_1935>)((Supplier)() -> currentEntry.get())).viaShaped(b -> b.method_10439("###").method_10439("###").method_10439("###").method_10433(Character.valueOf('#'), (class_6862)currentIngredient.get()));
            ++i;
        }
        return result;
    }

    public String method_10321() {
        return "CreateNuclear's Standard Recipes";
    }

    public CNStandardRecipeGen(FabricDataOutput output) {
        super(output);
    }

    class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends class_1935> result;
        private class_2960 compatDatagenOutput;
        List<ConditionJsonProvider> recipeConditions;
        private class_7800 category;
        private Supplier<class_2073> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ConditionJsonProvider>();
            this.suffix = "";
            this.amount = 1;
            this.category = class_7800.field_40642;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends class_1935> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, class_2960 result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends class_1935> item) {
            this.unlockedBy = () -> class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)item.get()}).method_8976();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<class_6862<class_1792>> tag) {
            this.unlockedBy = () -> class_2073.class_2074.method_8973().method_8975((class_6862)tag.get()).method_8976();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition(DefaultResourceConditions.allModsLoaded((String[])new String[]{modid}));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition(DefaultResourceConditions.not((ConditionJsonProvider)DefaultResourceConditions.allModsLoaded((String[])new String[]{modid})));
        }

        GeneratedRecipeBuilder withCondition(ConditionJsonProvider condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        GeneratedRecipeBuilder withCategory(class_7800 category) {
            this.category = category;
            return this;
        }

        CreateRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<class_2447> builder) {
            return CNStandardRecipeGen.this.register(consumer -> {
                class_2447 b = (class_2447)builder.apply(class_2447.method_10436((class_7800)this.category, (class_1935)((class_1935)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.method_10429("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{(class_2073)this.unlockedBy.get()}));
                }
                b.method_17972(consumer, this.createSimpleLocation(this.path));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<class_2450> builder) {
            return CNStandardRecipeGen.this.register(consumer -> {
                class_2450 b = (class_2450)builder.apply(class_2450.method_10448((class_7800)this.category, (class_1935)((class_1935)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.method_10442("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{(class_2073)this.unlockedBy.get()}));
                }
                b.method_17972(consumer, this.createSimpleLocation(this.path));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends class_1792> base, Supplier<class_1856> upgradeMaterial) {
            this.withCategory(class_7800.field_40639);
            return CNStandardRecipeGen.this.register(consumer -> {
                class_8074 b = class_8074.method_48535((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_41946}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)base.get()}), (class_1856)((class_1856)upgradeMaterial.get()), (class_7800)this.category, (class_1792)((class_1935)this.result.get()).method_8389());
                b.method_48536("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)base.get()}).method_8976()}));
                b.method_48537(consumer, this.createSimpleLocation(this.path));
            });
        }

        private class_2960 createSimpleLocation(String recipeType) {
            return CreateNuclear.asResource(recipeType + "/" + this.getRegistryName().method_12832() + this.suffix);
        }

        private class_2960 createLocation(String recipeType) {
            return CreateNuclear.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().method_12832() + this.suffix);
        }

        private class_2960 getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjects.getKeyOrThrow((class_1792)((class_1935)this.result.get()).method_8389()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends class_1935> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<class_1856>)((Supplier)() -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<class_6862<class_1792>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<class_1856>)((Supplier)() -> class_1856.method_8106((class_6862)((class_6862)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<class_1856> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<class_1856> ingredient;
            private float exp;
            private int cookingTime;
            private final class_1865<? extends class_1874> FURNACE = class_1865.field_9042;
            private final class_1865<? extends class_1874> SMOKER = class_1865.field_17085;
            private final class_1865<? extends class_1874> BLAST = class_1865.field_17084;
            private final class_1865<? extends class_1874> CAMPFIRE = class_1865.field_17347;

            GeneratedCookingRecipeBuilder(Supplier<class_1856> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<class_2454> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<class_2454> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<class_2454> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private CreateRecipeProvider.GeneratedRecipe create(class_1865<? extends class_1874> serializer, UnaryOperator<class_2454> builder, float cookingTimeModifier) {
                return CNStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    class_2454 b = (class_2454)builder.apply(class_2454.method_17801((class_1856)((class_1856)this.ingredient.get()), (class_7800)class_7800.field_40642, (class_1935)(isOtherMod ? class_1802.field_8831 : (class_1935)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (class_1865)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.method_10469("has_item", (class_184)class_2446.method_10423((class_2073[])new class_2073[]{(class_2073)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.method_17972(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((class_2444)result, GeneratedRecipeBuilder.this.compatDatagenOutput, GeneratedRecipeBuilder.this.recipeConditions) : result), GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjects.getKeyOrThrow((class_1865)serializer).method_12832()));
                });
            }
        }
    }

    private record ModdedCookingRecipeResult(class_2444 wrapped, class_2960 outputOverride, List<ConditionJsonProvider> conditions) implements class_2444
    {
        public class_2960 method_10417() {
            return this.wrapped.method_10417();
        }

        public class_1865<?> method_17800() {
            return this.wrapped.method_17800();
        }

        public JsonObject method_10415() {
            return this.wrapped.method_10415();
        }

        public class_2960 method_10418() {
            return this.wrapped.method_10418();
        }

        public void method_10416(JsonObject object) {
            this.wrapped.method_10416(object);
            object.addProperty("result", this.outputOverride.toString());
            ConditionJsonProvider.write((JsonObject)object, (ConditionJsonProvider[])this.conditions.toArray(new ConditionJsonProvider[0]));
        }
    }
}

