/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.config;

import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_6328;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.nuclearteam.createnuclear.config.CNConfigBase;
import net.nuclearteam.createnuclear.config.CNConfigCommon;
import org.apache.commons.lang3.tuple.Pair;

@class_6328
@ParametersAreNonnullByDefault
public class CNConfigs {
    private static final Map<ModConfig.Type, CNConfigBase> CONFIGS = new EnumMap<ModConfig.Type, CNConfigBase>(ModConfig.Type.class);
    private static CNConfigCommon common;

    public static CNConfigCommon common() {
        return common;
    }

    public static CNConfigBase getType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends CNConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CNConfigBase config = (CNConfigBase)factory.get();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        CNConfigBase config = (CNConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register() {
        common = CNConfigs.register(CNConfigCommon::new, ModConfig.Type.COMMON);
        for (Map.Entry<ModConfig.Type, CNConfigBase> pair : CONFIGS.entrySet()) {
            ForgeConfigRegistry.INSTANCE.register("createnuclear", pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        ModConfigEvents.loading((String)"createnuclear").register(CNConfigs::onLoad);
        ModConfigEvents.reloading((String)"createnuclear").register(CNConfigs::onReload);
    }

    public static void onLoad(ModConfig modConfig) {
        for (CNConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (CNConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }
}

