/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.compact.archEx;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.nuclearteam.createnuclear.block.palette.CNPaletteBlockPattern;
import net.nuclearteam.createnuclear.block.palette.CNPalettesStoneTypes;
import net.nuclearteam.createnuclear.compact.archEx.CNArchExGroup;
import org.jetbrains.annotations.NotNull;

@class_6328
@ParametersAreNonnullByDefault
public class CNGroupProvider
implements class_2405 {
    public static final Set<CNPaletteBlockPattern> EXTENDABLE_PATTERNS = Set.of(CNPaletteBlockPattern.CUT, CNPaletteBlockPattern.POLISHED, CNPaletteBlockPattern.BRICKS, CNPaletteBlockPattern.SMALL_BRICKS);
    private final FabricDataOutput out;
    public final List<CNArchExGroup> groups;

    public CNGroupProvider(FabricDataOutput out) {
        this.out = out;
        this.groups = this.generateGroups();
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        Path outputDir = this.out.method_45971().resolve("staticdata").resolve("architecture_extensions");
        ArrayList saveFutures = new ArrayList();
        this.groups.forEach(group -> {
            JsonObject json = group.toJson();
            Path outputFile = outputDir.resolve(group.name() + ".json");
            CompletableFuture future = class_2405.method_10320((class_7403)output, (JsonElement)json, (Path)outputFile);
            saveFutures.add(future);
        });
        return CompletableFuture.allOf((CompletableFuture[])saveFutures.toArray(CompletableFuture[]::new));
    }

    private List<CNArchExGroup> generateGroups() {
        ArrayList<CNArchExGroup> groups = new ArrayList<CNArchExGroup>();
        for (CNPalettesStoneTypes stoneTypes : CNPalettesStoneTypes.values()) {
            for (CNPaletteBlockPattern blockPattern : stoneTypes.variantTypes) {
                if (!EXTENDABLE_PATTERNS.contains(blockPattern)) continue;
                CNArchExGroup group = CNArchExGroup.builder().fromStoneTypeAndPattern(stoneTypes, blockPattern).build();
                groups.add(group);
            }
        }
        return groups;
    }

    @NotNull
    public String method_10321() {
        return "CreateNuclear ArchEx compat";
    }
}

