/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.compact.archEx;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.compat.archEx.BlockType;
import com.simibubi.create.compat.archEx.Recipes;
import com.simibubi.create.compat.archEx.Textures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_7923;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.block.palette.CNPaletteBlockPattern;
import net.nuclearteam.createnuclear.block.palette.CNPalettesStoneTypes;
import net.nuclearteam.createnuclear.compact.archEx.CNMapColorSerialization;

public record CNArchExGroup(String name, class_2248 base, Textures textures, Recipes recipes, class_3620 color, BlockType[] types) {
    public static Builder builder() {
        return new Builder();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        class_2960 blockId = class_7923.field_41175.method_10221((Object)this.base);
        json.addProperty("base_block", blockId.toString());
        json.addProperty("textures", this.textures.typeOrId());
        json.addProperty("recipes", this.recipes.name);
        String colorName = CNMapColorSerialization.getArchExName(this.color);
        json.addProperty("map_color", colorName);
        JsonArray typesArray = new JsonArray();
        for (BlockType type : this.types) {
            typesArray.add(type.name);
        }
        json.add("types_to_generate", (JsonElement)typesArray);
        return json;
    }

    public static class Builder {
        private String name;
        private class_2248 base;
        private Textures textures;
        private Recipes recipes;
        private class_3620 color;
        private final List<BlockType> types = new ArrayList<BlockType>();

        public Builder fromStoneTypeAndPattern(CNPalettesStoneTypes type, CNPaletteBlockPattern pattern) {
            String variant = Lang.asId((String)type.name());
            String baseBlockName = pattern.createName(variant);
            class_2248 baseBlock = (class_2248)class_7923.field_41175.method_10223(CreateNuclear.asResource(baseBlockName));
            if (baseBlock == class_2246.field_10124) {
                throw new IllegalStateException("Unknown block: " + baseBlockName + " " + baseBlockName);
            }
            class_2960 texture = CNPaletteBlockPattern.toLocation(variant, pattern.getTexture(0));
            class_3620 color = baseBlock.method_26403();
            return this.named(baseBlockName).basedOn(baseBlock).textured(Textures.ofTexture((class_2960)texture)).withRecipes(Recipes.STONECUTTING_AND_CRAFTING).colored(color).withTypes(BlockType.FOR_STONES);
        }

        public Builder named(String name) {
            this.name = name;
            return this;
        }

        public Builder basedOn(class_2248 block) {
            this.base = block;
            return this;
        }

        public Builder textured(Textures textures) {
            this.textures = textures;
            return this;
        }

        public Builder withRecipes(Recipes recipes) {
            this.recipes = recipes;
            return this;
        }

        public Builder colored(class_3620 color) {
            this.color = color;
            return this;
        }

        private Builder withTypes(BlockType ... types) {
            Collections.addAll(this.types, types);
            return this;
        }

        public CNArchExGroup build() {
            if (this.types.isEmpty()) {
                throw new IllegalArgumentException("types not set");
            }
            return new CNArchExGroup(Objects.requireNonNull(this.name, "name not set"), Objects.requireNonNull(this.base, "base not set"), Objects.requireNonNull(this.textures, "textures not set"), Objects.requireNonNull(this.recipes, "recipes not set"), Objects.requireNonNull(this.color, "color not set"), (BlockType[])this.types.toArray(BlockType[]::new));
        }
    }
}

