/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.advancement;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_161;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6328;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.nuclearteam.createnuclear.advancement.CreateNuclearAdvancement;
import net.nuclearteam.createnuclear.block.CNBlocks;
import net.nuclearteam.createnuclear.fluid.CNFluids;
import net.nuclearteam.createnuclear.item.CNItems;
import net.nuclearteam.createnuclear.tags.CNTag;

@class_6328
@ParametersAreNonnullByDefault
public class CNAdvancement
implements class_2405 {
    public static final List<CreateNuclearAdvancement> ENTRIES = new ArrayList<CreateNuclearAdvancement>();
    public static final CreateNuclearAdvancement START = null;
    public static final CreateNuclearAdvancement ROOT = CNAdvancement.create("root", b -> b.icon((ItemProviderEntry<?>)CNItems.URANIUM_POWDER).title("Starting The Nuclear Journey").description("Unlock the basics of nuclear energy and get your first uranium powder").awardedForFree().special(CreateNuclearAdvancement.TaskType.SILENT));
    public static final CreateNuclearAdvancement RAW_URANIUM = CNAdvancement.create("raw_uranium", b -> b.icon((ItemProviderEntry<?>)CNItems.RAW_URANIUM).title("The Raw Power").description("Mine uranium ore to obtain raw uranium for further processing").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement URANIUM_POWDER = CNAdvancement.create("uranium_powder", b -> b.icon((ItemProviderEntry<?>)CNItems.URANIUM_POWDER).title("Powdered Uranium").description("Crush raw uranium into powder to prepare for further refining").after(RAW_URANIUM).whenIconCollected());
    public static final CreateNuclearAdvancement URANIUM_LIQUID = CNAdvancement.create("uranium_liquid", b -> b.icon((class_1935)CNFluids.URANIUM.getBucket().get()).title("Turning Solid To Liquid").description("Obtain some uranium liquid by mixing uranium powder").after(URANIUM_POWDER).whenIconCollected());
    public static final CreateNuclearAdvancement YELLOWCAKE = CNAdvancement.create("yellowcake", b -> b.icon((ItemProviderEntry<?>)CNItems.YELLOWCAKE).title("The Yellowcake Process").description("Compact uranium liquid to create yellowcake").after(URANIUM_LIQUID).whenIconCollected());
    public static final CreateNuclearAdvancement EATED_YELLOWCAKE = CNAdvancement.create("eated_yellowcake", b -> b.icon((ItemProviderEntry<?>)CNItems.YELLOWCAKE).title("Eating Yellowcake").description("What did you expect ?").after(YELLOWCAKE).whenItemEaten((class_1792)CNItems.YELLOWCAKE.get()).special(CreateNuclearAdvancement.TaskType.SECRET));
    public static final CreateNuclearAdvancement ENRICHED_YELLOWCAKE = CNAdvancement.create("enriched_yellowcake", b -> b.icon((ItemProviderEntry<?>)CNItems.ENRICHED_YELLOWCAKE).title("Enhancing Yellowcake").description("Use a fan to enrich yellowcake and make it more powerful").after(YELLOWCAKE).whenIconCollected());
    public static final CreateNuclearAdvancement URANIUM_ROD = CNAdvancement.create("uranium_rod", b -> b.icon((ItemProviderEntry<?>)CNItems.URANIUM_ROD).title("The Power Of The Atom").description("Create your first uranium rod using enriched yellowcake in a mechanical crafter").after(ENRICHED_YELLOWCAKE).whenIconCollected());
    public static final CreateNuclearAdvancement COAL_DUST = CNAdvancement.create("coal_dust", b -> b.icon((ItemProviderEntry<?>)CNItems.COAL_DUST).title("Coal Dust").description("Crush coal or charcoal to obtain coal dust, a key crafting material").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement STEEL_INGOT = CNAdvancement.create("steel_ingot", b -> b.icon((ItemProviderEntry<?>)CNItems.STEEL_INGOT).title("Steel Ingot").description("Combine coal dust and iron ingots to create steel ingots").after(COAL_DUST).whenIconCollected());
    public static final CreateNuclearAdvancement GRAPHENE = CNAdvancement.create("graphene", b -> b.icon((ItemProviderEntry<?>)CNItems.GRAPHENE).title("Graphene").description("Press coal dust to create graphene").after(COAL_DUST).whenIconCollected());
    public static final CreateNuclearAdvancement GRAPHITE_ROD = CNAdvancement.create("graphite_rod", b -> b.icon((ItemProviderEntry<?>)CNItems.GRAPHITE_ROD).title("Don't Forget Those Ones").description("Combine graphene and steel ingots in a mechanical crafter to make graphite rods").after(GRAPHENE).whenIconCollected());
    public static final CreateNuclearAdvancement RAW_LEAD = CNAdvancement.create("raw_lead", b -> b.icon((ItemProviderEntry<?>)CNItems.RAW_LEAD).title("Raw Lead").description("Obtain some raw lead by mining lead ore").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement LEAD_INGOT = CNAdvancement.create("lead_ingot", b -> b.icon((ItemProviderEntry<?>)CNItems.LEAD_INGOT).title("Lead ingot").description("Smelt a raw lead to obtain a lead ingot").after(RAW_LEAD).whenIconCollected());
    public static final CreateNuclearAdvancement REINFORCED_GLASS = CNAdvancement.create("reinforced_glass", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REINFORCED_GLASS).title("Reinforced Glass").description("Craft some reinforced glass for the first time").after(LEAD_INGOT).whenIconCollected());
    public static final CreateNuclearAdvancement ANTI_RADIATION_ARMOR = CNAdvancement.create("anti_radiation_armor", b -> b.icon((ItemProviderEntry<?>)CNItems.ANTI_RADIATION_HELMETS.get(class_1767.field_7952)).title("Anti radiation Armor").description("Craft your first anti-radiation armor piece to protect yourself from radiation").after(LEAD_INGOT).whenItemCollected(CNTag.ItemTags.ALL_ANTI_RADIATION_ARMORS.tag));
    public static final CreateNuclearAdvancement FULL_ANTI_RADIATION_ARMOR = CNAdvancement.create("full_anti_radiation_armor", b -> b.icon((ItemProviderEntry<?>)CNItems.ANTI_RADIATION_CHESTPLATES.get(class_1767.field_7952)).title("Fully Protected").description("Wear a full set of anti-radiation armor to fully protect yourself from radiation").externalTrigger((class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{new class_2073(CNTag.ItemTags.ANTI_RADIATION_HELMET_FULL_DYE.tag, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, class_2105.field_9716), new class_2073(CNTag.ItemTags.ANTI_RADIATION_CHESTPLATE_FULL_DYE.tag, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, class_2105.field_9716), new class_2073(CNTag.ItemTags.ANTI_RADIATION_LEGGINGS_FULL_DYE.tag, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, class_2105.field_9716), new class_2073(CNTag.ItemTags.ANTI_RADIATION_BOOTS_DYE.tag, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, class_2105.field_9716)})).after(ANTI_RADIATION_ARMOR));
    public static final CreateNuclearAdvancement DYE_ANTI_RADIATION_ARMOR = CNAdvancement.create("dye_anti_radiation_armor", b -> b.icon((ItemProviderEntry<?>)CNItems.ANTI_RADIATION_HELMETS.get(class_1767.field_7964)).title("Pimp My Armor").description("Dye your anti radiation armor to any color").whenItemCollected(CNTag.ItemTags.ANTI_RADIATION_HELMET_DYE.tag).whenItemCollected(CNTag.ItemTags.ANTI_RADIATION_CHESTPLATE_DYE.tag).whenItemCollected(CNTag.ItemTags.ANTI_RADIATION_LEGGINGS_DYE.tag).after(ANTI_RADIATION_ARMOR));
    public static final CreateNuclearAdvancement AUTOMATIC_URANIUM = CNAdvancement.create("automatic_uranium", b -> b.icon((ItemProviderEntry<?>)CNItems.URANIUM_POWDER).title("Automating Uranium").description("Obtain some uranium powder using the automatic uranium processing").after(ROOT).special(CreateNuclearAdvancement.TaskType.SECRET));
    public static final CreateNuclearAdvancement REACTOR_CASING = CNAdvancement.create("reactor_casing", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REACTOR_CASING).title("The Power Of The Reactor").description("Craft a reactor casing to begin building your nuclear reactor").after(ROOT).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_CONTROLLER = CNAdvancement.create("reactor_controller", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REACTOR_CONTROLLER).title("Controller Of The Core").description("Craft a reactor controller to manage and regulate your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_BLUEPRINT = CNAdvancement.create("reactor_blueprint", b -> b.icon((ItemProviderEntry<?>)CNItems.REACTOR_BLUEPRINT).title("Blueprint For Power").description("Craft a reactor blueprint to design the layout of rods in your reactor").after(REACTOR_CONTROLLER).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_COOLER = CNAdvancement.create("reactor_cooler", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REACTOR_COOLER).title("Cooling The Reactor").description("Craft a reactor cooler to cool your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_FRAME = CNAdvancement.create("reactor_frame", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REACTOR_FRAME).title("Reactor Frame").description("Craft a reactor frame to build your nuclear reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_INPUT = CNAdvancement.create("reactor_input", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REACTOR_INPUT).title("Fueling The Reactor").description("Craft a reactor input to feed uranium and graphite rods into your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_OUTPUT = CNAdvancement.create("reactor_output", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REACTOR_OUTPUT).title("Power Output").description("Craft a reactor output to transfer the energy produced by your reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement REACTOR_CORE = CNAdvancement.create("reactor_core", b -> b.icon((ItemProviderEntry<?>)CNBlocks.REACTOR_CORE).title("Core of Power").description("Craft the reactor core to harness the full energy of your nuclear reactor").after(REACTOR_CASING).whenIconCollected());
    public static final CreateNuclearAdvancement END = null;
    private final class_7784 output;

    private static CreateNuclearAdvancement create(String id, UnaryOperator<CreateNuclearAdvancement.Builder> b) {
        return new CreateNuclearAdvancement(id, b);
    }

    public CNAdvancement(FabricDataOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        class_7784.class_7489 pathProvider = this.output.method_45973(class_7784.class_7490.field_39367, "advancements");
        ArrayList futures = new ArrayList();
        HashSet set = Sets.newHashSet();
        Consumer<class_161> consumer = advancement -> {
            class_2960 id = advancement.method_688();
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
            }
            Path path = pathProvider.method_44107(id);
            futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)advancement.method_689().method_698(), (Path)path));
        };
        for (CreateNuclearAdvancement advancement2 : ENTRIES) {
            advancement2.save(consumer);
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String method_10321() {
        return "Create Nuclear Advancements";
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (CreateNuclearAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }
}

